<?php

namespace WPHealth\Services;

if (!defined('ABSPATH')) {
    exit;
}

class Option
{
    /**
     * @var array
     */
    protected $optionsDefault = [
        'api_key'                       => '',
        'allowed'                       => false,
    ];

    /**
     * Get options default.
     *
     * @return array
     */
    public function getOptionsDefault()
    {
        return $this->optionsDefault;
    }

    /**
     * @return array
     */
    public function getOptions()
    {
        return apply_filters(
            'wp_umbrella_get_options',
            wp_parse_args(get_option(WP_UMBRELLA_SLUG), $this->getOptionsDefault())
        );
    }

    /**
     * @param string $name Key name option
     *
     * @return array
     */
    public function getOption($name)
    {
        $options = $this->getOptions();
        if (!array_key_exists($name, $options)) {
            return null;
        }

        return apply_filters('wp_umbrella_' . $name . '_option', $options[$name]);
    }

    /**
     * @param array $options
     *
     * @return $this
     */
    public function setOptions($options)
    {
        update_option(WP_UMBRELLA_SLUG, $options);

        return $this;
    }

    /**
     * @param string $key
     * @param mixed  $value
     *
     * @return $this
     */
    public function setOptionByKey($key, $value)
    {
        $options = $this->getOptions();
        $options[$key] = $value;
        $this->setOptions($options);

        return $this;
    }
}
