<?php

namespace WPHealth\Services;

if (!defined('ABSPATH')) {
    exit;
}

class Register
{
    public function __construct(Option $option)
    {
        $this->optionService = $option;
    }

    /**
     * @param array $data
     *
     * @return User|null
     */
    public function register($data)
    {
        $response = wp_remote_post(WP_UMBRELLA_API_URL . '/api/customers/create', [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode([
                'email'                  => $data['email'],
                'password'               => $data['password'],
                'firstname'              => $data['firstname'],
                'lastname'               => $data['lastname'],
                'hosting'                => $data['hosting'],
                'newsletters'            => $data['newsletters'],
                'with_project'           => true,
                'base_url'               => site_url(),
                'project_name'           => get_bloginfo('name'),
                'terms'                  => true,
            ]),
            'timeout'     => 50,
        ]);

        if (is_wp_error($response)) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        if (!$body['success']) {
            return $body;
        }

        $user = $body['result'];

        return $user;
    }

    public function login($email, $password)
    {
        $response = wp_remote_post(WP_UMBRELLA_API_URL . '/api/external/login', [
            'body' => [
                'email'               => $email,
                'password'            => $password,
            ],
            'timeout' => 50,
        ]);

        if (is_wp_error($response)) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        if (!$body['success']) {
            return null;
        }

        $user = $body['result'];

        $options = $this->optionService->getOptions();

        $options['api_key'] = $user['project']['api_key'];
        $options['allowed'] = true;
        $this->optionService->setOptions($options);

        return $user;
    }
}
