<?php

namespace WPHealth\Services;

if (!defined('ABSPATH')) {
    exit;
}

class WordPressData
{
    /**
     * @return array
     */
    public function getDisallowListPostTypes()
    {
        return apply_filters('wp_umbrella_disallow_post_types', [
            'attachment',
            'seopress_404',
            'elementor_library',
        ]);
    }

    /**
     * @return array
     */
    public function getAllPostTypes()
    {
        $args = [
            'public' => true,
        ];

        $postTypes = get_post_types($args, 'objects');
        foreach ($this->getDisallowListPostTypes() as $value) {
            if (array_key_exists($value, $postTypes)) {
                unset($postTypes[$value]);
            }
        }

        return apply_filters('wp_umbrella_get_all_post_types', $postTypes);
    }

    /**
     * @param string $search
     *
     * @return array
     */
    public function searchPost($search)
    {
        global $wpdb;

        $postTypes = $this->getAllPostTypes();

        $sqlQuery = 'SELECT p.ID, p.post_title, p.post_type ';
        $sqlQuery .= "FROM {$wpdb->posts} p ";
        $sqlQuery .= 'WHERE 1=1 ';
        $sqlQuery .= "AND ( p.post_content LIKE '%$search%' OR p.post_title LIKE '%$search%' )";
        $sqlQuery .= sprintf("AND p.post_type IN ('%s') ", implode("','", array_keys($postTypes)));
        $sqlQuery .= "AND p.post_status = 'publish' ";
        $sqlQuery .= 'LIMIT 50';

        $result = $wpdb->get_results(
            $wpdb->prepare(
                apply_filters('wp_umbrella_search_post', $sqlQuery
            )
        ), ARRAY_A);

        if (empty($result)) {
            return [];
        }

        return $result;
    }
}
