<?php
/*
Plugin Name: WP Umbrella
Description: WP Umbrella Monitors the uptime, performance, health and security of your WordPress website! If anything goes wrong, you'll be alerted !
Author: WP Umbrella
Author URI: https://wp-umbrella.com/
Text Domain: wp-health
Domain Path: /languages/
Version: 1.1.4
License: GPLv2
*/

if (!defined('ABSPATH')) {
    exit;
}

require_once __DIR__ . '/vendor/autoload.php';

use WPHealth\Core\Kernel;

define('WP_UMBRELLA_NAME', 'WP Umbrella');
define('WP_UMBRELLA_SLUG', 'wp-health');
define('WP_UMBRELLA_OPTION_GROUP', 'group-wp-health');
define('WP_UMBRELLA_VERSION', '1.1.4');
define('WP_UMBRELLA_GOD_HANDLER_VERSION', '1.0.0');
define('WP_UMBRELLA_PHP_MIN', '7.2');
define('WP_UMBRELLA_BNAME', plugin_basename(__FILE__));
define('WP_UMBRELLA_DIR', __DIR__);
define('WP_UMBRELLA_LANGUAGES', WP_UMBRELLA_DIR . '/languages/');
define('WP_UMBRELLA_DIR_DIST', WP_UMBRELLA_DIR . '/dist');
define('WP_UMBRELLA_SITE_URL', 'https://wp-umbrella.com');
define('WP_UMBRELLA_APP_URL', 'https://app.wp-umbrella.com');
define('WP_UMBRELLA_API_URL', 'https://external-wp-umbrella.herokuapp.com');

define('WP_UMBRELLA_DIRURL', plugin_dir_url(__FILE__));
define('WP_UMBRELLA_URL_DIST', WP_UMBRELLA_DIRURL . 'dist');

define('WP_UMBRELLA_TEMPLATES', WP_UMBRELLA_DIR . '/templates');
define('WP_UMBRELLA_TEMPLATES_ADMIN', WP_UMBRELLA_TEMPLATES . '/admin');
define('WP_UMBRELLA_TEMPLATES_ADMIN_NOTICES', WP_UMBRELLA_TEMPLATES_ADMIN . '/notices');
define('WP_UMBRELLA_TEMPLATES_ADMIN_PAGES', WP_UMBRELLA_TEMPLATES_ADMIN . '/pages');

Kernel::execute(['file' => __FILE__, 'slug' => 'wp-health']);
