<?php

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Kernel;

/**
 * Get a service.
 *
 * @param string $service
 *
 * @return object
 */
function wp_umbrella_get_service($service)
{
    return Kernel::getContainer()->get($service);
}

/**
 * Get all options.
 *
 * @return array
 */
function wp_umbrella_get_options()
{
    return wp_umbrella_get_service('Option')->getOptions();
}

/**
 * Get option.
 *
 * @param string $key
 *
 * @return any
 */
function wp_umbrella_get_option($key)
{
    return wp_umbrella_get_service('Option')->getOption($key);
}

/**
 * @return bool
 */
function wp_umbrella_allowed()
{
    return wp_umbrella_get_option('allowed');
}

/**
 * Get API KEY.
 *
 * @return string | false
 */
function wp_umbrella_get_api_key()
{
    return wp_umbrella_get_option('api_key');
}
