local STRINGS = GLOBAL.STRINGS
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS

PrefabFiles = {
	"kyle",
	"wormspider",
	"worm_spiderling",
	"worm_fighter",
	"worm_rocky",
	"worm_flying",
	"worm_warrior",
	"worm_assassin",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/kyle.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/kyle.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/kyle.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kyle.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/kyle_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kyle_silho.xml" ),

    Asset( "IMAGE", "bigportraits/kyle.tex" ),
    Asset( "ATLAS", "bigportraits/kyle.xml" ),
	
	Asset( "IMAGE", "images/map_icons/kyle.tex" ),
	Asset( "ATLAS", "images/map_icons/kyle.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/wormspider_recipe.tex" ),
	Asset( "ATLAS", "images/inventoryimages/wormspider_recipe.xml" ),

}

local require = GLOBAL.require

local function ModMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "kyle" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
	{
		appearsound = "dontstarve/maxwell/disappear",
	    voice = "dontstarve/maxwell/talk_LP",
		appearanim = "appear",
		idleanim= "idle",
		dialogpreanim = "dialog_pre",
		dialoganim="dial_loop",
		dialogpostanim = "dialog_pst",
		disappearanim = "disappear",
		disableplayer = true,
		skippable = true,
		{
			string = "Braglgragbdabbleshazcragglegomphf.",
			wait = 3,
			anim = nil,
			sound = nil,
		},
		{
			string = "Eelchflombondarschitooeypitooniafloggyblah.", 
			wait = 3, 
			anim = nil, 
			sound = nil,
		},
	}
	end
end
	
	AddPrefabPostInit("maxwellintro", ModMaxwellIntro)
	
-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.kyle = "The Symbiont"
GLOBAL.STRINGS.CHARACTER_NAMES.kyle = "Kyle"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.kyle = "*Terrible at combat.\n*Slowly goes insane.\n*Can command army of Worm Spiders."
GLOBAL.STRINGS.CHARACTER_QUOTES.kyle = "\"NOW ASSUMING DIRECT CONTROL.\""

-- Custom speech strings
GLOBAL.STRINGS.CHARACTERS.KYLE = require "speech_kyle"

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "kyle")

AddMinimapAtlas("images/map_icons/kyle.xml")
AddModCharacter("kyle")

---------------------------------------------------------------------------------------------------------------------------------
--- [Worm Spiders]
STRINGS.NAMES.WORMSPIDER = "Worm Spider"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORMSPIDER = "An old friend."
GLOBAL.STRINGS.RECIPE_DESC.WORMSPIDER = "A worm who fights at your side."

STRINGS.NAMES.WORM_SPIDERLING = "Worm Spiderling"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORM_SPIDERLING = "Hello, little one."
GLOBAL.STRINGS.RECIPE_DESC.WORM_SPIDERLING = "Supportive outside of combat."

STRINGS.NAMES.WORM_FIGHTER = "Worm Fighter"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORM_FIGHTER = "You've been working out, haven't you?"
GLOBAL.STRINGS.RECIPE_DESC.WORM_FIGHTER = "Bigger and tougher."

STRINGS.NAMES.WORM_ROCKY = "Bulky Worm Spider"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORM_ROCKY = "Disappointingly bad at boxing."
GLOBAL.STRINGS.RECIPE_DESC.WORM_ROCKY = "A veritable stone wall."

STRINGS.NAMES.WORM_FLYING = "Speedy Worm Spider"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORM_FLYING = "Too small to ride, unfortunately."
GLOBAL.STRINGS.RECIPE_DESC.WORM_FLYING = "Avoids foes, hits from a distance."

STRINGS.NAMES.WORM_WARRIOR = "Worm Spider Warrior"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORM_WARRIOR = "He doesn't live the thug life. The thug life lives him."
GLOBAL.STRINGS.RECIPE_DESC.WORM_WARRIOR = "A skilled fighter."

STRINGS.NAMES.WORM_ASSASSIN = "Worm Spider Assassin"
STRINGS.CHARACTERS.KYLE.DESCRIBE.WORM_ASSASSIN = "The outclassin' assassin."
GLOBAL.STRINGS.RECIPE_DESC.WORM_ASSASSIN = "The glass cannon."

function lootdropperpostinit(inst)

	inst.GenerateLoot = function(self)
    local loots = {}
    if self.numrandomloot and math.random() <= (self.chancerandomloot or 1) then
		for k = 1, self.numrandomloot do
		    local loot = self:PickRandomLoot()
		    if loot then
			    table.insert(loots, loot)
			end
		end
	end
    if self.chanceloot then
		for k,v in pairs(self.chanceloot) do
			if math.random() < v.chance then
				table.insert(loots, v.prefab)
				self.droppingchanceloot = true
			end
		end
	end
    if self.chanceloottable then
    	local loot_table = GLOBAL.LootTables[self.chanceloottable]
    	if loot_table then
    		for i, entry in ipairs(loot_table) do
    			local prefab = entry[1]
    			local chance = entry[2]    			
				if math.random() <= chance then
					table.insert(loots, prefab)
					self.droppingchanceloot = true
				end
			end
		end
	end
	if not self.droppingchanceloot and self.ifnotchanceloot then
		self.inst:PushEvent("ifnotchanceloot")
		for k,v in pairs(self.ifnotchanceloot) do
			table.insert(loots, v.prefab)
		end
	end
    if self.loot then
		for k,v in ipairs(self.loot) do
			table.insert(loots, v)
		end
	end
	local recipe = GLOBAL.GetRecipe(self.inst.prefab)
	if recipe and not self.inst.components.norecipelootdrop then
		local percent = 1
		if self.inst.components.finiteuses then
			percent = self.inst.components.finiteuses:GetPercent()
		end
		for k,v in ipairs(recipe.ingredients) do
			local amt = math.ceil( (v.amount * TUNING.HAMMER_LOOT_PERCENT) * percent)
			for n = 1, amt do
				table.insert(loots, v.type)
			end
		end
	end
    return loots
    end
end	      
AddComponentPostInit("lootdropper", lootdropperpostinit)