require "behaviours/follow"
require "behaviours/wander"
require "behaviours/chaseandattack"
require "behaviours/runaway"

local WormspiderBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local MIN_FOLLOW = 8
local MAX_FOLLOW = 17
local MED_FOLLOW = 5
local MAX_WANDER_DIST = 12
local MAX_CHASE_TIME = 10

local MIN_FOLLOW_LEADER = 8
local MAX_FOLLOW_LEADER = 12
local RUN_START_DIST = 7
local RUN_STOP_DIST = 15


local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

local function ShouldRunAway(guy)
    return not guy:HasTag("character") and not guy:HasTag("wormspider") and (guy:HasTag("character") or guy:HasTag("monster")) and not guy:HasTag("notarget")
end

local function CanAttackNow(inst)
    return inst.components.combat.target == nil or not inst.components.combat:InCooldown()
end

function WormspiderBrain:OnStart()

    local root = PriorityNode(
    {
	
		RunAway(self.inst, ShouldRunAway, RUN_START_DIST, RUN_STOP_DIST),
		
		ChaseAndAttack(self.inst, MAX_CHASE_TIME),
		Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW, MED_FOLLOW, MAX_FOLLOW, true),
		--FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),
        Wander(self.inst, function() return Point(GetPlayer().Transform:GetWorldPosition()) end , MAX_WANDER_DIST)        
    }, .5)
        
    self.bt = BT(self.inst, root)
         
end


return WormspiderBrain