local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/kyle.zip" ),
		
		Asset( "IMAGE", "images/tab_egg.tex" ),
		Asset( "ATLAS", "images/tab_egg.xml" ),
		Asset( "IMAGE", "images/inventoryimages/wormspider_recipe.tex" ),
		Asset( "ATLAS", "images/inventoryimages/wormspider_recipe.xml" ),
}
local prefabs = {}
local start_inv = {
	-- Custom starting items
}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "maxwell"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "kyle.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(175)
	inst.components.sanity:SetMax(175)
	inst.components.combat.damagemultiplier = 0.5
	inst.components.combat:SetAttackPeriod(0.75)
	inst.components.sanity.dapperness = (-TUNING.DAPPERNESS_SMALL)
	
------------------------------------------------------------------------------------------------------------------------

	local eggtab = {str = "Worm Eggs", sort=999, icon = "tab_egg.tex", icon_atlas = "images/tab_egg.xml"}
	inst.components.builder:AddRecipeTab(eggtab)
	
	local wormspider_recipe = Recipe("wormspider", {Ingredient("petals", 3), Ingredient("pinecone", 3), Ingredient("goldnugget", 1)}, eggtab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	wormspider_recipe.atlas = "images/inventoryimages/wormspider_recipe.xml"
		
	local wormfighter_recipe = Recipe("worm_fighter", {Ingredient("log", 5), Ingredient("smallmeat", 3), Ingredient("corn", 1)}, eggtab, {SCIENCE = 1})
	
	local wormspiderling_recipe = Recipe("worm_spiderling", {Ingredient("seeds", 5), Ingredient("silk", 3), Ingredient("cutgrass", 1)}, eggtab, {SCIENCE = 1})
	
	local wormrocky_recipe = Recipe("worm_rocky", {Ingredient("cutstone", 5), Ingredient("nitre", 3), Ingredient("flint", 3)}, eggtab, {SCIENCE = 2})
	
	local wormflying_recipe = Recipe("worm_flying", {Ingredient("silk", 5), Ingredient("spidergland", 3), Ingredient("papyrus", 3)}, eggtab, {SCIENCE = 2})
	
	local wormwarrior_recipe = Recipe("worm_warrior", {Ingredient("stinger", 5), Ingredient("monstermeat", 5), Ingredient("beefalowool", 3)}, eggtab, {MAGIC = 2})
	
	local wormassassin_recipe = Recipe("worm_assassin", {Ingredient("nightmarefuel", 5), Ingredient("spoiled_food", 5), Ingredient("tentaclespike", 1)}, eggtab, {MAGIC = 2})
	
end

return MakePlayerCharacter("kyle", prefabs, assets, fn, start_inv)
