--[NEW] Here we list any assets required by our prefab.
local assets=
{
	--[NEW] this is the name of the Spriter file.
	Asset("ANIM", "anim/worm_spiderling.zip"),
}

SetSharedLootTable( 'worm_flying',
{
    {'silk',            1.00},
	{'silk',            1.00},
	{'spidergland',            1.00},
})

local function OnNewTarget(inst, data, target)
    if data.target and data.target:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
end
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
    if attacker and attacker:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
	else
    inst.components.combat:SetTarget(attacker)
    inst.components.combat:ShareTarget(attacker, 10, function(dude) return dude:HasTag("companion") end, 5)
end
end

local function KeepTarget(inst, target)
    if target and target:HasTag("bee") then
	return false
	else
    return inst.components.combat:CanTarget(target) and (not inst:HasTag("companion") or inst:IsNear(target, 20))
end
end

local function WormspiderSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return TUNING.SANITYAURA_TINY
	end
	
	return 0
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function init_prefab()

	local inst = CreateEntity()
	
	inst:AddTag("character")
	inst:AddTag("wormspider")
	inst:AddTag("companion")
	inst:AddComponent("inspectable")
	inst:AddTag("scarytoprey")
	inst:AddTag("noauradamage")
	inst:AddTag("flying")
	
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    anim:SetBank("wormspider")
    anim:SetBuild("worm_spiderling")
	inst.Transform:SetFourFaced()
	inst.Transform:SetScale(0.9,0.9,0.9)
	
    inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 10
    inst.components.locomotor.runspeed = 13
	
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon("wormspider.tex")
	
	inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 2, .5 )
	
	inst:AddComponent("health")
    inst.components.health:SetMaxHealth(150) 
	inst.components.health:StartRegen(1, 2)
	
	inst:AddComponent("combat")
    inst.components.combat:SetRange(15, 17.5)
    inst.components.combat:SetAttackPeriod(2)
	inst.components.combat:SetDefaultDamage(25)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	
	inst:AddComponent("norecipelootdrop")
    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable('worm_flying')
	
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = WormspiderSanityAura
	
	MakeCharacterPhysics(inst, 10, .5)
	inst.Physics:SetCollisionGroup(COLLISION.FLYERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
	inst.Physics:CollidesWith(COLLISION.OBSTACLES)
	
	inst:AddComponent("follower")
	
	inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewTarget)
	
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
    inst:SetStateGraph("SGwormspider")
    local brain = require "brains/wormflyingbrain"
	inst:SetBrain(brain)

    return inst
end

--[NEW] Here we register our new prefab so that it can be used in game.
return Prefab( "monsters/worm_flying", init_prefab, assets, nil)
