--[NEW] Here we list any assets required by our prefab.
local assets=
{
	--[NEW] this is the name of the Spriter file.
	Asset("ANIM", "anim/worm_fighter.zip"),
}

SetSharedLootTable( 'worm_rocky',
{
    {'goldnugget',            1.00},
	{'goldnugget',            1.00},
	{'marble',            1.00},
})

local function OnNewTarget(inst, data, target)
    if data.target and data.target:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
end
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
    if attacker and attacker:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
	else
    inst.components.combat:SetTarget(attacker)
    inst.components.combat:ShareTarget(attacker, 10, function(dude) return dude:HasTag("companion") end, 5)
end
end

local function KeepTarget(inst, target)
    return inst.components.combat:CanTarget(target) and (not inst:HasTag("companion") or inst:IsNear(target, 20))
end

local function WormspiderSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return TUNING.SANITYAURA_TINY
	end
	
	return 0
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function create_rocky()

	local inst = CreateEntity()
	
	inst:AddTag("character")
	inst:AddTag("wormspider")
	inst:AddTag("companion")
	inst:AddComponent("inspectable")
	inst:AddTag("scarytoprey")
	inst:AddTag("noauradamage")
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.AnimState:SetBank("wormspider")
    inst.AnimState:SetBuild("worm_fighter")
	inst.Transform:SetFourFaced()
	inst.Transform:SetScale(1.5,1.5,1.5)
    inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 4
	
	inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 2, .5 )
	
	inst:AddComponent("health")
    inst.components.health:SetMaxHealth(1000) 
	inst.components.health:StartRegen(1, 1)
	
	inst:AddComponent("combat")
    inst.components.combat:SetRange(4, 4.5)
    inst.components.combat:SetAttackPeriod(3)
	inst.components.combat:SetDefaultDamage(25)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	
	inst:AddComponent("norecipelootdrop")
    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable('worm_rocky')
	
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = WormspiderSanityAura
	
	MakeCharacterPhysics(inst, 10, 1)
	
	inst:AddComponent("follower")
	
	inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewTarget)
	
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
    inst:SetStateGraph("SGwormrocky")
    local brain = require "brains/wormspiderbrain"
	inst:SetBrain(brain)

    return inst
end

--[NEW] Here we register our new prefab so that it can be used in game.
return Prefab( "monsters/worm_rocky", create_rocky, assets, nil)
