--[NEW] Here we list any assets required by our prefab.
local assets=
{
	--[NEW] this is the name of the Spriter file.
	Asset("ANIM", "anim/worm_spiderling.zip"),
}

SetSharedLootTable( 'worm_spiderling',
{
	{'smallmeat',            1.00},
})

local function OnNewTarget(inst, data, target)
    if data.target and data.target:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
end
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
    if attacker and attacker:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
	else
    inst.components.combat:SetTarget(attacker)
    inst.components.combat:ShareTarget(attacker, 10, function(dude) return dude:HasTag("companion") end, 5)
end
end

local function KeepTarget(inst, target)
    if target and target:HasTag("bee") then
	return false
	else
    return inst.components.combat:CanTarget(target) and (not inst:HasTag("companion") or inst:IsNear(target, 20))
end
end

local function WormspiderSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return TUNING.SANITYAURA_SMALL
	end
	
	return 0
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function create_wormspiderling()

	local inst = CreateEntity()
	
	inst:AddTag("character")
	inst:AddTag("wormspider")
	inst:AddTag("companion")
	inst:AddComponent("inspectable")
	inst:AddTag("noauradamage")
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.AnimState:SetBank("wormspider")
    inst.AnimState:SetBuild("worm_spiderling")
	inst.Transform:SetScale(0.8,0.8,0.8)
	inst.Transform:SetFourFaced()
	
    inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 8
    inst.components.locomotor.runspeed = 11
	
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon("wormspider.tex")
	
	inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 2, .5 )
	
	inst:AddComponent("health")
    inst.components.health:SetMaxHealth(100) 
	inst.components.health:StartRegen(5, 2)
	
	inst:AddComponent("combat")
    inst.components.combat:SetRange(2, 3)
    inst.components.combat:SetAttackPeriod(1)
	inst.components.combat:SetDefaultDamage(10)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
		
	inst:AddComponent("norecipelootdrop")
    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable('worm_spiderling')
	
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = WormspiderSanityAura
	
	MakeCharacterPhysics(inst, 7, .5)
	
	inst:AddComponent("follower")
	
	inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewTarget)
	
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
    inst:SetStateGraph("SGwormspider")
    local brain = require "brains/spiderlingbrain"
	inst:SetBrain(brain)

    return inst
end

--[NEW] Here we register our new prefab so that it can be used in game.
return Prefab( "monsters/worm_spiderling", create_wormspiderling, assets, nil)
