--[NEW] Here we list any assets required by our prefab.
local assets=
{
	--[NEW] this is the name of the Spriter file.
	Asset("ANIM", "anim/wormspider.zip"),
}

SetSharedLootTable( 'worm_warrior',
{
    {'monstermeat_dried',            0.66},
	{'monstermeat_dried',            0.66},
	{'monstermeat_dried',            0.66},
	{'houndstooth',            1.00},
	{'houndstooth',            1.00},
})

local function OnNewTarget(inst, data, target)
    if data.target and data.target:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
end
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
    if attacker and attacker:HasTag("player") then
		inst.components.combat.damagemultiplier = 0.5
	else
    inst.components.combat:SetTarget(attacker)
    inst.components.combat:ShareTarget(attacker, 10, function(dude) return dude:HasTag("companion") end, 5)
end
end

local function KeepTarget(inst, target)
    return inst.components.combat:CanTarget(target) and (not inst:HasTag("companion") or inst:IsNear(target, 20))
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function init_prefab()

	local inst = CreateEntity()
	
	inst:AddTag("character")
	inst:AddTag("wormspider")
	inst:AddTag("companion")
	inst:AddComponent("inspectable")
	inst:AddTag("scarytoprey")
	inst:AddTag("noauradamage")
	
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    anim:SetBank("wormspider")
    anim:SetBuild("wormspider")
	inst.Transform:SetFourFaced()
	inst.Transform:SetScale(1.35,1.35,1.35)
	
    inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 6
    inst.components.locomotor.runspeed = 6
	
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon("wormspider.tex")
	
	inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 2, .5 )
	
	inst:AddComponent("health")
    inst.components.health:SetMaxHealth(500) 
	inst.components.health:StartRegen(1, 2)
	
	inst:AddComponent("combat")
    inst.components.combat:SetRange(3, 3.5)
    inst.components.combat:SetAttackPeriod(2)
	inst.components.combat:SetDefaultDamage(50)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
		
	inst:AddComponent("norecipelootdrop")
    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable('worm_warrior')
	
	MakeCharacterPhysics(inst, 10, .5)
	
	inst:AddComponent("follower")
	
	inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewTarget)
	
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
    inst:SetStateGraph("SGwormspider")
    local brain = require "brains/wormspiderbrain"
	inst:SetBrain(brain)

    return inst
end

--[NEW] Here we register our new prefab so that it can be used in game.
return Prefab( "monsters/worm_warrior", init_prefab, assets, nil)
