require("stategraphs/commonstates")

local actionhandlers = 
{
}

local events=
{

	CommonHandlers.OnStep(),
	CommonHandlers.OnLocomote(false,true),
    EventHandler("death", function(inst) inst.sg:GoToState("death") end),
	
    EventHandler("doattack", function(inst, data) 
        if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") and data and data.target then 
            inst.sg:GoToState("attack", data.target) 
        end 
    end),
	
	EventHandler("attacked", function(inst) 
        if not inst.components.health:IsDead() then 
            if not inst.sg:HasStateTag("attack") then -- don't interrupt attack or exit shield
                inst.sg:GoToState("hit") -- can still attack
            end
        end 
    end),
	
    EventHandler("locomote", function(inst) 
        if not inst.sg:HasStateTag("busy") then
            
            local is_moving = inst.sg:HasStateTag("moving")
            local wants_to_move = inst.components.locomotor:WantsToMoveForward()
            if not inst.sg:HasStateTag("attack") and is_moving ~= wants_to_move then
                if wants_to_move then
                    inst.sg:GoToState("moving")
                else
                    inst.sg:GoToState("idle")
                end
            end
        end
    end),  	
}

local states=
{
	--This handles the idle state.
    State{

        name = "idle",
        tags = {"idle", "canrotate"},

        onenter = function(inst, playanim)
            inst.AnimState:PlayAnimation("idle", true)
        end,

    },
	
	State{
		name = "moving",
        tags = {"canrotate", "moving", "walk"},

        onenter = function(inst)
            inst.components.locomotor:RunForward()
            inst.AnimState:PlayAnimation("walk", true)       
        end,
    },    


    State{
        name = "attack",
        tags = {"attack", "busy"},
        
        onenter = function(inst, target)
            inst.Physics:Stop()
            inst.components.combat:StartAttack()
            inst.AnimState:PlayAnimation("atk")
            inst.sg.statemem.target = target
        end,
        
        timeline=
        {
            TimeEvent(10*FRAMES, function(inst) inst.components.combat:DoAttack(inst.sg.statemem.target) end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	
    State{
        name = "hit",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.AnimState:PlayAnimation("hit")
            inst.Physics:Stop()            
        end,
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },
    },
	
	State{
        name = "death",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.AnimState:PlayAnimation("death")
            inst.Physics:Stop()
            RemovePhysicsColliders(inst)            
            inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))            
        end,
    },   
}

return StateGraph("wormspider", states, events, "idle", actionhandlers)