/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import me.ferdz.placeableitems.block.BlockFaceable;
import me.ferdz.placeableitems.block.IBlockBiPosition;
import me.ferdz.placeableitems.state.EnumPreciseFacing;
import me.ferdz.placeableitems.state.EnumUpDown;
import me.ferdz.placeableitems.utils.BiPositionUtils;
import me.ferdz.placeableitems.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBiPosition
extends BlockFaceable
implements IBlockBiPosition {
    public static final PropertyEnum<EnumUpDown> POSITION = PropertyEnum.func_177709_a((String)"position", EnumUpDown.class);

    public BlockBiPosition(String name) {
        super(name);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB box = super.func_185496_a(state, source, pos);
        return BiPositionUtils.getReverseBound(box, (EnumUpDown)((Object)state.func_177229_b(POSITION)));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return true;
        }
        return Utils.isValidBlock((IBlockAccess)worldIn, pos.func_177973_b(new Vec3i(0, 1, 0)));
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return BiPositionUtils.canBlockStay((EnumUpDown)((Object)state.func_177229_b(POSITION)), (IBlockAccess)world, pos);
    }

    @Override
    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.DOWN) {
            return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(POSITION, (Comparable)((Object)EnumUpDown.UP));
        }
        return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(POSITION, (Comparable)((Object)EnumUpDown.DOWN));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState s = super.func_176203_a(meta % 8);
        s = s.func_177226_a(POSITION, (Comparable)((Object)EnumUpDown.values()[meta / 8]));
        return s;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int face = ((EnumPreciseFacing)((Object)state.func_177229_b((IProperty)FACING))).ordinal();
        int position = ((EnumUpDown)((Object)state.func_177229_b(POSITION))).getID();
        return face + position * 8;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POSITION, FACING});
    }
}

