/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.Random;
import me.ferdz.placeableitems.block.BlockFaceable;
import me.ferdz.placeableitems.state.EnumClockSide;
import me.ferdz.placeableitems.state.EnumPreciseFacing;
import me.ferdz.placeableitems.state.EnumTime;
import me.ferdz.placeableitems.tileentity.TEClock;
import me.ferdz.placeableitems.utils.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockClock
extends BlockFaceable
implements ITileEntityProvider {
    public static final PropertyEnum<EnumTime> TIME = PropertyEnum.func_177709_a((String)"time", EnumTime.class);
    public static final PropertyEnum<EnumClockSide> SIDE = PropertyEnum.func_177709_a((String)"side", EnumClockSide.class);

    public BlockClock(String name) {
        super(name);
        this.func_149675_a(true);
        this.field_149758_A = true;
    }

    @Override
    public void onBlockPlacedBySide(EnumFacing side, BlockPos pos, EntityPlayer player, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TEClock) {
            TEClock clock = (TEClock)te;
            switch (side) {
                case EAST: {
                    clock.setSide(EnumClockSide.EAST);
                    return;
                }
                case WEST: {
                    clock.setSide(EnumClockSide.WEST);
                    return;
                }
                case NORTH: {
                    clock.setSide(EnumClockSide.NORTH);
                    return;
                }
                case SOUTH: {
                    clock.setSide(EnumClockSide.SOUTH);
                    return;
                }
                case UP: {
                    clock.setSide(EnumClockSide.DOWN);
                    return;
                }
            }
        }
    }

    @Override
    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        switch (facing) {
            case EAST: {
                return state.func_177226_a((IProperty)FACING, (Comparable)((Object)EnumPreciseFacing.D0));
            }
            case SOUTH: {
                return state.func_177226_a((IProperty)FACING, (Comparable)((Object)EnumPreciseFacing.D90));
            }
            case WEST: {
                return state.func_177226_a((IProperty)FACING, (Comparable)((Object)EnumPreciseFacing.D180));
            }
            case NORTH: {
                return state.func_177226_a((IProperty)FACING, (Comparable)((Object)EnumPreciseFacing.D270));
            }
        }
        return state;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TEClock) {
            TEClock clock = (TEClock)te;
            switch (clock.getSide()) {
                case WEST: {
                    return AABBUtils.rotate(this.boundingBox, 135);
                }
                case EAST: {
                    return AABBUtils.rotate(this.boundingBox, 45);
                }
                case NORTH: {
                    return AABBUtils.rotate(this.boundingBox, 90);
                }
                case SOUTH: {
                    return this.boundingBox;
                }
                case DOWN: {
                    return AABBUtils.rotate(this.boundingBox, 45, EnumFacing.Axis.X);
                }
            }
        }
        return this.boundingBox;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN;
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        worldIn.func_175704_b(pos, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TEClock) {
            TEClock clock = (TEClock)te;
            state = state.func_177226_a(SIDE, (Comparable)((Object)clock.getSide()));
        }
        if (world.field_73011_w.func_76569_d()) {
            long time = world.func_72820_D() % 24000L * 63L / 24000L - 16L;
            if (time < 0L) {
                time = 64L + time;
            }
            return state.func_177226_a(TIME, (Comparable)((Object)EnumTime.values()[(int)time]));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIDE, TIME, FACING});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TEClock();
    }
}

