/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.Random;
import me.ferdz.placeableitems.block.BlockFaceable;
import me.ferdz.placeableitems.state.EnumIngot;
import me.ferdz.placeableitems.state.EnumPreciseFacing;
import me.ferdz.placeableitems.state.EnumStackSize;
import me.ferdz.placeableitems.tileentity.TEIngot;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockIngot
extends BlockFaceable
implements ITileEntityProvider {
    public static final PropertyEnum<EnumStackSize> STACK = PropertyEnum.func_177709_a((String)"stack", EnumStackSize.class);
    public static final PropertyEnum<EnumIngot> TYPE = PropertyEnum.func_177709_a((String)"type", EnumIngot.class);

    public BlockIngot(String name) {
        super(name);
        this.func_180632_j(super.func_176223_P().func_177226_a(STACK, (Comparable)((Object)EnumStackSize._1)));
        this.field_149758_A = true;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (playerIn.func_70093_af()) {
            ItemStack stack = null;
            switch ((EnumIngot)((Object)state.func_177229_b(TYPE))) {
                case GOLD: {
                    stack = new ItemStack(Items.field_151043_k, 1);
                    break;
                }
                case IRON: {
                    stack = new ItemStack(Items.field_151042_j, 1);
                }
            }
            if (te instanceof TEIngot) {
                EntityItem drop = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                worldIn.func_72838_d((Entity)drop);
                if (--((TEIngot)te).stackSize == 0) {
                    worldIn.func_175698_g(pos);
                }
                worldIn.func_184138_a(pos, state, state, 2);
                te.func_70296_d();
            }
            return true;
        }
        if (heldItem == null) {
            return false;
        }
        switch ((EnumIngot)((Object)state.func_177229_b(TYPE))) {
            case GOLD: {
                if (heldItem.func_77973_b() == Items.field_151043_k) break;
                return false;
            }
            case IRON: {
                if (heldItem.func_77973_b() == Items.field_151042_j) break;
                return false;
            }
        }
        if (te instanceof TEIngot) {
            int stackSize = ((TEIngot)te).stackSize;
            if (stackSize == 6) {
                return false;
            }
            if (!playerIn.func_184812_l_()) {
                heldItem.func_190917_f(-1);
            }
            ++((TEIngot)te).stackSize;
            worldIn.func_184138_a(pos, state, state, 2);
            te.func_70296_d();
        }
        return false;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TEIngot) {
            switch ((EnumIngot)((Object)state.func_177229_b(TYPE))) {
                case GOLD: {
                    return new ItemStack(Items.field_151043_k, ((TEIngot)te).stackSize);
                }
                case IRON: {
                    return new ItemStack(Items.field_151042_j, ((TEIngot)te).stackSize);
                }
            }
        }
        return null;
    }

    @Override
    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.func_184614_ca().func_77973_b().equals(Items.field_151043_k)) {
            return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(TYPE, (Comparable)((Object)EnumIngot.GOLD));
        }
        if (placer.func_184614_ca().func_77973_b().equals(Items.field_151042_j)) {
            return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(TYPE, (Comparable)((Object)EnumIngot.IRON));
        }
        return null;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState s = super.func_176203_a(meta % 8);
        s = s.func_177226_a(TYPE, (Comparable)((Object)EnumIngot.values()[meta / 8]));
        return s;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int face = ((EnumPreciseFacing)((Object)state.func_177229_b((IProperty)FACING))).ordinal();
        int type = ((EnumIngot)((Object)state.func_177229_b(TYPE))).getID();
        return face + type * 8;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TEIngot) {
            return state.func_177226_a(STACK, (Comparable)((Object)EnumStackSize.values()[((TEIngot)te).stackSize - 1]));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STACK, TYPE, FACING});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TEIngot();
    }
}

