/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import java.util.UUID;
import me.ferdz.placeableitems.PlaceableItems;
import me.ferdz.placeableitems.block.IBlockPlaceableItems;
import me.ferdz.placeableitems.init.ModBlocks;
import me.ferdz.placeableitems.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockPlaceableItems
extends Block
implements IBlockPlaceableItems {
    protected AxisAlignedBB boundingBox;
    protected Item placedItem;

    public BlockPlaceableItems(String name) {
        this(name, Material.field_151575_d);
    }

    public BlockPlaceableItems(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    public BlockPlaceableItems setBoundingBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.boundingBox = new AxisAlignedBB(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
        return this;
    }

    @Override
    public BlockPlaceableItems setBoundingBox(double x, double y, double z) {
        return this.setBoundingBox(x, 0.0, z, 16.0 - x, y, 16.0 - z);
    }

    @Override
    public BlockPlaceableItems setBoundingBox(AxisAlignedBB a) {
        this.boundingBox = a;
        return this;
    }

    @Override
    public BlockPlaceableItems setItem(Item item) {
        this.placedItem = item;
        ModBlocks.blockMap.put(item, this);
        return this;
    }

    @Override
    public BlockPlaceableItems setItems(Item ... items) {
        for (Item item : items) {
            this.setItem(item);
        }
        return this;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.func_176196_c(world, pos);
    }

    @Override
    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!this.canBlockStay(worldIn, pos, state)) {
            BlockEvent.BreakEvent event = null;
            try {
                event = new BlockEvent.BreakEvent(worldIn, pos, state, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)worldIn), (GameProfile)new GameProfile(UUID.randomUUID(), "")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            PlaceableItems.blockBreakHandler.onBlockBreak(event);
            worldIn.func_175655_b(pos, true);
        }
    }

    @Override
    public void onBlockPlacedBySide(EnumFacing side, BlockPos pos, EntityPlayer player, World world) {
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        pos = pos.func_177973_b(new Vec3i(0, 1, 0));
        return Utils.isValidBlock((IBlockAccess)worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox != null ? this.boundingBox : field_185505_j;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.placedItem, 1);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.placedItem;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Override
    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.func_180495_p(pos);
        this.neighborChanged(state, (World)world, pos, state.func_177230_c());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack is = playerIn.func_184586_b(hand);
        return this.onBlockActivated(worldIn, pos, state, playerIn, hand, is, facing, hitX, hitY, hitZ);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }
}

