class CKNGFishingRodItem extends W3UsableItem {
	
	private var mCKNGFishingRod : CKNGFishingRod;
		
	default itemType = UI_None;

	event OnUsed(usedBy : CEntity) {
	
	
	
	if(usedBy == thePlayer) {
				
		mCKNGFishingRod = new CKNGFishingRod in theGame;		
		
		mCKNGFishingRod.Start();	
	
		}
	}	
}

statemachine class CKNGFishingRod extends W3UsableItem {

	var startAnimation						: name;
	var stopAnimation 						: name;
	var loopAnimation 						: name;
	var startUseAnimation					: name;	
		
	var possibleItemSlots					: array<name>;
	var fishTypes							: array<name>;
	
	var entity 								: CEntity;
	var entityTemplate 						: CEntityTemplate;

	var castedRod							: bool;
	var fishHooked							: bool;
	var randomLootTimer						: float;
	var floaterPos							: Vector;
	var catchTimer 							: int;
	
	default itemType = UI_None;
	
	event OnSpawned(spawnData : SEntitySpawnData) {		
				
		this.Init();
	}
	
	function Start() {
	
		StartFishing();	
	}
	
	function StartFishing() {
	
		if(CheckWater() == true) {
		
			entityTemplate = (CEntityTemplate)LoadResource("dlc\dlckngfishingrod\data\w2ent\kng_fishingrod.w2ent", true);
		
			entity = (CKNGFishingRod)theGame.CreateEntity(entityTemplate, thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation());			
		
		} else {
		
			return;		
		}	
	}
	
	function Init(){
				
		startAnimation = 'man_work_sitting_with_fishing_rod_start';
		stopAnimation = 'man_work_sitting_with_fishing_rod_stop';
		startUseAnimation = 'man_work_sitting_with_fishing_rod_gesture';
		loopAnimation = 'man_work_sitting_with_fishing_rod_idle';
								
		possibleItemSlots.Clear();
		possibleItemSlots.Resize(4);
		possibleItemSlots.PushBack('r_weapon');
		possibleItemSlots.PushBack('l_weapon');
		possibleItemSlots.PushBack('r_hand');
		possibleItemSlots.PushBack('l_hand');

		fishTypes.PushBack('kng_fish_1');
		fishTypes.PushBack('kng_fish_2');
		fishTypes.PushBack('kng_fish_3');
		fishTypes.PushBack('kng_fish_4');
		fishTypes.PushBack('kng_fish_5');
		
		thePlayer.AddBuffImmunity_AllCritical( 'W3SmartObject', true );
		thePlayer.AddBuffImmunity_AllNegative( 'W3SmartObject', true );		
		
		BlockPlayerActions();	
		
		this.PushState('StartUse');			
	}
	
	function GetRandomFish() : name{	
		
		var randomFish : name;	
		
		randomFish = fishTypes[RandRange(fishTypes.Size(),0)];		
		
		return randomFish;		
	}
	
	// scuffed CDPR stuff
	function CheckWater() : bool {
	
	var playerPos, waterPos 		: Vector;
	var currentWorld 				: CWorld;
	var waterLevel 					: float;
	var waterDepth 					: float;
	var minWaterDepth 				: float;
	var maxWaterDistance 			: float;
	var playerRadius 				: float;
	var distToWater 				: float;
	var tempPos						: Vector;
	var collisionGroups 			: array<name>;
	
	collisionGroups.PushBack( 'Water' );
	
	maxWaterDistance = 100.0f;
	minWaterDepth = -0.5f;
	
	currentWorld  = theGame.GetWorld();
	
	playerPos = thePlayer.GetWorldPosition();
	playerRadius = thePlayer.GetRadius();
	waterPos = playerPos + thePlayer.GetHeadingVector();	
	waterLevel = currentWorld.GetWaterLevel(waterPos);	
	
	distToWater = playerPos.Z - waterLevel;
	
		if(distToWater > maxWaterDistance) {
		
			return false;		
		}
		
		waterDepth = theGame.GetWorld().GetWaterDepth(playerPos);	

		if(waterDepth > 1000) {
	
			waterDepth = 0;	
		}			
		
		if(waterDepth < minWaterDepth) {
						
			return false;			
		}
		
		if(theGame.GetWorld().SweepTest(playerPos,waterPos - Vector(0,0,distToWater),playerRadius, tempPos,tempPos,collisionGroups)) {
		
			return false;		
		}
	
	return true;
		
	}
	//scuffed CDPR stuff
	
	function SetFloaterPos() {
	
		floaterPos = thePlayer.GetWorldPosition() + thePlayer.GetHeadingVector() * RandRange(10,20);
		floaterPos.Z = theGame.GetWorld().GetWaterLevel(floaterPos) - 0.1;				
	}
		
	function SpawnSplash(fxname : name) {
	
		var splashPos : Vector;
		var playerPos : Vector;
		
		var splashEntityTemplate : CEntityTemplate;
		var splashEntity : CEntity;
					
		splashEntityTemplate = (CEntityTemplate) LoadResource("fx\water\water_splash\man_water_splashes.w2ent",true);
		splashEntity = theGame.CreateEntity(splashEntityTemplate,floaterPos,thePlayer.GetWorldRotation());
				
		splashEntity.PlayEffect(fxname);
		splashEntity.DestroyAfter(3.0f);			
	}
	
	function SpawnFloater() {
		
		var floaterEntityTemplate 	: CEntityTemplate;
		var floaterEntity 			: CEntity;
		
		if(FactsDoesExist("FloaterDeployed")) {
		
			floaterEntity = theGame.GetEntityByTag('kng_floater');
			floaterEntity.DestroyAfter(0.1f);
			FactsRemove("FloaterDeployed");
		}
		
		floaterEntityTemplate = (CEntityTemplate) LoadResource("dlc\dlckngfishingrod\data\w2ent\kng_floater.w2ent",true);
		floaterEntity = theGame.CreateEntity(floaterEntityTemplate,floaterPos,thePlayer.GetWorldRotation());
		floaterEntity.AddTag('kng_floater');
		FactsAdd("FloaterDeployed",1,-1);
	}	
	
	function DespawnFloater() {
	
		var floaterEntity : CEntity;
		
		floaterEntity = theGame.GetEntityByTag('kng_floater');
		floaterEntity.DestroyAfter(0.1f);	
	}
	
	function HudTimeLeft(optional timeOut : float, optional abort : bool) {
	
		var timeLeftModule : CR4HudModuleTimeLeft;
		var hud : CR4ScriptedHud;
		
		hud = (CR4ScriptedHud)theGame.GetHud();
		
		if(hud) {
		
		timeLeftModule = (CR4HudModuleTimeLeft)hud.GetHudModule("TimeLeftModule");
					
			if(timeLeftModule) {
			
				if(abort) {
				
					timeLeftModule.Hide();	
					
				} else { 
				
					timeLeftModule.Show(timeOut);				
				}
			}		
		}		
	}
	
	function BlockPlayerActions() {
	
		thePlayer.BlockAction( EIAB_Jump, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Fists, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Movement, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Signs, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_DrawWeapon, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_CallHorse, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_FastTravel, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Roll, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_InteractionAction, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_ThrowBomb, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_RunAndSprint, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Dive, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Interactions, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Dodge, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_SwordAttack, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_Sprint, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_OpenMeditation, 'consoleCommand' );
		thePlayer.BlockAction( EIAB_LightAttacks, 'consoleCommand' );
		thePlayer.BlockAction( EIAB_HeavyAttacks, 'consoleCommand' );
		thePlayer.BlockAction( EIAB_Climb, 'consoleCommand' );
		thePlayer.BlockAction( EIAB_Slide, 'consoleCommand' );
		thePlayer.BlockAction( EIAB_MountVehicle, 'consoleCommand' );
		thePlayer.BlockAction( EIAB_InteractionContainers, 'consoleCommand' );	
		thePlayer.BlockAction( EIAB_RadialMenu, 'consoleCommand');
		thePlayer.BlockAction( EIAB_ExplorationFocus, 'consoleCommand');
		thePlayer.BlockAction( EIAB_QuickSlots, 'consoleCommand');		
	}
	
	function UnblockPlayerActions() {
	
		thePlayer.UnblockAction( EIAB_Jump, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Fists, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Movement, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Signs, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_DrawWeapon, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_CallHorse, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_FastTravel, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Roll, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_InteractionAction, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_ThrowBomb, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_RunAndSprint, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Dive, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Interactions, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Dodge, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_SwordAttack, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_Sprint, 'consoleCommand' );	
		thePlayer.UnblockAction( EIAB_OpenMeditation, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_LightAttacks, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_HeavyAttacks, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_Climb, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_Slide, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_MountVehicle, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_InteractionContainers, 'consoleCommand' );
		thePlayer.UnblockAction( EIAB_RadialMenu, 'consoleCommand');	
		thePlayer.UnblockAction( EIAB_ExplorationFocus, 'consoleCommand');
		thePlayer.UnblockAction( EIAB_QuickSlots, 'consoleCommand');
	}
	
	function StopFishing(){
			
		thePlayer.RemoveBuffImmunity_AllCritical( 'W3SmartObject' );
		thePlayer.RemoveBuffImmunity_AllNegative( 'W3SmartObject' );
		UnblockPlayerActions();		
		DestroyNotWantedItems();		
		entity.DestroyAfter(0.1f);		
	}
	
	function DestroyNotWantedItems() {
	
		var itemID : SItemUniqueId;
		var inv : CInventoryComponent;
		var i : int;
		
		inv = thePlayer.GetInventory();
		
		if(inv) {
		
			for (i=0; i < possibleItemSlots.Size(); i+=1) {
			
				itemID = inv.GetItemFromSlot(possibleItemSlots[i]);
				
				if(inv.IsIdValid(itemID)) {
				
						inv.UnmountItem(itemID, true);				
				}			
			}		
		}	
	}	
	
	timer function AbortTimer(deltaTime : float, id : int) {
			
		if(theInput.IsActionJustPressed('Use')) {
		
			GotoState('StopUse');		
		}	
	}
	
	timer function UseTimer(deltaTime : float, id : int) {
		
		if(theInput.IsActionJustPressed('CastSign')) {
		
			GotoState('ThrowUse');		
		}	
	}	
		
	function SetRandomLootTime() {
	
		randomLootTimer = RandRangeF(thePlayer.GetInitialTimeOut(), 0);	
	}
	
	timer function HookTimer(deltaTime : float, id : int) {
						
		catchTimer += 1;
		
		//theGame.GetGuiManager().ShowNotification("Test: " + catchTimer);
		
		if(catchTimer == 1){
		
			GotoState('StopUse');		
		}
		
		if (theInput.IsActionPressed('CastSign')) {
						
			castedRod = false;
			fishHooked = false;	
			RemoveTimer('HookSplash');
			thePlayer.inv.AddAnItem(GetRandomFish(),1);
			theGame.GetGuiManager().ShowNotification("You caught a fish!");			
			DespawnFloater();
			catchTimer = 0;
			GotoState('LoopUse');			
		}	
	}	
	
	timer function HookSplash(deltaTime : float, id : int) {
	
		SpawnSplash('man_water_splash');	
	}
}

state StartUse in CKNGFishingRod {

	event OnEnterState(prevStateName : name) {	
		
		parent.RemoveTimer('HookSplash');
		PlayStartAnimation();		
	}
	
	entry function PlayStartAnimation() {
		
		thePlayer.ActionPlaySlotAnimation('PLAYER_SLOT', parent.startAnimation);					
		parent.PushState('LoopUse');	
	}
}

state ThrowUse in CKNGFishingRod {

	event OnEnterState(prevStateName : name) {
	
		parent.castedRod = true;
		parent.RemoveTimer('UseTimer');
		parent.RemoveTimer('AbortTimer');
		parent.RemoveTimer('HookSplash');
		PlayThrowUseAnimation();	
	}
	
	entry function PlayThrowUseAnimation() {

		thePlayer.ActionPlaySlotAnimation('PLAYER_SLOT', parent.startUseAnimation);
		parent.SetFloaterPos();
		parent.SpawnSplash('splash_small');
		parent.SpawnFloater();
		parent.HudTimeLeft(60);
		parent.SetRandomLootTime();
		parent.PushState('LoopUse');	
	}
}

state LoopUse in CKNGFishingRod {

	event OnEnterState(prevStateName : name) {
				
		parent.fishHooked = false;
		parent.RemoveTimer('HookTimer');
		parent.RemoveTimer('HookSplash');
		parent.AddTimer('UseTimer',0,true);
		parent.AddTimer('AbortTimer',0,true);						
		PlayLoopAnimation();		
	}	
	
	entry function PlayLoopAnimation() {
		
		while(parent.IsInState('LoopUse') && thePlayer.GetCurrentTimeOut() >= 0) {
			
			thePlayer.ActionPlaySlotAnimation('PLAYER_SLOT', parent.loopAnimation,0.5f,0.5f);
			
			//theGame.GetGuiManager().ShowNotification(parent.randomLootTimer);			
			
			if(thePlayer.GetCurrentTimeOut() <= parent.randomLootTimer && parent.castedRod) {
							
				parent.fishHooked = true;				
				
				if(parent.fishHooked) {
				
					parent.catchTimer = 0;
				
					parent.AddTimer('HookTimer',3.0f,true);
					parent.AddTimer('HookSplash',0.5f,false,,,false);
					parent.HudTimeLeft(,true);					
				}
			}			
		}
				
		parent.PushState('StopUse');	
	}
}

state StopUse in CKNGFishingRod {

	event OnEnterState(prevStateName : name) {
		
		parent.castedRod = false;
		parent.RemoveTimer('AbortTimer');
		parent.RemoveTimer('UseTimer');
		parent.RemoveTimer('HookTimer');
		parent.RemoveTimer('HookSplash');
		parent.HudTimeLeft(,true);
		parent.DespawnFloater();
		PlayStopAnimation();		
	}	
	
	entry function PlayStopAnimation() {
		
		thePlayer.ActionPlaySlotAnimation('PLAYER_SLOT', parent.stopAnimation);
	
		parent.PushState('Null');	
	}
}

state Null in CKNGFishingRod {

	event OnEnterState(prevStateName : name) {
	
		StopAll();	
	}
	
	entry function StopAll(){
	
		parent.StopFishing();
	
	}
}