

class W3Effect_KatanaSword extends CBaseGameplayEffect{
	private var m_maxCount					: int;
	private saved var m_currCount			: int;
	private saved var m_KatanaSwordTime		: float;
	private saved var m_currChargingEffect	: name;	
	private var m_KatanaSwordDelay			: float;
	private saved var timeOfPause			: GameTime;
	private var CheckSlowMo					: bool;
	private saved var slowdownCauserIds 	: array<int>;

	default effectType 				= EET_KatanaSword;
	default isPositive 				= true;
	
	
	event OnUpdate( deltaTime : float )
	{
		var i : int;
		var Tmpdelta, CurrTime, TimeOfKatana, tmpCurrCount, tmpMaxCount :float;
		
		Tmpdelta = deltaTime;
		tmpCurrCount = GetCurrentCount();
		tmpMaxCount = GetMaxCount();
		CurrTime = Tmpdelta * tmpCurrCount / tmpMaxCount;
		
		TimeOfKatana = 2 * Tmpdelta - CurrTime;
		
		m_KatanaSwordTime -= TimeOfKatana;

		if( m_KatanaSwordTime <=0 && m_currCount > 0 )
		{
			m_currCount -= 1;
			UpdateKatanaSwordFX();
			ResetKatanaSwordTime();
		}
		
		if(!thePlayer.IsInCombat()){
			StopKatanaSwordEffects();
		}
		else{
			if(GetWitcherPlayer().IsFullKatanaStack()){
				if( !CheckSlowMo && IsFullyCharged()){
					CheckSlowMo=true;
					thePlayer.PlayEffect('mutation_7_baff');
					thePlayer.PlayEffect('mutation_7_debaff');
					if(slowdownCauserIds.Size() == 0 ){
						theGame.SetTimeScale( 0.5 , theGame.GetTimescaleSource(ETS_PotionBlizzard), theGame.GetTimescalePriority(ETS_PotionBlizzard) );
						slowdownCauserIds.PushBack(target.SetAnimationSpeedMultiplier( 1 / 0.5 ));
					}
				}
				
				if( CheckSlowMo && !IsFullyCharged()){
					CheckSlowMo=false;
					thePlayer.StopEffect('mutation_7_baff');
					thePlayer.StopEffect('mutation_7_debaff');
					for(i=0; i<slowdownCauserIds.Size(); i+=1)
					{
						target.ResetAnimationSpeedMultiplier(slowdownCauserIds[i]);
					}
					theGame.RemoveTimeScale( theGame.GetTimescaleSource(ETS_PotionBlizzard) );
					slowdownCauserIds.Clear();
					GetWitcherPlayer().ResetCriStack();
				}
			}
		}
		
		if(thePlayer.GetInventory().ItemHasTag(thePlayer.GetInventory().GetCurrentlyHeldSword(), 'Katanas')){
			SetShowOnHUD( true );
			if(!GetWitcherPlayer().IsFullKatanaStack()){
				if(thePlayer.GetStat(BCS_Vitality) > (thePlayer.GetStatMax(BCS_Vitality)  / 10 )){
					thePlayer.DrainVitality(0.85);
					thePlayer.StopVitalityRegen();
				}
			}
		}
		else SetShowOnHUD( false );
		
		super.OnUpdate( deltaTime );
	}
	
	
	public function OnTimeUpdated(dt : float)
	{
		super.OnTimeUpdated( dt );
	}
	
	event OnEffectAdded( customParams : W3BuffCustomParams )
	{		
		ResetKatanaSwordTime();
		
		super.OnEffectAdded( customParams );
	}
	
	event OnEffectAddedPost()
	{
		LoadParams();		
	
		super.OnEffectAddedPost();
	}
	
	private function LoadParams()
	{
		CheckSlowMo = false;
		m_maxCount = 10;
		m_KatanaSwordDelay = 5.f + GetWitcherPlayer().GetBounsStack();
	}
	
	public function OnLoad( t : CActor, eff : W3EffectManager )
	{
		super.OnLoad( t, eff );
		
		LoadParams();
		ResetKatanaSwordTime();
	}
	
	event OnEffectRemoved()
	{
		StopKatanaSwordEffects();
		
		super.OnEffectRemoved();
	}
	
	public function IncreaseKatanaSwordCharges( attackName : name )
	{
		ResetKatanaSwordTime();
		
		if( m_currCount < m_maxCount  )
		{
			if( target.IsLightAttack( attackName ) || thePlayer.GetCombatAction() == EBAT_SpecialAttack_Light )
			{
				m_currCount += 1;
			}
			else 
			{
				m_currCount = Min( m_maxCount, ( m_currCount + 2 ) );
			}
			
			UpdateKatanaSwordFX();
		}
		else
		{
			if(GetWitcherPlayer().IsFullKatanaStack())
			{
				if( target.IsLightAttack( attackName ) || thePlayer.GetCombatAction() == EBAT_SpecialAttack_Light )
					GetWitcherPlayer().IncreaseCriStack();
				else
				{
					GetWitcherPlayer().IncreaseCriStack();
					GetWitcherPlayer().IncreaseCriStack();
				}
			}
		}
	}
	
	private function UpdateKatanaSwordFX()
	{
		var l_KatanaSwordEnt		: CItemEntity;
		var l_effectComponent		: W3KatanaSwordFXComponent;
		var l_newChargingEffect		: name;
		
		
		target.GetInventory().GetCurrentlyHeldSwordEntity( l_KatanaSwordEnt );
		
		l_effectComponent = (W3KatanaSwordFXComponent)l_KatanaSwordEnt.GetComponentByClassName( 'W3KatanaSwordFXComponent' );
		
		l_KatanaSwordEnt.StopEffect( m_currChargingEffect );
		
		l_newChargingEffect = l_effectComponent.m_visualEffects[ m_currCount - 1 ];
		
		l_KatanaSwordEnt.PlayEffect( l_newChargingEffect );
		
		m_currChargingEffect = l_newChargingEffect;
	}
	
	protected function OnPaused()
	{
		super.OnPaused();
		
		StopKatanaSwordEffects();
		timeOfPause = theGame.GetGameTime();
	}
	
	protected function OnResumed()
	{ 
		var l_KatanaSwordEnt	: CItemEntity;
		var secsInPause : float;
		var stacksLost : int;
		var timeInPause : GameTime;
		
		super.OnResumed();
		
		timeInPause = theGame.GetGameTime() - timeOfPause;
		secsInPause = ConvertGameSecondsToRealTimeSeconds( GameTimeToSeconds( timeInPause ) );
		stacksLost = FloorF( secsInPause / m_KatanaSwordDelay );
		m_currCount = Max( 0, m_currCount - stacksLost );
		OnUpdate( secsInPause - stacksLost * m_KatanaSwordDelay );	
		  
		if( target.GetInventory().ItemHasTag( target.GetInventory().GetCurrentlyHeldSword(), 'Katanas' ) )
		{
			
			UpdateKatanaSwordFX();
			
			if( m_currChargingEffect != '' )
			{
				target.GetInventory().GetCurrentlyHeldSwordEntity( l_KatanaSwordEnt );
				l_KatanaSwordEnt.PlayEffect( m_currChargingEffect );
			}
		}
	}
	
	public function StopKatanaSwordEffects()
	{
		var l_KatanaSwordEnt			: CItemEntity;
		var i : int;
		
		target.GetInventory().GetCurrentlyHeldSwordEntity( l_KatanaSwordEnt );
		
		CheckSlowMo=false;
		thePlayer.StopEffect('mutation_7_baff');
		thePlayer.StopEffect('mutation_7_debaff');
		for(i=0; i<slowdownCauserIds.Size(); i+=1)
		{
			target.ResetAnimationSpeedMultiplier(slowdownCauserIds[i]);
		}
		theGame.RemoveTimeScale( theGame.GetTimescaleSource(ETS_PotionBlizzard) );
		slowdownCauserIds.Clear();
		GetWitcherPlayer().ResetCriStack();
		l_KatanaSwordEnt.StopEffect( m_currChargingEffect );
	}
	
	protected function StopTargetFX()
	{
		super.StopTargetFX();
		
		StopKatanaSwordEffects();
	}
	
	public function IsFullyCharged() : bool
	{
		return m_currCount == m_maxCount;
	}
	
	public function GetCurrentCount() : int
	{
		return m_currCount;
	}
	
	public function GetMaxCount() : int
	{
		return m_maxCount;
	}
	
	public function ResetKatanaSwordTime()
	{
		m_KatanaSwordTime = m_KatanaSwordDelay;
	}
	
	public function ReduceKatanaSwordStacks()
	{
			m_currCount -=1;
	}
	
	public function ResetCurrentCount()
	{
		m_currCount = 0;
	}
	
	public function IsSlowMoEffect() : bool
	{
		return CheckSlowMo;
	}
}

class W3KatanaSwordFXComponent extends CScriptedComponent
{
	editable var m_visualEffects	: array<name>;
}