class CPhotomode2inOne {

// Photomode2inOne control vars
	var PhotomodeOn : bool;		default PhotomodeOn = false; 
	var witcher : W3PlayerWitcher;
	var hud : CR4ScriptedHud;
	//Effects
	var vitFX : bool; default vitFX = false;
	var toxFX : bool; default toxFX = false;
	var catFX : bool; default catFX = false;
	var sepFX : bool; default sepFX = false;
	var drunkFX : bool; default drunkFX = false;
	var focusFX : bool; default focusFX = false;
	var selectedFX : int;
	var prevHealthPerc : float;
	var prevTox : float;
	
	//Player Invisibility
	
	var playerInvisible : bool; default playerInvisible = false;
	
	//Fogs!
	
	var mistArray : array<CEntity>;
	
	
	//Weather
	var selectedWT : int; default selectedWT = 0;
	var maxqttWT : int;
	var currentArea : EAreaName;
	var selectedWTName : name;
	
	//TimeScaler
	var scaler : float; default scaler = 1;
	
	//Dialog
	var dialog : CR4HudModuleBase;
	var dialogToogle : bool; default dialogToogle = false;
	
	//FreezeThem!
	var freezeEnts : array<CGameplayEntity>;
	var freezeToggle : bool; default freezeToggle = false;
	
	
	
	// Photomode2inOne control vars
	
	
	
	function InitHotkeys(){
	//Begin Inputs Photomode2inOne
		theInput.RegisterListener( this, 'OnCommPhotomode2inOne', 'Photomode2inOne' );
		//Effects
		theInput.RegisterListener( this, 'OnSelectFXUp', 'SelectFXUp' );
		theInput.RegisterListener( this, 'OnSelectFXDown', 'SelectFXDown' );
		theInput.RegisterListener( this, 'OnActivateFX', 'ActivateFX' );
		//Weather
		theInput.RegisterListener( this, 'OnSelectWTUp', 'SelectWTUp' );
		theInput.RegisterListener( this, 'OnSelectWTDown', 'SelectWTDown' );
		theInput.RegisterListener( this, 'OnActivateWT', 'ActivateWT' );
		//TimeScaler
		theInput.RegisterListener( this, 'OnTimeScaleUp', 'TimeScaleUp' );
		theInput.RegisterListener( this, 'OnTimeScaleDown', 'TimeScaleDown' );
		theInput.RegisterListener( this, 'OnTimeScaleReset', 'TimeScaleReset' );
		
		//Fog
		theInput.RegisterListener( this, 'OnDespawnFog', 'DespawnFog' );
		//End Inputs Photomode2inOne

	}




//Begin Events Photomode2InOne
	event OnCommPhotomode2inOne( action : SInputAction ){
			if( IsPressed( action ) ){
			
				Photomode2inOne();
			}
	}	
	
	//Effects
	event OnSelectFXUp(action : SInputAction){
		if( IsPressed( action ) ){
		
			deactivateFX();

			selectedFX = (selectedFX + 1);

			if(selectedFX == 10){
			 selectedFX = 0;
			}

			notifyFX(selectedFX);
				
		}
	}

	event OnSelectFXDown(action : SInputAction){
		if( IsPressed( action ) ){
			deactivateFX();

			selectedFX = (selectedFX - 1);
			
			if(selectedFX < 0){
			 selectedFX = 9;
			}
			notifyFX(selectedFX);
		}
	}

	event OnActivateFX(action : SInputAction){
		if( IsPressed( action ) ){
			activateFX(selectedFX);
		}
	}

	//Weather
	
	event OnSelectWTUp(action : SInputAction){
		if( IsPressed( action ) ){
			
			currentArea = theGame.GetCommonMapManager().GetCurrentArea();
			maxqttWT = GetPossibleWTNumber(currentArea);
			
			selectedWT = (selectedWT + 1);
			
			if(selectedWT > maxqttWT){
				selectedWT = 0;
			}

			selectedWTName = selectWT(currentArea, selectedWT);
				
		}
	}

	event OnSelectWTDown(action : SInputAction){
		if( IsPressed( action ) ){
			
			currentArea = theGame.GetCommonMapManager().GetCurrentArea();
			maxqttWT = GetPossibleWTNumber(currentArea);
			
			selectedWT = (selectedWT - 1);
			
			if(selectedWT < 0){
			 selectedWT = maxqttWT;
			}
			selectedWTName = selectWT(currentArea, selectedWT);
		}
	}

	event OnActivateWT(action : SInputAction){
		if( IsPressed( action ) ){
			
			activateWT(selectedWTName);
		}
	}

	//TimeScaler
		
	event OnTimeScaleUp(action : SInputAction){
		if( IsPressed( action ) ){
			
			
			if(scaler >= 0.0 && scaler < 0.5){
				
				if(scaler == 0.001){
					scaler = 0.1;
				}
				else{
					scaler = scaler + 0.1;
				}
			}
			else if(scaler == 0.5){
			 scaler = scaler + 0.5;
			}
			else if(scaler >= 1 && scaler < 10){
				scaler = scaler + 1;
			}
			else if(scaler >= 10){
				scaler = scaler + 10;
			}
			
			timeScaler(scaler);
			
		}
	}

	event OnTimeScaleDown(action : SInputAction){
		if( IsPressed( action ) ){
			
			if(scaler >= 0.1 && scaler <= 0.5){
				scaler = scaler - 0.1;
				
				if(scaler < 0.1){
						scaler = 0.001;
				}
			}
			else if (scaler == 1){
				scaler = scaler - 0.5;
			}
			else if(scaler > 1 && scaler <= 10){
				scaler = scaler - 1;
			}
			else if(scaler > 10){
				scaler = scaler - 10;
			}
	
			timeScaler(scaler);
			
		}
	}
	
	event OnTimeScaleReset(action : SInputAction){
		if( IsPressed( action ) ){
			
			if(scaler == 1){
				scaler = 0.5;
			
			}
			else{
				scaler = 1;
			}
					
			timeScaler(scaler);
		}
	}

	
//End Events Photomode2inOne



//Begin Functions Photomode2inOne

	function Photomode2inOne(){
		
		hud = (CR4ScriptedHud)theGame.GetHud();
		
		if(PhotomodeOn == false){
				
			theGame.Pause( "Photomode2inOne" );//pause
			hud.OnDialogHudShow();//dlgshow
			DialogToogle(dialogToogle);
								
			PhotomodeOn = true;
			
		}
		else{
			
			/*
			if(theGame.IsFreeCameraEnabled())
			theGame.EnableFreeCamera(false);
			*/
			
			hud.OnDialogHudHide();//dlghide
			theGame.Unpause( "Photomode2inOne" ); //unpause
			DialogToogle(dialogToogle);
			
			PhotomodeOn = false;
		}	
	}
	
//Effects
	function notifyFX(FX : int){

		switch(FX){

		case 0:
		theGame.GetGuiManager().ShowNotification("Effect: Focus");
		break;

		case 1 :
		theGame.GetGuiManager().ShowNotification("Effect: Low Heath");
		break;

		case 2 :
		theGame.GetGuiManager().ShowNotification("Effect: Toxicity");
		break;

		case 3 :
		theGame.GetGuiManager().ShowNotification("Effect: Cat");
		break;

		case 4 :
		theGame.GetGuiManager().ShowNotification("Effect: Sepia");
		break;

		case 5 :
		theGame.GetGuiManager().ShowNotification("Effect: Drunk");
		break;
		
		case 6 : 
		theGame.GetGuiManager().ShowNotification("Effect: Player Invisible");
		break;
		
		case 7 : 
		theGame.GetGuiManager().ShowNotification("Effect: Add Mist");
		break;
		
		case 8 : 
		theGame.GetGuiManager().ShowNotification("Effect: Add Fog");
		break;
		
		case 9 : 
		theGame.GetGuiManager().ShowNotification("Effect: Freeze Them!");
		break;
		
		}
		

	}

	function activateFX(FX : int){

		switch(FX){

		case 0 :
		focusToogle(focusFX);
		break;

		case 1 :
		vitalityToogle(vitFX);
		break;

		case 2 :
		toxicityToogle(toxFX);
		break;

		case 3 :
		catToogle(catFX);
		break;

		case 4 :
		sepiaToogle(sepFX);
		break;

		case 5 :
		drunkToogle(drunkFX);
		break;
		
		case 6:
		playerInvisibleToogle(playerInvisible);
		break;
		
		case 7:
		spawnfogmist(0,,5);
		break;
		
		case 8:
		spawnfogmist(1,,5);
		break;
		
		case 9:
		freezeThem(freezeToggle);
		break;
		}

	}

	function deactivateFX(){

		//if(focusFX){focusToogle(focusFX);}
		
		if(vitFX){vitalityToogle(vitFX);}

		if(toxFX){toxicityToogle(toxFX);}

		//if(catFX){catToogle(catFX);}

		//if(sepFX){sepiaToogle(sepFX);}

		//if(drunkFX){drunkToogle(drunkFX);}

	}


function vitalityToogle(enabled : bool){

witcher = GetWitcherPlayer();

	if(!enabled){

						
			prevHealthPerc = witcher.GetHealthPercents();		
			
			witcher.SetHealthPerc(10);
			witcher.AddEffectDefault(EET_LowHealth, witcher,'vitality_change');
			witcher.SetHealthPerc(100);
			
			vitFX = true;
	}
	else{
		witcher.SetHealthPerc(prevHealthPerc);
		witcher.RemoveBuff(EET_LowHealth);
		
		vitFX = false;
	}	

}


function toxicityToogle(enabled : bool){

witcher = GetWitcherPlayer();

	if(!enabled){
	
	prevHealthPerc = witcher.GetHealthPercents();
	prevTox = witcher.GetStat(BCS_Toxicity);
			
			witcher.ForceSetStat( BCS_Toxicity, 90 );
			witcher.AddEffectDefault(EET_Toxicity,witcher,'toxicity_change');
			witcher.SetHealthPerc(100);			
									
			toxFX = true;
	}
	else{
			witcher.RemoveBuff(EET_Toxicity);
			witcher.SetHealthPerc(prevHealthPerc);
			witcher.ForceSetStat( BCS_Toxicity, prevTox );
			
			toxFX = false;
	}
}


function catToogle(enabled : bool){
		if(!enabled){
			
			EnableCatViewFx( 0.0f );	
			SetTintColorsCatViewFx(Vector(0.1f,0.12f,0.13f,0.6f),Vector(0.075f,0.1f,0.11f,0.6f),0.2f);
			SetBrightnessCatViewFx(350.0f);
			SetViewRangeCatViewFx(200.0f);
			SetPositionCatViewFx( Vector(0,0,0,0) , true );	
			SetHightlightCatViewFx( Vector(0.3f,0.1f,0.1f,0.1f),0.05f,1.5f);
			SetFogDensityCatViewFx( 0.5 );
			
			catFX = true;
		}
		else{
			
			DisableCatViewFx( 0.0f );
			catFX = false;
		}
}


function sepiaToogle(enabled : bool){

	if(!enabled){
	theGame.StartSepiaEffect(0.0f);	
	sepFX = true;
	}
	else{
	theGame.StopSepiaEffect(0.0f);
				
	sepFX = false;

	}

}

function focusToogle(enabled : bool){

	if(!enabled){
	theGame.GetFocusModeController().Activate();	
	focusFX = true;
	}
	else{
	theGame.GetFocusModeController().Deactivate();
	focusFX = false;

	}
}


function drunkToogle( enabled : bool ){
	if(!enabled)
	{
		EnableDrunkFx( 0.0f );
		drunkFX = true;
	}
	else
	{
		DisableDrunkFx( 0.0f );
		drunkFX = false;
	}
}

//Player Invisibility

function playerInvisibleToogle( enabled : bool ){
	if(!enabled)
	{
		thePlayer.SetVisibility( false );
		playerInvisible = true;
	}
	else
	{
		thePlayer.SetVisibility( true );
		playerInvisible = false;
	}
}

/////////////////

function freezeThem(enabled : bool) {
		
		var i : int;
		var size : int;
		var anim : CComponent;	
				
		witcher = GetWitcherPlayer();
		
		if(!enabled){
		
		FindGameplayEntitiesInRange(freezeEnts, (CNode)witcher , 100, 20, '', FLAG_Attitude_Hostile+FLAG_ExcludePlayer);
			
			size = freezeEnts.Size();
			for(i = 0;i < size;i += 1){
				anim = ((CActor)freezeEnts[i]).GetComponentByClassName('CAnimatedComponent');
				((CAnimatedComponent)anim).FreezePoseFadeIn(0.5f);
			}
			freezeToggle = true;
		}
		else{
				size = freezeEnts.Size();
				for(i = 0;i < size;i += 1){
					anim = ((CActor)freezeEnts[i]).GetComponentByClassName('CAnimatedComponent');
					((CAnimatedComponent)anim).UnfreezePoseFadeOut(0.5f);
				
				}
			
			freezeEnts.Clear();
			freezeToggle = false;
		}
	}
	

event OnDespawnFog(action : SInputAction){
		if( IsPressed( action ) ){
			despawnfogmist();
		}
	}



function spawnfogmist(optional type : int, optional quantity : int, optional distance : float) {
	var pos, cameraDir, player, posFin, normal, posTemp : Vector;
	var rot : EulerAngles;
	var i, sign : int;
	var s,r,x,y : float;
	var template : CEntityTemplate;
	var mistEnt : CEntity;

	quantity = Max(quantity, 1);

	rot = thePlayer.GetWorldRotation(); 
	rot.Yaw += 180; 

	cameraDir = theCamera.GetCameraDirection();

	if( distance == 0 ) distance = 3; 
	cameraDir.X *= distance; 
	cameraDir.Y *= distance;


	player = thePlayer.GetWorldPosition();

	pos = cameraDir + player; 
	pos.Z = player.Z;


	posFin.Z = pos.Z; 
	s = quantity / 0.2; 
	r = SqrtF(s/Pi());

	if(type == 0){
		template = (CEntityTemplate)LoadResource("fx\quest\sq108\sq108_fog.w2ent", true);
		theGame.GetGuiManager().ShowNotification("Mist Added");
	}
	else{
		template = (CEntityTemplate)LoadResource("fx\monsters\fogling\fogling_fog.w2ent", true);
		theGame.GetGuiManager().ShowNotification("Fog Added");
	}

	for(i=0; i<quantity; i+=1)
	{ 
	x = RandF() * r; 
	y = RandF() * (r - x); 

	if(RandRange(2)) 
	sign = 1;
	else
	sign = -1;

	posFin.X = pos.X + sign * x; 

	if(RandRange(2)) 
	sign = 1;
	else
	sign = -1;

	posFin.Y = pos.Y + sign * y; 

	if(theGame.GetWorld().StaticTrace( posFin + Vector(0,0,5), posFin - Vector(0,0,5), posTemp, normal ))
	{
	posFin = posTemp;
	}
	
	mistEnt = theGame.CreateEntity(template, posFin, rot);
	mistArray.PushBack(mistEnt);
	
	}
}

function despawnfogmist(){
	
	var sizemist,i : int;
	var ent : CEntity;
	
	sizemist = mistArray.Size();
	//theGame.GetGuiManager().ShowNotification((string)sizemist);
	
	if(sizemist > 0){
		for(i = 0; i < sizemist; i+=1){
		
			mistArray[i].Destroy();
		}
		mistArray.Clear();
	}
}	
	
//Weather

function activateWT(weather : name){

	RequestWeatherChangeTo( weather , 1 );
}
	

function GetPossibleWTNumber(area : EAreaName) : int{

	switch(area){
		case AN_NMLandNovigrad:
			return 7;
		case AN_Skellige_ArdSkellig:
			return 14;
		case AN_Kaer_Morhen:
			return 9;
		case AN_Prologue_Village:
			return 5;
		case AN_Wyzima:
			return 0;
		case AN_Island_of_Myst:
			return 0;
		case AN_Spiral:
			return 7;
		case AN_Velen:
			return 7;
		case AN_Undefined:
			return 7;
	}
}

	
function selectWT(Area : EAreaName, WT : int) : name{

	switch(Area){

		case AN_NMLandNovigrad:
			switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("Novigrad: Clear");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("Novigrad: Rain Storm");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("Novigrad: Snow");
					return 'WT_Snow';
				case 3:
					theGame.GetGuiManager().ShowNotification("Novigrad: Light Clouds");
					return 'WT_Light_Clouds';
				case 4:
					theGame.GetGuiManager().ShowNotification("Novigrad: Mid Clouds");
					return 'WT_Mid_Clouds';
				case 5:
					theGame.GetGuiManager().ShowNotification("Novigrad: Mid Clouds Dark");
					return 'WT_Mid_Clouds_Dark';
				case 6:
					theGame.GetGuiManager().ShowNotification("Novigrad: Heavy Clouds");
					return 'WT_Heavy_Clouds';
				case 7:
					theGame.GetGuiManager().ShowNotification("Novigrad: Heavy Clouds Dark");
					return 'WT_Heavy_Clouds_Dark';			
			}
		case AN_Skellige_ArdSkellig:
			switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("Skellige: Clear");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("Skellige: Rain Storm");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("Skellige: Mid Clouds");
					return 'WT_Mid_Clouds';
				case 3:
					theGame.GetGuiManager().ShowNotification("Skellige: Mid Clouds Fog");
					return 'WT_Mid_Clouds_Fog';
				case 4:
					theGame.GetGuiManager().ShowNotification("Skellige: Mid Clouds Dark");
					return 'WT_Mid_Clouds_Dark';
				case 5:
					theGame.GetGuiManager().ShowNotification("Skellige: Heavy Clouds");
					return 'WT_Heavy_Clouds';
				case 6:
					theGame.GetGuiManager().ShowNotification("Skellige: Heavy Clouds Dark");
					return 'WT_Heavy_Clouds_Dark';
				case 7:
					theGame.GetGuiManager().ShowNotification("Skellige: Blizzard");
					return 'WT_Blizzard';
				case 8:
					theGame.GetGuiManager().ShowNotification("Skellige: Wild Hunt");
					return 'WT_Wild_Hunt';
				case 9:
					theGame.GetGuiManager().ShowNotification("Skellige: Q501 Blizzard");
					return 'WT_q501_Blizzard';
				case 10:
					theGame.GetGuiManager().ShowNotification("Skellige: Q501 Storm");
					return 'WT_q501_Storm';
				case 11:
					theGame.GetGuiManager().ShowNotification("Skellige: Q501 Blizzard 2");
					return 'WT_q501_Blizzard2';
				case 12:
					theGame.GetGuiManager().ShowNotification("Skellige: Lessun Forest");
					return 'WT_lessun_forest';
				case 13:
					theGame.GetGuiManager().ShowNotification("Skellige: Q501 Fight Ship");
					return 'WT_q501_fight_ship_18_00';
				case 14:
					theGame.GetGuiManager().ShowNotification("Skellige: Q501 Storm Arena");
					return 'WT_q501_storm_arena';
		}
		case AN_Kaer_Morhen:
			switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Clear");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Rain Storm");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Blizzard");
					return 'WT_Blizzard';
				case 3:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Light Clouds");
					return 'WT_Light_Clouds';
				case 4:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Mid Clouds");
					return 'WT_Mid_Clouds';
				case 5:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Heavy Clouds");
					return 'WT_Heavy_Clouds';
				case 6:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Heavy Clouds Dark");
					return 'WT_Heavy_Clouds_Dark';
				case 7:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Vesemir Hour");
					return 'WT_Vesemir_burial_hour_3_30';
				case 8:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Battle");
					return 'WT_Battle';
				case 9:
					theGame.GetGuiManager().ShowNotification("Kaer Morhen: Battle Forest");
					return 'WT_Battle_Forest';
			}
		case AN_Prologue_Village:
			switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("White Orchard: Clear");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("White Orchard: Rain Storm");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("White Orchard: Light Rain");
					return 'WT_Light_Rain';
				case 3:
					theGame.GetGuiManager().ShowNotification("White Orchard: Light Clouds");
					return 'WT_Light_Clouds';
				case 4:
					theGame.GetGuiManager().ShowNotification("White Orchard: Mid Clouds");
					return 'WT_Mid_Clouds';
				case 5:
					theGame.GetGuiManager().ShowNotification("White Orchard: Heavy Clouds");
					return 'WT_Heavy_Clouds';
			}
		case AN_Wyzima:
					theGame.GetGuiManager().ShowNotification("Wyzima: Mid Clouds");
					return 'WT_Mid_Clouds';
		case AN_Island_of_Myst:
					theGame.GetGuiManager().ShowNotification("White Orchard: Heavy Clouds");
					return 'WT_Heavy_Clouds';
		case AN_Spiral:
			switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("Spiral: Eternal Cold");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("Spiral: Aen Elle");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("Spiral: Desert");
					return 'WT_Light_Rain';
				case 3:
					theGame.GetGuiManager().ShowNotification("Spiral: Dark_Valley");
					return 'WT_Light_Clouds';
				case 4:
					theGame.GetGuiManager().ShowNotification("Spiral: Clear");
					return 'WT_Mid_Clouds';
			}
		case AN_Velen:
			switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("Velen: Clear");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("Velen: Rain Storm");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("Velen: Snow");
					return 'WT_Snow';
				case 3:
					theGame.GetGuiManager().ShowNotification("Velen: Light Clouds");
					return 'WT_Light_Clouds';
				case 4:
					theGame.GetGuiManager().ShowNotification("Velen: Mid Clouds");
					return 'WT_Mid_Clouds';
				case 5:
					theGame.GetGuiManager().ShowNotification("Velen: Mid Clouds Dark");
					return 'WT_Mid_Clouds_Dark';
				case 6:
					theGame.GetGuiManager().ShowNotification("Velen: Heavy Clouds");
					return 'WT_Heavy_Clouds';
				case 7:
					theGame.GetGuiManager().ShowNotification("Velen: Heavy Clouds Dark");
					return 'WT_Heavy_Clouds_Dark';			
			}
		default:
				switch(WT){
				case 0:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Clear");
					return 'WT_Clear';
				case 1:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Rain Storm");
					return 'WT_Rain_Storm';
				case 2:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Light Snow");
					return 'WT_Light_Snow';
				case 7:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Blizzard");
					return 'WT_Blizzard';
				case 3:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Light Clouds");
					return 'WT_Light_Clouds';
				case 4:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Mid Clouds");
					return 'WT_Mid_Clouds';
				case 6:
					theGame.GetGuiManager().ShowNotification("Defaulted Area: Heavy Clouds");
					return 'WT_Heavy_Clouds';
							
			}
	}
}

//TimeScaler

function timeScaler(scale : float){

		theGame.SetTimeScale(scale, theGame.GetTimescaleSource(ETS_CFM_On), theGame.GetTimescalePriority(ETS_CFM_On), true );
		notifyScaler(scale);
}

function notifyScaler(scale : float){
	var scaleValue : string;
	
	scaleValue = FloatToStringPrec( scale, 1);
	theGame.GetGuiManager().ShowNotification("Time Multiplier: x"+scaleValue);
}
	

//Dialog
function DialogToogle( enabled : bool ){
	
	dialog = (CR4HudModuleBase)hud.GetHudModule("DialogModule");
	
	if(!enabled){
		dialog.SetEnabled(false);
		dialogToogle = true;
	
	}
	else{
		dialog.SetEnabled(true);
		dialogToogle = false;
	}
	hud.UpdateHUD();
}


	
//End Functions Photomode2inOne
}

/* 

# Not working yet

exec function fog(optional type : int, optional distance : float){

	var photomode : CPhotomode2inOne;
	photomode = new CPhotomode2inOne in theGame;

	theGame.GetGuiManager().ShowNotification((string)type);
	
	if (distance < 1){
		distance = 5.0f;
	}
	
	photomode.spawnfogmist(type,,distance);
}

exec function nofog(){

var photomode : CPhotomode2inOne;
photomode = new CPhotomode2inOne in theGame;

photomode.despawnfogmist();

}
*/