// This is an Unreal Script
class X2Item_Katana_Weapon extends X2Item  config(Game); 

var config WeaponDamageValue KATANA_CONVENTIONAL_BASEDAMAGE;

var config int KATANA_CONVENTIONAL_AIM;
var config int KATANA_CONVENTIONAL_CRITCHANCE;
var config int KATANA_CONVENTIONAL_ICLIPSIZE;
var config int KATANA_CONVENTIONAL_ISOUNDRANGE;
var config int KATANA_CONVENTIONAL_IENVIRONMENTDAMAGE;

var config WeaponDamageValue KATANA_BEAM_BASEDAMAGE;

var config int KATANA_BEAM_AIM;
var config int KATANA_BEAM_CRITCHANCE;
var config int KATANA_BEAM_ICLIPSIZE;
var config int KATANA_BEAM_ISOUNDRANGE;
var config int KATANA_BEAM_IENVIRONMENTDAMAGE;

var config WeaponDamageValue KATANA_PLASMA_BASEDAMAGE;

var config int KATANA_PLASMA_AIM;
var config int KATANA_PLASMA_CRITCHANCE;
var config int KATANA_PLASMA_ICLIPSIZE;
var config int KATANA_PLASMA_ISOUNDRANGE;
var config int KATANA_PLASMA_IENVIRONMENTDAMAGE;



var config WeaponDamageValue WAKIZASHI_CONVENTIONAL_BASEDAMAGE;
var config int WAKIZASHI_CONVENTIONAL_AIM;
var config int WAKIZASHI_CONVENTIONAL_CRITCHANCE;
var config int WAKIZASHI_CONVENTIONAL_ICLIPSIZE;
var config int WAKIZASHI_CONVENTIONAL_ISOUNDRANGE;
var config int WAKIZASHI_CONVENTIONAL_IENVIRONMENTDAMAGE;




//Template classes are searched for by the game when it starts. Any derived classes have their CreateTemplates function called
//on the class default object. The game expects CreateTemplates to return a list of templates that it will add to the manager
//reponsible for those types of templates. Later, these templates will be automatically picked up by the game mechanics and systems.
static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> ModWeapons;

	ModWeapons.AddItem(CreateTemplate_Katana());
	ModWeapons.AddItem(CreateTemplate_Wakizashi());
	ModWeapons.AddItem(CreateTemplate_Katana_Plasma());
	ModWeapons.AddItem(CreateTemplate_Katana_Stun());
	return ModWeapons;
}




//Template creation functions form the bulk of a template class. This one builds our custom weapon.
static function X2DataTemplate CreateTemplate_Katana()
{
	local X2WeaponTemplate Template;

	`CREATE_X2TEMPLATE(class'X2WeaponTemplate', Template, 'Katana_CV');
	Template.WeaponPanelImage = "_Sword";                       // used by the UI. Probably determines iconview of the weapon.

	Template.ItemCat = 'weapon';
	Template.WeaponCat = 'sword';
	Template.WeaponTech = 'conventional';
	Template.strImage = "img:///KatanaPkg.KatanaIcon";
	Template.EquipSound = "Sword_Equip_Conventional";
	Template.InventorySlot = eInvSlot_SecondaryWeapon;
	Template.StowedLocation = eSlot_RightBack;
	// This all the resources; sounds, animations, models, physics, the works.
	//Template.GameArchetype = "WP_Sword_CV.WP_Sword_CV";
	Template.GameArchetype ="KatanaPkg.WP_Sword_CV";
	//Template.AddDefaultAttachment('Sheath', "ConvSword.Meshes.SM_ConvSword_Sheath", true);
	Template.Tier = 0;

	Template.iRadius = 1;
	Template.NumUpgradeSlots = 1;
	Template.InfiniteAmmo = true;
	Template.iPhysicsImpulse = 5;
	//Template.bAlwaysUnique = true;
	Template.iRange = 0;
	Template.BaseDamage = default.KATANA_CONVENTIONAL_BASEDAMAGE;
	Template.Aim = default.KATANA_CONVENTIONAL_AIM;
	Template.CritChance = default.KATANA_CONVENTIONAL_CRITCHANCE;
	Template.iSoundRange = default.KATANA_CONVENTIONAL_ISOUNDRANGE;
	Template.iEnvironmentDamage = default.KATANA_CONVENTIONAL_IENVIRONMENTDAMAGE;
	Template.BaseDamage.DamageType = 'Melee';

	Template.UpgradeItem = 'Sword_MG';
	
	Template.StartingItem = true;
	Template.CanBeBuilt = false;

	Template.DamageTypeTemplateName = 'Melee';

	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, class'X2Ability_ModAbilities'.default.KATANA_SPEED_BONUS);

	Template.Abilities.AddItem('KatanaSpeedBonus');

	//Template.BaseDamage.Pierce += 1;
	//Template.BaseDamage.Damage -= 1;
	//Template.CritChance += 10;
	//Template.Aim += 10;

	return Template;
}


//Template creation functions form the bulk of a template class. This one builds our custom weapon.
static function X2DataTemplate CreateTemplate_Katana_Plasma()
{
	local X2WeaponTemplate Template;

	`CREATE_X2TEMPLATE(class'X2WeaponTemplate', Template, 'Katana_BM');
	Template.WeaponPanelImage = "_Sword";                       // used by the UI. Probably determines iconview of the weapon.

	Template.ItemCat = 'weapon';
	Template.WeaponCat = 'sword';
	Template.WeaponTech = 'conventional';
	Template.strImage = "img:///KatanaPkg.KatanaIcon";
	Template.EquipSound = "Sword_Equip_Conventional";
	Template.InventorySlot = eInvSlot_SecondaryWeapon;
	Template.StowedLocation = eSlot_RightBack;
	// This all the resources; sounds, animations, models, physics, the works.
	//Template.GameArchetype = "WP_Sword_CV.WP_Sword_CV";
	Template.GameArchetype ="KatanaPkg.WP_Katana_BM";
	//Template.AddDefaultAttachment('Sheath', "ConvSword.Meshes.SM_ConvSword_Sheath", true);
	Template.Tier = 0;

	Template.iRadius = 1;
	Template.NumUpgradeSlots = 1;
	Template.InfiniteAmmo = true;
	Template.iPhysicsImpulse = 5;
	//Template.bAlwaysUnique = true;
	Template.iRange = 0;
	Template.BaseDamage = default.KATANA_PLASMA_BASEDAMAGE;
	Template.Aim = default.KATANA_PLASMA_AIM;
	Template.CritChance = default.KATANA_PLASMA_CRITCHANCE;
	Template.iSoundRange = default.KATANA_PLASMA_ISOUNDRANGE;
	Template.iEnvironmentDamage = default.KATANA_PLASMA_IENVIRONMENTDAMAGE;
	Template.BaseDamage.DamageType = 'Melee';

	Template.UpgradeItem = 'Sword_MG';
	
	Template.StartingItem = true;
	Template.CanBeBuilt = false;

	Template.DamageTypeTemplateName = 'Melee';

	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, class'X2Ability_ModAbilities'.default.KATANA_SPEED_BONUS);

	Template.Abilities.AddItem('KatanaSpeedBonus');

	//Template.BaseDamage.Pierce += 1;
	//Template.BaseDamage.Damage -= 1;
	//Template.CritChance += 10;
	//Template.Aim += 10;

	return Template;
}

static function X2DataTemplate CreateTemplate_Katana_Stun()
{
	local X2WeaponTemplate Template;

	`CREATE_X2TEMPLATE(class'X2WeaponTemplate', Template, 'Katana_MG');
	Template.WeaponPanelImage = "_Sword";                       // used by the UI. Probably determines iconview of the weapon.

	Template.ItemCat = 'weapon';
	Template.WeaponCat = 'sword';
	Template.WeaponTech = 'conventional';
	Template.strImage = "img:///KatanaPkg.KatanaIcon";
	Template.EquipSound = "Sword_Equip_Conventional";
	Template.InventorySlot = eInvSlot_SecondaryWeapon;
	Template.StowedLocation = eSlot_RightBack;
	// This all the resources; sounds, animations, models, physics, the works.
	//Template.GameArchetype = "WP_Sword_CV.WP_Sword_CV";
	Template.GameArchetype ="KatanaPkg.WP_Katana_MG";
	//Template.AddDefaultAttachment('Sheath', "ConvSword.Meshes.SM_ConvSword_Sheath", true);
	Template.Tier = 0;

	Template.iRadius = 1;
	Template.NumUpgradeSlots = 1;
	Template.InfiniteAmmo = true;
	Template.iPhysicsImpulse = 5;
	//Template.bAlwaysUnique = true; 
	Template.iRange = 0;
	Template.BaseDamage = default.KATANA_BEAM_BASEDAMAGE;
	Template.Aim = default.KATANA_BEAM_AIM;
	Template.CritChance = default.KATANA_BEAM_CRITCHANCE;
	Template.iSoundRange = default.KATANA_BEAM_ISOUNDRANGE;
	Template.iEnvironmentDamage = default.KATANA_BEAM_IENVIRONMENTDAMAGE;
	Template.BaseDamage.DamageType = 'Melee';

	Template.UpgradeItem = 'Sword_MG';
	
	Template.StartingItem = true;
	Template.CanBeBuilt = false;

	Template.DamageTypeTemplateName = 'Melee';

	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, class'X2Ability_ModAbilities'.default.KATANA_SPEED_BONUS);

	Template.Abilities.AddItem('KatanaSpeedBonus');

	//Template.BaseDamage.Pierce += 1;
	//Template.BaseDamage.Damage -= 1;
	//Template.CritChance += 10;
	//Template.Aim += 10;

	return Template;
}


static function X2DataTemplate CreateTemplate_Wakizashi()
{
	local X2WeaponTemplate Template;

	`CREATE_X2TEMPLATE(class'X2WeaponTemplate', Template, 'Wakizashi_CV');
	Template.WeaponPanelImage = "_Sword";                       // used by the UI. Probably determines iconview of the weapon.

	Template.ItemCat = 'weapon';
	Template.WeaponCat = 'sword';
	Template.WeaponTech = 'conventional';
	Template.strImage = "img:///KatanaPkg.KatanaIcon";
	Template.EquipSound = "Sword_Equip_Conventional";
	Template.InventorySlot = eInvSlot_SecondaryWeapon;
	Template.StowedLocation = eSlot_RightBack;
	// This all the resources; sounds, animations, models, physics, the works.
	//Template.GameArchetype = "WP_Sword_CV.WP_Sword_CV";
	Template.GameArchetype ="KatanaPkg.WP_Wakizashi_CV";
	//Template.AddDefaultAttachment('Sheath', "ConvSword.Meshes.SM_ConvSword_Sheath", true);
	Template.Tier = 0;

	Template.iRadius = 1;
	Template.NumUpgradeSlots = 1;
	Template.InfiniteAmmo = true;
	Template.iPhysicsImpulse = 5;
	//Template.bAlwaysUnique = true;
	Template.iRange = 0;
	Template.BaseDamage = default.WAKIZASHI_CONVENTIONAL_BASEDAMAGE;
	Template.Aim = default.WAKIZASHI_CONVENTIONAL_AIM;
	Template.CritChance = default.WAKIZASHI_CONVENTIONAL_CRITCHANCE;
	Template.iSoundRange = default.WAKIZASHI_CONVENTIONAL_ISOUNDRANGE;
	Template.iEnvironmentDamage = default.WAKIZASHI_CONVENTIONAL_IENVIRONMENTDAMAGE;
	Template.BaseDamage.DamageType = 'Melee';

	Template.UpgradeItem = 'Sword_MG';
	
	Template.StartingItem = true;
	Template.CanBeBuilt = false;

	Template.DamageTypeTemplateName = 'Melee';

	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, class'X2Ability_ModAbilities'.default.WAKIZASHI_SPEED_BONUS);

	Template.Abilities.AddItem('WakizashiSpeedBonus');

	//Template.BaseDamage.Pierce += 1;
	//Template.BaseDamage.Damage -= 1;
	//Template.CritChance += 10;
	//Template.Aim += 10;

	return Template;
}