// Copyright © 2017 CD Projekt RED | HQX
// V.1.0.4
class HQXFollower {
	public var isFollowerTag 			: name;
	public var isInPlayerParty			: name;	
			
	//DESC
	public var followerTag 						: name;
	default followerTag 						= 'HQXcirilla';
	public var followerHorseTag					: name;
	public var followerName 					: string;
	default followerName 						= "cirilla";	
	
	private var followerNPC 					: CHQXFollowerNPC;
	private var followerHorseNPC 				: CNewNPC;	
	private var followerTemplate 				: string;	
	private var followerSceneNormal				: string;
	private var followerSceneAlternativ			: string;
	private var followerSceneHood				: string;
		
	//INIT
	public function Init(){				
		isFollowerTag 		= 'HQXisFollower';	
		isInPlayerParty		= 'InPlayerParty';	
		
		followerTemplate 		= "dlc\hqxfollowersystem\hqxfollower." + followerName +".w2ent";
		followerSceneNormal 	= "dlc\hqxfollowersystem\hqxfollower." + followerName + "Normal.w2scene";
		followerSceneAlternativ = "dlc\hqxfollowersystem\hqxfollower." + followerName + "Alternativ.w2scene";
		followerSceneHood 		= "dlc\hqxfollowersystem\hqxfollower." + followerName + "Hood.w2scene";
		
		RespawnNpc();
	}
	
	//SET
	public function Set(property : string, action:bool){
		if(property == "follow"){
			followerNPC.Follow(action);
		}
		else if(property == "show")		{		
			followerNPC.Show(action);
		}
		else if(property=="carry"){
			theGame.GameplayFactsAdd("stashMode", 1);
			theGame.RequestMenuWithBackground( 'InventoryMenu', 'CommonMenu' );
		}
		else if(property=="call"){
			followerNPC.Call(true);
		}
		
		//LOCATIONS
		else if(property=="wait"){
			followerNPC.Wait(AN_Undefined);
		}
		else if(property=="wait_morhen")
		{
			followerNPC.Wait(AN_Kaer_Morhen);
		}		
		else if(property=="wait_novigrad")
		{
			followerNPC.Wait(AN_NMLandNovigrad);
		}
		else if(property=="wait_trolde")
		{
			followerNPC.Wait(AN_Skellige_ArdSkellig);
		}
		else if(property=="home"){
			followerNPC.Home(action);
		}
		else if(property=="teleport")
		{
			followerNPC.TeleportPlayer(action);
		}
		
		//CHARACTER
		else if(property=="stay")
		{
			followerNPC.StayClose(action);
			followerNPC.Follow(true);
		}		
		else if(property=="move")
		{
			followerNPC.MoveFast(action);	
			followerNPC.Follow(true);
		}
		else if(property=="rest")
		{
			followerNPC.Rest(action);	
		}
		else if(property=="heal")
		{
			followerNPC.HealPlayer(action);
		}
		else if(property=="immortal")
		{
			followerNPC.Immortal(action);	
		}
		else if(property=="change")
		{
			followerNPC.ToggleChange(action);	
		}
		else if(property=="fight")
		{
			followerNPC.Fight(action);	
		}
		else if(property=="torch")
		{
			followerNPC.ToggleTorch(action);	
		}
		else if(property=="stop")
		{
			followerNPC.Stop(action);
		}		
		
		else if(property == "interactScene")
		{
			followerNPC.Interact(action);
			if(followerNPC.Property(HQX_HasAppearance).Is(HQX_Cold))
			{
				InteractScene(followerSceneHood);
			}		
			else if(followerNPC.Property(HQX_HasAppearance).Is(HQX_Alternativ))
			{
				InteractScene(followerSceneAlternativ);
			}
			else 
			{
				InteractScene(followerSceneNormal);	
			}		
		}
		else if (property == "leave")
		{
			followerNPC.LeaveInteraction(action);
		}
		else if(property == "interactHorse"){
			if(action){
				RespawnNpc();
			}
			followerNPC.Horse(action);
		}else if(property == "respawn"){
			if(action){
				RespawnNpc();
			}
		}
		followerNPC.ForceAIUpdate();		
	}
	
	public function InteractScene(sceneName:string){
		var scene : CStoryScene;	
		
		scene = (CStoryScene)LoadResource( sceneName, true);		
		theGame.GetStorySceneSystem().PlayScene(scene, "Input");
	}
	
	public function SpawnNPC(followerPosition : Vector, followerRotation : EulerAngles){	
		var npcTemplate 	: CEntityTemplate;	
		var horseTemplate 	: CEntityTemplate;
		
		followerNPC = (CHQXFollowerNPC)theGame.GetNPCByTag(followerTag);		
		if(!followerNPC){		
			npcTemplate = (CEntityTemplate)LoadResource(followerTemplate, true);
			followerNPC = (CHQXFollowerNPC)theGame.CreateEntity(npcTemplate, followerPosition, followerRotation, true, false, false, PM_Persist);
			
			followerNPC.AddTag( followerTag );		
			followerNPC.AddTag( isFollowerTag );
			followerNPC.AddTag( isInPlayerParty );					
		}
		
		followerHorseNPC = theGame.GetNPCByTag(followerHorseTag);
		if(!followerHorseNPC)
		{	
			horseTemplate = (CEntityTemplate)LoadResource("characters\npc_entities\animals\horse\horse_vehicle.w2ent", true);
			followerHorseNPC = (CNewNPC)theGame.CreateEntity(horseTemplate, Vector(0,0,0), followerRotation, true, false, false, PM_Persist);
			followerHorseNPC.AddTag(followerHorseTag);			
			followerHorseNPC.AddTag('generic_horse');
			followerHorseNPC.SetHideInGame(true);
		}
		
		followerNPC.SetTitle( followerName );
		followerNPC.SetTag( followerTag );
		followerNPC.AttachHorse( followerHorseNPC );
		
		followerNPC.Property(HQX_IsFollower).Init(			"HQX" + followerName + "IsFollower",		0);	
		followerNPC.Property(HQX_IsFollow).Init(			"HQX" + followerName + "Follow",			0);	
		followerNPC.Property(HQX_IsClose).Init(				"HQX" + followerName + "Close",				1);
		followerNPC.Property(HQX_IsFast).Init(				"HQX" + followerName + "Fast",				0);
		followerNPC.Property(HQX_IsShow).Init(				"HQX" + followerName + "Show",				0);
		followerNPC.Property(HQX_IsFight).Init(				"HQX" + followerName + "Fight",				1);	
		followerNPC.Property(HQX_IsImmortal).Init(			"HQX" + followerName + "Immortal",			1);	
		followerNPC.Property(HQX_HasAppearance).Init(		"HQX" + followerName + "Appearance",		0);
		followerNPC.Property(HQX_HasPrevAppearance).Init(	"HQX" + followerName + "AppearancePrev",	0);
		followerNPC.Property(HQX_HasAutoAppearance).Init(	"HQX" + followerName + "AppearanceAuto",	1);
		followerNPC.Property(HQX_HasTorch).Init(			"HQX" + followerName + "Torch",				0);
		followerNPC.Property(HQX_HasPrevTorch).Init(		"HQX" + followerName + "TorchPrev",			0);
		followerNPC.Property(HQX_HasAutoTorch).Init(		"HQX" + followerName + "TorchAuto",			1);
		followerNPC.Property(HQX_HasTeleport).Init(			"HQX" + followerName + "Teleport",			0);
		followerNPC.Property(HQX_HasArea).Init(				"HQX" + followerName + "Area",				0);
		followerNPC.Property(HQX_IsWaitIn).Init(			"HQX" + followerName + "WaitIn",			AN_Undefined);
		followerNPC.Property(HQX_IsOnHorse).Init(			"HQX" + followerName + "OnHorse",			0);
		followerNPC.Property(HQX_IsAlive).Init(				"HQX" + followerName + "IsAlive",			1);
		followerNPC.Property(HQX_IsHome).Init(				"HQX" + followerName + "IsHome",			0);	
		
		
		followerNPC.Enable();
	}
	
	public function RespawnNpc(){
		var followerPosition : Vector;
		var followerRotation : EulerAngles;
		var oldNPC : CNewNPC;
		
		oldNPC = theGame.GetNPCByTag(followerTag);	
		if(oldNPC){
			followerPosition = oldNPC.GetWorldPosition();
			followerRotation = oldNPC.GetWorldRotation();
		}else{
			followerNPC = (CHQXFollowerNPC)theGame.GetNPCByTag(followerTag);
			if(followerNPC){
				followerPosition = followerNPC.GetWorldPosition();
				followerRotation = followerNPC.GetWorldRotation();		
			}else{
				followerPosition = thePlayer.GetWorldPosition();
				followerRotation = thePlayer.GetWorldRotation();
			}			
		}
		RemoveNPC();		
		SpawnNPC(followerPosition,followerRotation);
	}
	
	public function RemoveNPC(){
		var npcs : array<CNewNPC>;
		var i : int;
		theGame.GetNPCsByTag(followerTag, npcs);
		
		for( i = 0; i < npcs.Size(); i += 1 )
		{
			npcs[i].Destroy();
		}
		
		theGame.GetNPCsByTag(followerHorseTag, npcs);
		
		for( i = 0; i < npcs.Size(); i += 1 )
		{
			npcs[i].Destroy();
		}
	}	
	
	public function DeleteNPC(){
		SpawnNPC(Vector(0,0,0),EulerAngles(0,0,0));
		followerNPC.Disable();
		followerNPC.Property(HQX_IsFollower).Remove();	
		followerNPC.Property(HQX_IsFollow).Remove();	
		followerNPC.Property(HQX_IsClose).Remove();	
		followerNPC.Property(HQX_IsFast).Remove();	
		followerNPC.Property(HQX_IsShow).Remove();	
		followerNPC.Property(HQX_IsFight).Remove();	
		followerNPC.Property(HQX_IsImmortal).Remove();	
		followerNPC.Property(HQX_HasAppearance).Remove();	
		followerNPC.Property(HQX_HasPrevAppearance).Remove();	
		followerNPC.Property(HQX_HasAutoAppearance).Remove();	
		followerNPC.Property(HQX_HasTorch).Remove();	
		followerNPC.Property(HQX_HasPrevTorch).Remove();	
		followerNPC.Property(HQX_HasAutoTorch).Remove();	
		followerNPC.Property(HQX_HasTeleport).Remove();	
		followerNPC.Property(HQX_HasArea).Remove();	
		followerNPC.Property(HQX_IsWaitIn).Remove();	
		followerNPC.Property(HQX_IsOnHorse).Remove();	
		followerNPC.Property(HQX_IsAlive).Remove();	
		followerNPC.Property(HQX_IsHome).Remove();
		RemoveNPC();	
	}
	
	public function Debug(){

	}
}

class CHQXFollowerNPC extends CNewNPC {
	private var title			: string;
	default title				= "CHQXFollowerNPC";
	
	private var tag				: name;
	default tag					= 'CHQXFollowerNPC';
	
	private var debugMessage	: string;
	default debugMessage		= "";
	
	private var property		: array <HQXProperty>;
	private var currentArea		: EAreaName;
	default currentArea			= AN_Undefined;	
		
	private var followerIsCold			: bool;
	default followerIsCold				= false;
	private var followerIsDark			: bool;
	default followerIsDark				= false;	
	private var followerIsInteract		: bool;
	default followerIsInteract			= false;	
	private var followerIsCombat		: bool;
	default followerIsCombat			= false;
	private var followerIsCheck			: bool;
	default followerIsCheck				= false;	
	private var followerIsFixTorch		: bool;
	default followerIsFixTorch			= true;
	
	private var followerAiTree 					: CAIHQXFollower;
	private var followerAiTreeIdle 				: CAICommonerReactionTree;
	private var followerAiTreeHorse				: CAIHQXFollowerHorse;
	private var followerAiBehaviourId 			: int;
	private var followerMovingagent 			: CMovingAgentComponent;	
	private var followerAppearance				: HQXAppearanceLookup;
	private var followerHomeLocation			: HQXLocationLookup;
	private var followerAbility					: HQXAbilityLookup;
	
	private var followerDistance 				: float;
	default followerDistance 					= 4.0f;
	private var followerMoveSpeed 				: float;
	default followerMoveSpeed 					= 24.0f;
	
	private var followerHorseNPC 				: CNewNPC;
	private var followerHorseComponent 			: W3HorseComponent;	
	private var followerHorseMovingagent		: CMovingAgentComponent;
	
    event OnSpawned(spawnData: SEntitySpawnData) {
		var newProperty : HQXProperty;	
		var propertyId : int;	
		
        super.OnSpawned(spawnData);	
		
		//ATTITUDE
		SetImmortalityMode(AIM_Immortal, AIC_Default);
		ForceSetStat(BCS_Vitality, thePlayer.GetStatMax(BCS_Vitality));				
		SetTemporaryAttitudeGroup( 'player', AGP_Default );
		SetAttitude( thePlayer, AIA_Friendly );			
		
		AddAbility( 'ConDefault');			
		AddAbility( '_canBeFollower' );
		AddAbility( '_q403Follower' );
		AddAbility( 'Ciri_CombatRegen' );
		AddAbility( 'Ciri_Q305' );
		AddAbility( 'Ciri_Q403' );
		AddAbility( 'ablComboAttacks' );
		AddAbility( 'northern_torch');
			
		SetHealthPerc(100);
		SetLevel(GetWitcherPlayer().GetLevel()*1);				
		SetNPCType( ENGT_Quest );
		SetOriginalInteractionPriority( IP_Prio_4  );
		SetFocusModeVisibility(FMV_Interactive, true);
		
		//SURROUNDINGS
		followerAiTree = new CAIHQXFollower in this;
		followerAiTree.OnCreated();	
		followerAiTreeHorse = new CAIHQXFollowerHorse in this;
		followerAiTreeHorse.OnCreated();			
		followerAiTreeIdle = new CAICommonerReactionTree in this;
		followerAiTreeIdle.OnCreated();		
		
		followerAiBehaviourId = ForceAIBehavior( followerAiTreeIdle, BTAP_Emergency );

		followerAppearance = new HQXAppearanceLookup in this;
		followerHomeLocation = new HQXLocationLookup in this;
		followerAbility = new HQXAbilityLookup in this;
		
		GetComponent( 'talk' ).SetEnabled( true );					
		GetInventory().AddAnItem('Torch' , 1);	
		ApplyItemAbilities(GetInventory().GetItemId('Torch'));
		
		followerMovingagent = GetMovingAgentComponent();
		followerMovingagent.SetGameplayRelativeMoveSpeed(0.0f);
		followerMovingagent.SetDirectionChangeRate(0.16);
		followerMovingagent.SetMaxMoveRotationPerSec(60);		
				
		for( propertyId = 0; propertyId < 20; propertyId += 1 )
		{
			newProperty = new HQXProperty in this;
			property.PushBack(newProperty);
		}
    }
	
	public function SetTitle(newTitle:string){
		title = newTitle;
		followerAppearance.Init(title);
		followerHomeLocation.Init(title); 
		followerAbility.Init(title);
	}
	
	public function SetTag(newTag:name){
		tag = newTag;
	}
	
	public function Property(propertyId : int) : HQXProperty{
		return property[propertyId];
	}	
	
	//ENABLE
	public function Enable(){		
		Show(Property(HQX_IsShow).Get());
		Follow(Property(HQX_IsFollow).Get());
		MoveFast(Property(HQX_IsFast).Get());
		StayClose(Property(HQX_IsClose).Get());
		Immortal(Property(HQX_IsImmortal).Get());
		Torch( Property(HQX_HasTorch).Get());
		Change(Property(HQX_HasAppearance).Get());
		Horse(Property(HQX_IsOnHorse).Get());
		Home(Property(HQX_IsHome).Get());
		Fight(Property(HQX_IsFight).Get());
		
		if(Property(HQX_IsFollow).IsFalse){
			Wait(Property(HQX_IsWaitIn).Get());
		}
		
		if(Property(HQX_IsFollower).IsFalse){
			Stop(true);
		}
		
		//Follow(true); 		//DEBUG
	
		AddTimer('Check', 	0.1f, 	true, , , , true);
		AddTimer('Update', 	0.16f, 	true, , , , true);
		AddTimer('Manage', 	4.0f, 	true, , , , true);
		AddTimer('Welcome',	2.0f,	false);
		CheckNow();
	}
	
	public function Disable(){
		RemoveTimers();
	}
	
	//FOLLOW
	public function Follow (action:bool){
		if(action)
		{
			CancelAIBehavior(followerAiBehaviourId);
			followerAiBehaviourId = ForceAIBehavior( followerAiTree, BTAP_Emergency );
			Property(HQX_IsFollower).SetTrue();
			Property(HQX_IsFollow).SetTrue();
			Property(HQX_IsHome).SetFalse();
		}
		else
		{
			CancelAIBehavior(followerAiBehaviourId);
			followerAiBehaviourId = ForceAIBehavior( followerAiTreeIdle, BTAP_Emergency );
			Property(HQX_IsFollow).SetFalse();
		}
	}
	
	//STOP
	public function Stop(action:bool){
		Home(true);
		Property(HQX_IsFollower).SetFalse();
	}
	
	//SHOW
	public function Show (action:bool){
		if(action)
		{
			SetHideInGame(false);
			Property(HQX_IsShow).SetTrue();
		}
		else
		{
			SetHideInGame(true);			
			Property(HQX_IsShow).SetFalse();
		}
	}
	
	//TORCH
	public function Torch(action:bool){	
		if(action)
		{	
			DrawItems(true,GetInventory().GetItemId('Torch'));	
			GetInventory().PlayItemEffect(GetInventory().GetItemId('Torch'),'light_on');
			Property(HQX_HasTorch).SetTrue();
			followerIsFixTorch = true;
		}
		else
		{
			GetInventory().StopItemEffect(GetInventory().GetItemId('Torch'),'light_on');
			HolsterItems(false,GetInventory().GetItemId('Torch'));
			Property(HQX_HasTorch).SetFalse();
		}		
	}
	
	public function ToggleTorch(action:bool){
		if(Property(HQX_HasTorch).IsTrue)
		{
			Torch(false);
			if(followerIsDark)
			{
				Property(HQX_HasAutoTorch).SetFalse();
			}
		}
		else
		{
			Torch(true);
			if(followerIsDark)
			{
				Property(HQX_HasAutoTorch).SetTrue();
			}
		}
	}
	
	//CLOSE
	public function StayClose(action:bool){
		if(action)
		{
			followerDistance = 4.0f;
			followerAiTree.params.followDistance = followerDistance;
			Property(HQX_IsClose).SetTrue();
		}
		else
		{
			followerDistance = 15.0f;
			followerAiTree.params.followDistance = followerDistance;
			Property(HQX_IsClose).SetFalse();
		}
		Follow(Property(HQX_IsFollow).Get());
	}
	
	//FAST
	public function MoveFast(action:bool){
		if(action)
		{
			followerMoveSpeed = 24.0f;	
			followerAiTree.params.moveSpeed = followerMoveSpeed;
			followerAiTree.params.moveType = MT_Sprint;
			Property(HQX_IsFast).SetTrue();
		}
		else
		{
			followerMoveSpeed = 12.0f;
			followerAiTree.params.moveSpeed = followerMoveSpeed;
			followerAiTree.params.moveType = MT_Run;
			Property(HQX_IsFast).SetFalse();
		}
		Follow(Property(HQX_IsFollow).Get());
	}
	
	//REST
	public function Rest(action:bool){
		SetHealthPerc(100);
		//ADD ANIMATION
	}
	
	//HEAL
	public function HealPlayer(action:bool){
		thePlayer.Heal(thePlayer.abilityManager.GetStatMax(BCS_Vitality));
		thePlayer.abilityManager.DrainToxicity( thePlayer.abilityManager.GetStat( BCS_Toxicity ) );
		thePlayer.abilityManager.DrainFocus( thePlayer.abilityManager.GetStat( BCS_Focus ) );
		//ADD ANIMATION
	}
	
	//IMMORTAL
	public function Immortal(action:bool){
		if(action)
		{
			AddAbility( 'ConImmortal' );
			SetImmortalityMode(AIM_Immortal, AIC_Default);
			ForceVulnerableImmortalityMode();
			Property(HQX_IsImmortal).SetTrue();
		}
		else
		{
			RemoveAbility( 'ConImmortal' );
			ForceVulnerable();	
			Property(HQX_IsImmortal).SetFalse();
		}
	}
	
	//FIGHT
	public function Fight(action:bool){
		if(action)
		{
			Property(HQX_IsFight).SetTrue();
		}
		else
		{
			Property(HQX_IsFight).SetFalse();
		}
	}
	
	//ATTACH HORSE
	public function AttachHorse (newHorse: CNewNPC){
		followerHorseNPC = newHorse;
		followerHorseMovingagent = followerHorseNPC.GetMovingAgentComponent();
		followerHorseComponent = (W3HorseComponent)followerHorseNPC.GetComponentByClassName('W3HorseComponent');
		followerHorseComponent.SetMountableByPlayer(false);
		followerHorseComponent.CanBeUsedBy(this);
		followerHorseComponent.Tame(this,true);
		followerHorseComponent.SetCanTakeDamageFromFalling(false);		
	}
	
	//HORSE
	public function Horse(action:bool){
		if(action)
		{			
			CallHorse(true);			
			SetUsedVehicle(followerHorseNPC);			
			CancelAIBehavior(followerAiBehaviourId);
			followerAiBehaviourId = ForceAIBehavior(followerAiTreeHorse, BTAP_Emergency, 'AI_Rider_Load_Forced' );
			SignalGameplayEvent( 'MountHorse');
			Property(HQX_IsOnHorse).SetTrue();
			followerDistance = 10.0f;
		}
		else
		{
			SignalGameplayEvent( 'RequestInstantDismount');
			ForceAIUpdate();	
			Property(HQX_IsOnHorse).SetFalse();			
			Follow(Property(HQX_IsFollow).Get());
			StayClose(Property(HQX_IsClose).Get());
		}
	}
	
	//CHANGE
	public function Change(appearance : HQXAppearanceName){	
		ApplyAppearance(followerAppearance.GetAppearance(appearance));			
		Property(HQX_HasAppearance).Set(appearance);
	}
	
	public function ToggleChange(action:bool){
		if(Property(HQX_HasAppearance).Is(HQX_Normal))
		{
			Change(HQX_Alternativ);
		}
		else if(Property(HQX_HasAppearance).Is(HQX_Alternativ))
		{
			Change(HQX_Cold);
			if(followerIsCold)
			{
				Property(HQX_HasAutoAppearance).SetTrue();
			}
		}
		else if(Property(HQX_HasAppearance).Is(HQX_Cold))
		{
			Change(HQX_Normal);
			if(followerIsCold)
			{
				Property(HQX_HasAutoAppearance).SetFalse();
			}
		}
	}	
	
	//WAIT IN
	public function Wait (area:EAreaName){
		var position: Vector;		
		switch(area)
		{	
			case AN_Kaer_Morhen:
				position = Vector(69.420433, 23.712099, 170.753799);
				break;		
			case AN_Skellige_ArdSkellig:
				position = Vector(-134.744492, 741.834229, 96.579811);
				break;
			case AN_NMLandNovigrad:
				position = Vector(721.880432, 1732.422241, 4.636669);
				break;
			case AN_Undefined:
				position = GetWorldPosition();
				break;
		}
		Follow(false);
		MoveToWithRotation(position, GetWorldRotation());
		Property(HQX_IsWaitIn).Set(area);
		
		if(area != AN_Undefined){
			Property(HQX_HasArea).Set(area);
		}
	}
	
	//HOME
	public function Home (action:bool){
		if(action)
		{	
			Follow(false);
			MoveToWithRotation(followerHomeLocation.GetPosition(), followerHomeLocation.GetRotation());
			Property(HQX_IsWaitIn).Set(followerHomeLocation.GetArea());
			Property(HQX_HasArea).Set(followerHomeLocation.GetArea());
			Property(HQX_IsHome).SetTrue();
		}
	}

	//TELEPORT
	public function TeleportPlayer(action:bool){
		var initData : W3MapInitData;
		Property(HQX_HasTeleport).SetTrue();
		Property(HQX_IsFollow).SetTrue();
		
		initData = new W3MapInitData in this;
		initData.SetTriggeredExitEntity( true );
		initData.ignoreSaveSystem = true;
		initData.setDefaultState('FastTravel');
		theGame.RequestMenuWithBackground( 'MapMenu', 'CommonMenu', initData );
	}	
	
	//INERACT
	public function Interact (action:bool){
		PlayVoiceset( 90, 'greeting_geralt' );
		followerIsInteract = true;	
		Show(false);		
	}
	
	//LEAVE INTERACTION
	public function LeaveInteraction(action: bool){
		followerIsInteract = false;
		if(VecDistance(thePlayer.GetWorldPosition(), GetWorldPosition()) <= (followerDistance*2)) 
		{
			if(Property(HQX_IsFollower).IsTrue){
				MoveToTalk();
			}
		}
		CheckNow();
	}
	
	public function Call(action:bool){
		if(Property(HQX_IsFollower).IsTrue&&!followerIsInteract){
			Property(HQX_HasArea).Set(currentArea);
			Follow(true);
			Show(true);
			MoveToTalk();
			CheckNow();
		}
	}
	
	public function CallHorse(action:bool){
		followerHorseComponent.ResetPanic();
		followerHorseNPC.Teleport( GetWorldPosition() + GetWorldForward() * 1.0f );
		followerHorseNPC.SetHideInGame(false);
	}

	//MOVE TO
	public function MoveToTalk(){
		Teleport( thePlayer.GetWorldPosition() + thePlayer.GetWorldForward() * 1.6f );
		if(Property(HQX_IsOnHorse).IsTrue){
			followerHorseNPC.Teleport(thePlayer.GetWorldPosition() + thePlayer.GetWorldForward() * 1.6f);
		}
	}
	
	public function MoveToPlayer(){
		if(!thePlayer.IsSwimming() && !thePlayer.IsDiving() && !thePlayer.IsSailing())
		{
			if(!IsAttacking()&&!IsInCombat())
			{
				if (thePlayer.IsOnGround())
				{
					if(Property(HQX_IsOnHorse).IsTrue){
						followerHorseMovingagent.TeleportBehindCamera(false);
					}else{
						followerMovingagent.TeleportBehindCamera(false);	
					}								
				}
			}
		}
	}
	
	public function MoveTo(location : Vector){
		Teleport(location);
	}
	
	public function MoveToWithRotation(location : Vector, rotation : EulerAngles ){
		TeleportWithRotation(location, rotation);
	}	
	
	//FIX TORCH
	private function FixTorch(){
		var torch : CEntity;
		var torchId: SItemUniqueId;
		var mesh : CComponent;		
		var rotation : EulerAngles;
		var position : Vector;	
		
		torchId = GetInventory().GetItemId('Torch');
		torch = GetInventory().GetItemEntityUnsafe(torchId);
		if(!torch)
		{
			followerIsFixTorch = true;
			return;
		}
		else
		{
			followerIsFixTorch = false;
		}
		
		rotation.Pitch = 180;
		rotation.Roll = 10;
		position.X=0.08f;
		position.Y=0.03f;
		position.Z=0.0f;
			
		mesh = torch.GetComponent("CRigidMeshComponent0");	
		mesh.SetScale(Vector(0.6f,0.6f,0.6f));
		mesh.SetRotation(rotation);
		mesh.SetPosition(position);
		
		GetInventory().PlayItemEffect(torchId,'light_on');
	}
	
	public function AddToDebug(title : string, value : bool ) {
		if(value){
			debugMessage = debugMessage + " | " + title + " : TRUE";
		}else{
			debugMessage = debugMessage + " | " + title + " : FALSE";
		} 
	}
	
	public function ResetDebug() {
		debugMessage = "";	
	}
	
	public function Debug() :string {
		var message : string;
		message = "DEBUG "+title+" : "+ debugMessage;
		return message;
	}

	public function CanStartTalk() : bool
	{
		if( IsAtWork() && !IsConsciousAtWork() ){
			return false;	
		}
		if(Property(HQX_IsShow).IsFalse || followerIsInteract){
			return false;
		}
		return !IsFrozen() && !HasBuff(EET_Confusion);
	}
	
	timer function Welcome(deltaTime: float, id: int) {
		thePlayer.hqxFollowerSystem.WelcomeFollower();
	}
	
	function CheckNow() {
		followerIsCheck = true;
	}	
	
	timer function Check(deltaTime: float, id: int) {
		if(followerIsCheck){
			followerIsCheck = false;
			if(currentArea == AN_Undefined){
				currentArea	= theGame.GetCommonMapManager().GetCurrentArea();
				followerIsCheck = true;
			}else{
				if(Property(HQX_HasArea).Is(currentArea)){
					if(!followerIsInteract){
						if(Property(HQX_IsShow).IsFalse){
							Show(true);
						}
						if(Property(HQX_HasTeleport).IsTrue){
							MoveToTalk();
							Property(HQX_HasTeleport).SetFalse();
						}
						if(Property(HQX_IsWaitIn).Is(currentArea)){
							Property(HQX_IsWaitIn).Set(AN_Undefined);
						}
					}
				}else if(Property(HQX_IsFollow).IsTrue){
					Property(HQX_HasArea).Set(currentArea);
					followerIsCheck = true;
				}else{
					if(Property(HQX_IsShow).IsTrue){
						Show(false);
					}					
				}			
			}
		}
	}
	
    timer function Update(deltaTime: float, id: int) {
		var distance : float;
		var moveSpeed : float;
		var maxDistance : float;
		if(Property(HQX_IsAlive).IsTrue){
			maxDistance = 3.0 * followerDistance;
			moveSpeed = 2.5;
						
			if(Property(HQX_IsFollow).IsFalse || Property(HQX_IsShow).IsFalse || followerIsInteract){
				moveSpeed = 0.0;
			}else{
				distance = VecDistance(thePlayer.GetWorldPosition(), GetWorldPosition()); 
				if(distance <= followerDistance){
					moveSpeed = 0.0;
				}else{
					moveSpeed = MinF((distance - followerDistance) / maxDistance, 1.0) * followerMoveSpeed * 1.4f;
					if(distance > MaxF(maxDistance, 60)){
						MoveToPlayer();
					}				
				}
			}
			followerMovingagent.SetGameplayRelativeMoveSpeed(moveSpeed);
			if(followerIsFixTorch){
				FixTorch();
			}
		}
	}
	
	timer function Manage(deltaTime: float, id: int) {	
		if(Property(HQX_IsAlive).IsTrue){
			if((GetDayPart(theGame.GetGameTime()) == EDP_Midnight)||(GetCurWeather() == EWE_Snow)||(GetCurWeather() == EWE_Storm)){
				if(!IsInInterior()){
					if(!followerIsCold){
						if(Property(HQX_HasAutoAppearance).IsTrue){
							Property(HQX_HasPrevAppearance).Set(Property(HQX_HasAppearance).Get());							
							Change(HQX_Cold);
						}
						followerIsCold = true;
					}
				}
			}else{
				if(followerIsCold){
					if(Property(HQX_HasAutoAppearance).IsTrue){	
						Change(Property(HQX_HasPrevAppearance).Get());
					}
					followerIsCold = false;				
				}
			}
			
			if((GetDayPart(theGame.GetGameTime()) == EDP_Midnight)||(GetWitcherPlayer().IsInDarkPlace())){
				if(!followerIsDark){			
					if(Property(HQX_HasAutoTorch).IsTrue){
						Property(HQX_HasPrevTorch).Set(Property(HQX_HasTorch).Get());
						Torch(true);
					}
					followerIsDark = true;
				}
			}else{	
				if(followerIsDark){
					if(Property(HQX_HasAutoTorch).IsTrue){
						Torch(Property(HQX_HasPrevTorch).IsTrue);
					}			
					followerIsDark = false;
				}
			}
	
			if(Property(HQX_IsFollow).IsTrue && !followerIsInteract)
			{
				if((followerMovingagent.GetSpeed()<=0.01f)||(VecLength(followerMovingagent.GetVelocity())<=0.01f))
				{
					if(VecDistance(thePlayer.GetWorldPosition(), GetWorldPosition()) > (followerDistance * 1.5f))
					{				
						MoveToPlayer();
					}					
				}		
				if(!followerMovingagent.IsPositionValid(followerMovingagent.GetAgentPosition()))
				{
					MoveToPlayer();
				}	
				if(thePlayer.IsUsingHorse(true) && Property(HQX_IsOnHorse).IsFalse){
					if(!thePlayer.IsInCombat() && !IsInCombat() && followerAbility.HasHorse()){
						thePlayer.hqxFollowerSystem.SetFollower(tag,"interactHorse",true);
					}						
				}
				else if(!IsUsingHorse(true) && Property(HQX_IsOnHorse).IsTrue){
					thePlayer.hqxFollowerSystem.SetFollower(tag,"interactHorse",false);
				}	
				else if(thePlayer.IsInCombat() && Property(HQX_IsOnHorse).IsTrue){
					thePlayer.hqxFollowerSystem.SetFollower(tag,"interactHorse",false);
				}			
			}
			if(IsInCombat()){				
				if(Property(HQX_HasTorch).IsTrue){				
					Torch(false);
				}
				if(Property(HQX_IsOnHorse).IsTrue){				
					Horse(false);
				}
			}
			if((thePlayer.IsInCombat() || IsInCombat()) && !followerIsCombat){
				if(Property(HQX_IsFight).IsFalse){
					CancelAIBehavior(followerAiBehaviourId);
					followerAiBehaviourId = ForceAIBehavior( followerAiTreeIdle, BTAP_AboveEmergency2 );
					ForceAIUpdate();
					ClearAttitudes(true,true,true);				
					SetImmortalityMode(AIM_Immortal, AIC_Default);
					ForceVulnerableImmortalityMode();
				}
				followerIsCombat = true;
			}
			
			if(!thePlayer.IsInCombat() && !IsInCombat() && followerIsCombat){
				Follow(Property(HQX_IsFollow).Get());
				Immortal(Property(HQX_IsImmortal).Get());
				followerIsCombat = false;
			}	

			if(!IsAlive()){
				if(Property(HQX_IsImmortal).IsTrue){
					thePlayer.hqxFollowerSystem.SetFollower(tag,"respawn",true);
				}else{
					Property(HQX_IsAlive).SetFalse();				
				}	
			}
		}
	}	
}


//CAI

class CAIHQXFollower extends CAIFollowAction
{	
	function Init(){
		super.Init();		
		customSteeringGraph 			= LoadSteeringGraph( "gameplay/behaviors/npc/steering/action/follow_side_by_side.w2steer" );
		params.moveType 				= MT_Sprint;
		params.moveSpeed 				= 2.5f;
		params.followDistance 			= 6.5f;
		params.teleportToCatchup		= true;
		params.cachupDistance			= 70.0;
	}
	
	editable var useCustomSteering		: bool;
	editable var customSteeringGraph	: CMoveSteeringBehavior;
	
	default useCustomSteering 	= true;	
}

class CAIHQXFollowerHorse extends IRiderActionTree
{		
	editable inlined var params 		: CAIHQXFollowerHorseParams;
	
	default aiTreeName = "resdef:ai\scripted_actions/rider_follow_side_by_side";
	
	function Init()
	{
		params = new CAIHQXFollowerHorseParams in this;
		params.OnCreated();
	}
}

class CAIHQXFollowerHorseParams extends CAIRiderFollowActionParams
{		
	editable var useCustomSteering			: bool;
	editable var customSteeringGraph		: CMoveSteeringBehavior;
	editable var horseCustomSteeringGraph	: CMoveSteeringBehavior;
	
	default useCustomSteering 			= true;
	
	function Init()
	{
		customSteeringGraph 		= LoadSteeringGraph( "gameplay/behaviors/npc/steering/action/follow_side_by_side.w2steer" );
		horseCustomSteeringGraph 	= LoadSteeringGraph( "gameplay/behaviors/npc/steering/action/horse_follow_side_by_side.w2steer" );
		followDistance 				= 1.0;
		moveType 					= MT_Sprint;
		matchRiderMountStatus		= false;

		super.Init();	
	}	
	
	function CopyTo_SideBySide( followSideBySideAction : CAIFollowSideBySideAction )
	{
		super.CopyTo( followSideBySideAction.params );
		
		followSideBySideAction.useCustomSteering 		= true;
		followSideBySideAction.customSteeringGraph 		= horseCustomSteeringGraph;
	}
};