// Copyright © 2017 CD Projekt RED | HQX
// V.1.0.4
class HQXProperty
{
	private var PropertyValue	: int;
	private var PropertyFact 	: string;
	
	public var IsTrue			: bool;
	public var IsFalse			: bool;
	public var IsNew			: bool;
	
	default IsTrue = false;
	default IsFalse = true;
	default IsNew = false;
	
	public function Init(newName : string, initial : int){
		PropertyFact = newName;
		IsNew = false;
		if(!FactsDoesExist( PropertyFact )){
			FactsAdd( PropertyFact, initial, -1);
			IsNew = true;
			Set(initial);

		}else{
			Set(FactsQueryLatestValue(PropertyFact));
		}
	}
	
	public function Set(newValue : int){
		PropertyValue = newValue;
		if(FactsQueryLatestValue(PropertyFact) != PropertyValue) {
			FactsSet( PropertyFact, PropertyValue, -1);
			IsNew = false;
		}		
		IsTrue = Is(1);
		IsFalse = Is(0);

	}
	
	public function SetFalse(){
		Set(0);
	}
	
	public function SetTrue(){
		Set(1);
	}
	
	public function Toggle(){
		if(Get()==1){
			Set(0);
		}else{
			Set(1);
		}
	}
	
	public function Get() : int
	{
		return PropertyValue;
	}
	
	public function GetName() : string
	{
		return PropertyFact;
	}
	
	public function Remove()
	{
		FactsRemove(GetName());
	}
	
	public function Is(value:int) : bool
	{
		if(PropertyValue == value)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

class HQXAppearanceLookup{

	var followerName : string;
	
	public function Init(follower : string){
		followerName = follower;
	}

	public function GetAppearance(appearanceName : HQXAppearanceName) : String{
		if(appearanceName == HQX_Normal){
				if(followerName=="cirilla"){	return "ciri";}
				if(followerName=="yennefer"){	return "yennefer_gown";}
				if(followerName=="triss"){		return "triss";}
				if(followerName=="keira"){		return "keira_metz";}
				if(followerName=="lambert"){	return "lambert";}
		}
		else if(appearanceName == HQX_Alternativ){
				if(followerName=="cirilla"){	return "ciri_winter";}
				if(followerName=="yennefer"){	return "yennefer_travel_outfit";}
				if(followerName=="triss"){		return "triss_dress";}
				if(followerName=="keira"){		return "keira_metz_sorceress";}
				if(followerName=="lambert"){	return "lambert";}
		}
		else if(appearanceName == HQX_Cold){
				if(followerName=="cirilla"){	return "__q505_hooded";}
				if(followerName=="yennefer"){	return "yennefer_hooded";}
				if(followerName=="triss"){		return "triss_hooded_01";}
				if(followerName=="keira"){		return "keira_metz";}
				if(followerName=="lambert"){	return "lambert_vesemirs_hat";}
		}
		return "";
	}
}

class HQXAbilityLookup{

	var followerName : string;
	
	public function Init(follower : string){
		followerName = follower;
	}

	public function HasHorse() : bool{
		if(followerName=="cirilla"){	return true;}
		if(followerName=="yennefer"){	return true;}
		if(followerName=="triss"){		return false;}
		if(followerName=="keira"){		return true;}
		if(followerName=="lambert"){	return true;}
		return false;
	}
}

class HQXLocationLookup{

	var followerName : string;
	
	public function Init(follower : string){
		followerName = follower;
	}

	public function GetPosition() : Vector{
		if(followerName=="cirilla"){	return Vector(79.352943, 14.100459, 170.753799);}
		if(followerName=="yennefer"){	return Vector(69.420433, 23.712099, 170.753799);}
		if(followerName=="triss"){		return Vector(72.515518, 32.129211, 170.737990);}
		if(followerName=="keira"){		return Vector(-262.255203, -112.215744, 7.596290);}
		if(followerName=="lambert"){	return Vector(-261.255203, -111.215744, 7.596290);}
		return Vector(0,0,0);
	}
	
	public function GetRotation() : EulerAngles {
		if(followerName=="cirilla"){	return EulerAngles(0,85,0);}
		if(followerName=="yennefer"){	return EulerAngles(0,190,0);}
		if(followerName=="triss"){		return EulerAngles(0,130,0);}
		if(followerName=="keira"){		return EulerAngles(0,116,0);}
		if(followerName=="lambert"){		return EulerAngles(0,80,0);}
		return EulerAngles(0,0,0);
	}
	
	public function GetArea() : EAreaName {
		if(followerName=="cirilla"){	return AN_Kaer_Morhen;}
		if(followerName=="yennefer"){	return AN_Kaer_Morhen;}
		if(followerName=="triss"){		return AN_Kaer_Morhen;}
		if(followerName=="keira"){		return AN_NMLandNovigrad ;}
		if(followerName=="lambert"){	return AN_NMLandNovigrad ;}
		return AN_Undefined;
	}
}


enum HQXPropertyName
{
	HQX_IsFollower,
	HQX_IsFollow,
	HQX_IsClose,
	HQX_IsFast,
	HQX_IsShow,
	HQX_IsImmortal,
	HQX_HasAppearance,
	HQX_HasPrevAppearance,
	HQX_HasAutoAppearance,
	HQX_HasTorch,
	HQX_HasPrevTorch,
	HQX_HasAutoTorch,
	HQX_HasTeleport,
	HQX_HasArea,
	HQX_HasPosition,
	HQX_IsWaitIn,
	HQX_IsOnHorse,
	HQX_IsAlive,	
	HQX_IsHome,
	HQX_IsFight,
};

enum HQXAppearanceName
{
	HQX_Normal,
	HQX_Alternativ,
	HQX_Cold,
};
