/***********************************************************************/
/** 	 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class W3Effect_Plaguebearer extends CBaseGameplayEffect
{
		var		slave					: CEntity;
		var		slavetemplate			: CEntityTemplate;
		
		default effectType 				= EET_Plaguebearer;
		default isPositive 				= false;
		default isNegative 				= true;
		default abilityName  			= 'PlaguebearerEffect';
		
		
	event OnEffectAdded(optional customParams : W3BuffCustomParams)
	{
		super.OnEffectAdded(customParams);
		target.AddAbility( 'DisableFinishers', false );
		target.SoundEvent("fx_rune_activate_axii");
	}		
		
	public function OnTargetDeath()
	{	
		super.OnTargetDeath();
		
		if( target.IsHuman() && !((CNewNPC)target).IsVIP() && !target.HasTag('Quest') && !target.HasTag('quest') && !((CActor)target).IsImmortal() && !((CActor)target).WillBeUnconscious() && !target.HasTag('PLAYER') )
		{
			if(CanSpawnSlave())
			{
				DismemberTarget();
				slavetemplate = (CEntityTemplate)LoadResource("dlc\devilspit\data\quests\secondary_npcs\plagueslave.w2ent",true);
				slave = theGame.CreateEntity(slavetemplate, target.GetWorldPosition(), target.GetWorldRotation());
				
				if(target.IsMan())
				{
					target.SoundEvent("grunt_vo_test_falling_scream_AdultMale", 'head');
				}
				
				if(target.IsWoman())
				{
					target.SoundEvent("grunt_vo_test_falling_scream_AdultFemale", 'head');
				}
				
				target.DestroyAfter(3.0f);
			}
		}
	}
	
	function DismemberTarget()
	{
		var actor 				: CActor;	
		var dismembermentComp 	: CDismembermentComponent;
		var wounds				: array< name >;
		var usedWound			: name;
	
		actor = target;
		if(!actor) return;
		dismembermentComp = (CDismembermentComponent)(actor.GetComponentByClassName( 'CDismembermentComponent' ));
		if(!dismembermentComp) return;
	
		dismembermentComp.GetWoundsNames( wounds, WTF_Explosion );
	
		if ( wounds.Size() > 0 )
						usedWound = wounds[ RandRange( wounds.Size() ) ];
					
		actor.SetDismembermentInfo( usedWound, actor.GetWorldPosition() - actor.GetWorldPosition(), true );
		actor.AddTimer( 'DelayedDismemberTimer', 0.05f );	
	}
	
	function CanSpawnSlave() : bool
	{
		var slaves   		: array <CEntity>;
		var i				: int;
		var aliveslaves		: int;
		
		theGame.GetEntitiesByTag( 'PLAGUESLAVE', slaves );
		
		for ( i = 0; i < slaves.Size(); i+=1 )
		{
			if( ((CActor)slaves[i]).IsAlive() )
				aliveslaves += 1;
		}
		
		if(aliveslaves < 5)
		{
			return true;
		}
		else
		{
			return false;
		}		
	}

}