/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

statemachine class CDPCooker extends W3Container
{
	saved var isburning : bool; default isburning = false;
	var fakefoodtemplate : CEntityTemplate;
	var fakefood : CEntity;
	var fakefoodpos : Vector;
	var myinv	: CInventoryComponent;
	var fakefoodexists : bool;	default fakefoodexists = false;
	var icount : int;
	var invitems : array<name>;
	var doubletap : bool; default doubletap = false;

	event OnSpawned(spawnData : SEntitySpawnData )
	{
		super.OnSpawned(spawnData);
		
		fakefoodtemplate = (CEntityTemplate)LoadResource("quests\part_1\quest_files\q401_konsylium\entities\omelette\q401_bowl_mixture.w2ent",true);
		fakefoodpos = this.GetWorldPosition();
		fakefoodpos.Z += 0.5;	
		
		myinv = this.GetInventory();
		
		if(!myinv.IsEmpty())
		{
			SpawnFakeFood();
		}
		
		if(isburning && !myinv.IsEmpty())
		{
			GetComponentByClassName('CInteractionComponent').SetEnabled( false );
			AddTimer( 'Cook', 10, false );
			this.PlayEffect('fire');
			AddTimer( 'DelayedSound', 0.033, false );
		}
		
		GotoState('Idle');
	}
	
	timer function DelayedSound( time : float, id : int)
	{
			this.SoundEvent("fx_fire_burning_strong_begin");
			this.SoundEvent("amb_qu_cooking_soup_boiling_20m_loop");	
	}
	
	timer function Cook( time : float, id : int)
	{
		icount = myinv.GetAllItemsQuantity(true);
		invitems = myinv.GetItemsNames();
		if( myinv.GetItemQuantityByName('Egg',true) > 0 && myinv.GetItemQuantityByName('Pepper',true) > 0 && myinv.GetItemQuantityByName('Olive',true) > 0 && myinv.GetItemQuantityByName('Onion',true) > 0 && myinv.GetItemQuantityByName('Mushroom',true) > 0 && myinv.GetItemQuantityByName('Pork',true) > 0 )
		{
			myinv.RemoveAllItems();
			myinv.AddAnItem('DP_omelet',icount);		
		}
		if( myinv.GetItemQuantityByName('Pork',true) > 0 )
		{
			myinv.AddAnItem( 'Grilled pork', myinv.GetItemQuantityByName('Pork',true) );	
			myinv.RemoveItemByName( 'Pork', myinv.GetItemQuantityByName('Pork',true) );
		}
		if( myinv.GetItemQuantityByName('Chicken leg',true) > 0 )
		{
			myinv.AddAnItem( 'Free roasted chicken leg', myinv.GetItemQuantityByName('Chicken leg',true) );	
			myinv.RemoveItemByName( 'Chicken leg', myinv.GetItemQuantityByName('Chicken leg',true) );
		}		
		if( myinv.GetItemQuantityByName('Chicken',true) > 0 )
		{
			myinv.AddAnItem( 'Roasted chicken', myinv.GetItemQuantityByName('Chicken',true) );	
			myinv.RemoveItemByName( 'Chicken', myinv.GetItemQuantityByName('Chicken',true) );
		}
		if( myinv.GetItemQuantityByName('Fish',true) > 0 )
		{
			myinv.AddAnItem( 'Fried fish', myinv.GetItemQuantityByName('Fish',true) );	
			myinv.RemoveItemByName( 'Fish', myinv.GetItemQuantityByName('Fish',true) );
		}	
		if( myinv.GetItemQuantityByName('Raw meat',true) > 0 )
		{
			myinv.AddAnItem( 'Fried meat', myinv.GetItemQuantityByName('Raw meat',true) );	
			myinv.RemoveItemByName( 'Raw meat', myinv.GetItemQuantityByName('Raw meat',true) );
		}			
		if( myinv.GetItemQuantityByName('Gutted fish',true) > 0 )
		{
			myinv.AddAnItem( 'Fried fish', myinv.GetItemQuantityByName('Gutted fish',true) );	
			myinv.RemoveItemByName( 'Gutted fish', myinv.GetItemQuantityByName('Gutted fish',true) );
		}
		if( myinv.GetItemQuantityByName('Honeycomb',true) > 0 )
		{
			myinv.AddAnItem( 'Very good honey', myinv.GetItemQuantityByName('Honeycomb',true) );	
			myinv.RemoveItemByName( 'Honeycomb', myinv.GetItemQuantityByName('Honeycomb',true) );
		}	
		if( myinv.GetItemQuantityByName('Bread',true) > 0 )
		{
			myinv.AddAnItem( 'Burned bread', myinv.GetItemQuantityByName('Bread',true) );	
			myinv.RemoveItemByName( 'Bread', myinv.GetItemQuantityByName('Bread',true) );
		}			
		if( myinv.GetItemQuantityByName('Bun',true) > 0 )
		{
			myinv.AddAnItem( 'Burned bun', myinv.GetItemQuantityByName('Bun',true) );	
			myinv.RemoveItemByName( 'Bun', myinv.GetItemQuantityByName('Bun',true) );
		}
		if( myinv.GetItemQuantityByName('Apple',true) > 0 )
		{
			myinv.AddAnItem( 'Baked apple', myinv.GetItemQuantityByName('Apple',true) );	
			myinv.RemoveItemByName( 'Apple', myinv.GetItemQuantityByName('Apple',true) );
		}
		if( myinv.GetItemQuantityByName('Potatoes',true) > 0 )
		{
			myinv.AddAnItem( 'Baked potato', myinv.GetItemQuantityByName('Potatoes',true) );	
			myinv.RemoveItemByName( 'Potatoes', myinv.GetItemQuantityByName('Potatoes',true) );
		}
		if( myinv.GetItemQuantityByName('Onion',true) > 0 && myinv.GetItemQuantityByName('Bottled water',true) > 0 )
		{
			myinv.AddAnItem( 'Onion soup', myinv.GetItemQuantityByName('Onion',true) + myinv.GetItemQuantityByName('Bottled water',true) );	
			myinv.RemoveItemByName( 'Onion', myinv.GetItemQuantityByName('Onion',true) );
			myinv.RemoveItemByName( 'Bottled water', myinv.GetItemQuantityByName('Bottled water',true) );
		}		
		
		doubletap = false;
		GetComponentByClassName('CInteractionComponent').SetEnabled( true );
		this.StopAllEffects();
		this.SoundEvent("fx_fire_burning_strong_end");
		this.SoundEvent("amb_qu_cooking_soup_boiling_20m_loop_end");
		isburning = false;		
	}		
	
	event OnInteraction( actionName : string, activator : CEntity )
	{	
		if(doubletap)
		{
			RemoveTimer( 'PutInItemsQueue' );
			
			if(!isburning && !myinv.IsEmpty())
			{
				thePlayer.PlayerStartAction( PEA_IgniLight );
				GetComponentByClassName('CInteractionComponent').SetEnabled( false );
				AddTimer( 'DelayedCooking', 0.8, false );
			}
			else
			{
				doubletap = false;
			}
		}
		
		if(!doubletap)
		{
			AddTimer( 'PutInItemsQueue', 0.18, false );
			doubletap = true;
		}			
		
	}
	
	timer function DelayedCooking( time : float, id : int)
	{
		AddTimer( 'Cook', 10, false );
		this.PlayEffect('fire');
		this.SoundEvent("fx_fire_burning_strong_begin");
		this.SoundEvent("amb_qu_cooking_soup_boiling_20m_loop");
		isburning = true;
	}
	
	timer function PutInItemsQueue( time : float, id : int)
	{
			GotoState('Idle');
			GotoState( 'Active' );
			doubletap = false;
	}
	
	function SpawnFakeFood()
	{
		if(!fakefoodexists)
		{
			fakefood = theGame.CreateEntity( fakefoodtemplate, fakefoodpos, this.GetWorldRotation() );	
			fakefoodexists = true;
		}
	}
	
	function RemoveFakeFood()
	{
		if(fakefoodexists)
		{
			fakefood.Destroy();
			fakefoodexists = false;
		}
	}
	
	event OnAardHit( sign : W3AardProjectile )
	{
		if(isburning)
		{
			this.StopAllEffects();
			GetComponentByClassName('CInteractionComponent').SetEnabled( true );
			RemoveTimer( 'Cook' );
			this.SoundEvent("fx_fire_burning_strong_end");
			this.SoundEvent("amb_qu_cooking_soup_boiling_20m_loop_end");		
			isburning = false;
			doubletap = false;
		}
	}	
	
	event OnIgniHit( sign : W3IgniProjectile )
	{
		if(!isburning && !myinv.IsEmpty())
		{
			GetComponentByClassName('CInteractionComponent').SetEnabled( false );
			AddTimer( 'Cook', 10, false );
			this.PlayEffect('fire');
			this.SoundEvent("fx_fire_burning_strong_begin");
			this.SoundEvent("amb_qu_cooking_soup_boiling_20m_loop");
			isburning = true;
		}
	}		
	
}

state Idle in CDPCooker
{
}

state Active in CDPCooker
{
	var alloweditems : array<name>;
	var filtertags	 : array<name>;
	var mytagz	 : array<name>;
	
	event OnEnterState(prevStateName : name)
	{
		mytagz = parent.GetTags();
		Run();
		GotoState('Idle');		
	}

	entry function Run()
	{
		alloweditems.PushBack('Egg');
		alloweditems.PushBack('Pepper');
		alloweditems.PushBack('Olive');
		alloweditems.PushBack('Onion');		
		filtertags.PushBack('Edibles');
		
		CollectItems ('DPCOOKER', alloweditems, "COOKER", true, filtertags, false);
	}
	

latent function CollectItems ( collectorTag : name, items : array<name>, uniqueTransactionId : string, keepItemsInContainer : bool, optional filterTagsList : array<name>, optional singleItemContainer : bool ) : bool
{
	var popupData : W3ItemSelectionPopupData;
	var itemSelectionPopup : CR4ItemSelectionPopup;
	var inventory : CInventoryComponent;
	var received, alreadyCollected : bool;
	var factId : string;
	var i, collectedCount : int = 0;	
	var result : bool;
	var ent : CGameplayEntity;
	var itemsBeforeChange : array<name>;
	var itemsAfterChange : array<name>;
	
	ent = (CGameplayEntity)theGame.GetEntityByTag( collectorTag );
	if( !ent )
	{
		return false;
	}
	
	inventory = ent.GetInventory();
	if( !inventory )
	{
		return false;
		theGame.GetGuiManager().ShowUserDialogAdv(0, "NO INVENTORY", "SADLY", false, UDB_Ok);	
	}	
	itemsBeforeChange = inventory.GetItemsNames();
	theGame.GetGuiManager().SetLastOpenedCommonMenuName( 'None' ); 		
	
	if (singleItemContainer)
	{
		popupData = new W3ItemSelectionPopupData in theGame.GetGuiManager();
		popupData.targetInventory = inventory;
		popupData.collectorTag = collectorTag;
		popupData.filterTagsList = filterTagsList;
		popupData.targetItems = items;
		
		theGame.RequestPopup('ItemSelectionPopup', popupData);
		
		while (popupData)
		{
			SleepOneFrame();
		}
	}
	else
	{
		OpenContainerQuest( collectorTag, filterTagsList);		
		
		while( theGame.GetGuiManager().GetLastOpenedCommonMenuName() == 'None' ) 
		{ 
			SleepOneFrame();
		}
    }
    
	itemsAfterChange = inventory.GetItemsNames();
	for( i = itemsAfterChange.Size() - 1; i >= 0 ; i-=1  )
	{
		if( itemsBeforeChange.Contains( itemsAfterChange[ i ] ) )
		{
			itemsAfterChange.Erase( i );
		}
	}
	
	if( itemsAfterChange.Size() == 0 )
	{
		if(inventory.IsEmpty())
		{
			parent.RemoveFakeFood();
		}
		return false;
	}

	for( i = 0; i < items.Size(); i+=1  )
	{
		factId = uniqueTransactionId + "_" + items[i];
		received = itemsAfterChange.Contains( items[i] );
		alreadyCollected = FactsQuerySum( factId ) > 0;
		
		if( alreadyCollected )
			collectedCount += 1;
		
		if( received )
		{
			if( !alreadyCollected )
			{				
				FactsAdd( factId );
				if (!keepItemsInContainer)
				{
					inventory.RemoveItemByName( items[i] );
				}
				collectedCount += 1;
				result = true;
			}
			else if( result != true )		
			{			
				result = false;
			}					
		}
	}
		
	parent.SpawnFakeFood();
		
	return result;
}	

}