/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class W3DPDopplerSummon extends CInteractiveEntity
{
	event OnInteraction( actionName : string, activator : CEntity )
	{
		theGame.SaveGame(SGT_ForcedCheckPoint, 0);
		thePlayer.TeleportWithRotation(  Vector(1096.355, 642.057, 3.03, 1) + this.GetHeadingVector() * -1.1 , EulerAngles(0, 170, 0) );
		thePlayer.PlayerStartAction( PEA_InspectLow );
		GetComponentByClassName('CInteractionComponent').SetEnabled( false );
		AddTimer( 'DelayedSound', 0.7, false );
		AddTimer( 'DelayedFreePlayer', 3.2, false );
		AddTimer( 'DelayedPrepareCombat', 3.6, false );
		AddTimer( 'SpawnDoppler', 4.5, false );
	}	
	
	timer function DelayedSound( time : float, id : int)
	{
		this.SoundEvent("magic_geralt_invisible_loop");
	}
	
	timer function DelayedFreePlayer( time : float, id : int)
	{
		thePlayer.PlayerStopAction( PEA_InspectLow );
		this.SoundEvent("magic_geralt_invisible_loop_end");
	}
	
	timer function DelayedPrepareCombat( time : float, id : int)
	{
		thePlayer.OnEquipMeleeWeapon(PW_Steel, false);
		thePlayer.SetPlayerCombatStance( PCS_AlertNear );	
	}	
	
	timer function SpawnDoppler( time : float, id : int)
	{
		var ent : CEntity;
		var pos, cameraDir, player, posFin, normal, posTemp : Vector;
		var rot : EulerAngles;
		var s,r,x,y : float;
		var template : CEntityTemplate;
		var resourcePath	: string;
		var npc : CNewNPC;
		var inv : CInventoryComponent;
		var witcher : W3PlayerWitcher;
		var item : SItemUniqueId;
		var ids : array<SItemUniqueId>;
		var k : int;
		var size : int;	
		var acs : array< CComponent >;
		var head : name;
		var aname,pname,bname,gname : name;
		var defau,black,blue,brown,gray,green,orange,pink,purple,red,silver,white,yellow : array<SItemUniqueId>;
		var ename : array< name >;
		var enchq : int;
		var runame : array< SItemUniqueId>;
		var abs : array<name>;
		var absize : int;
		
		rot = thePlayer.GetWorldRotation();	
		rot.Yaw += 180;		
		
		
		cameraDir = theCamera.GetCameraDirection();
		 
		cameraDir.X *= 3;	
		cameraDir.Y *= 3;
		
		
		player = this.GetWorldPosition();
		
		
		pos = player + VecRingRand(1,3);	
		pos.Z = player.Z;
		
		posFin.Z = pos.Z;			
		
		
		template = (CEntityTemplate)LoadResource("dlc\devilspit\data\quests\secondary_npcs\doppler.w2ent",true);
			
		ent = theGame.CreateEntity(template, pos, rot);
		
		GetComponentByClassName('CInteractionComponent').SetEnabled( true );
		
		thePlayer.GetCharacterStats().GetAbilities(abs, true);
		
		for( absize = 0; absize < abs.Size(); absize+=1 )
		{
//			((CGameplayEntity)ent).AddAbility(abs[absize],false);
		}
		
		((CNewNPC)ent).AddTag('DPDOPPLER');
		((CNewNPC)ent).AddTag('Quest');		
	}
	
}