/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class W3DPExitStone extends CInteractiveEntity
{
	saved var willmalfunction : bool; default willmalfunction = false;
	
	event OnSpawned(spawnData : SEntitySpawnData )
	{
		if(willmalfunction)
		{
			this.PlayEffect('invisible');
		}
	}
	
	event OnInteraction( actionName : string, activator : CEntity )
	{
		thePlayer.PlayerStartAction( PEA_InspectMid );
		AddTimer( 'FadeOut', 4.3, false );
		AddTimer( 'DelayedExit', 4.5, false );
		GetComponentByClassName('CInteractionComponent').SetEnabled( false );
	}	
	
	event OnAardHit( sign : W3AardProjectile )
	{
		willmalfunction = true;
		this.PlayEffect('invisible');
	}
	
	event OnIgniHit( sign : W3IgniProjectile )
	{
		if(!willmalfunction)
		{
			this.PlayEffect('charged_igni');
			AddTimer( 'Explosion', 4.5, false );
			GetComponentByClassName('CInteractionComponent').SetEnabled( false );
		}
	}	
	
	timer function FadeOut( time : float, id : int)
	{
		theGame.ResetFadeLock( "exe_func_fadeout" );
		if(willmalfunction)
		{
			theGame.FadeOutAsync(0.15,Color(255,255,255));		
		}
		else
		{
			theGame.FadeOutAsync(0.15);
		}
	}	
	
	timer function DelayedExit( time : float, id : int)
	{
		thePlayer.PlayEffect('teleport_out');
		thePlayer.PlayerStopAction( PEA_InspectMid );
		if(willmalfunction)
		{
			thePlayer.Teleport( Vector(1137.383, 600.740, 37.180) );
			RemoveArmor();			
			this.StopEffect('invisible');
			willmalfunction = false;
			thePlayer.PlayerStartAction( 1,'man_geralt_sword_tornado_right' );
		}
		else
		{
			thePlayer.Teleport( Vector(1137.383, 600.740, 37.180) );		
		}
		
		GetComponentByClassName('CInteractionComponent').SetEnabled( true );
		theGame.ResetFadeLock( "exe_func_fadein" );
		theGame.FadeInAsync( 3.5f );		
		
		thePlayer.PlayEffect('teleport_in');
	}
	
	function RemoveArmor()
	{
		var inv : CInventoryComponent;
		var ids 		: array<SItemUniqueId>;
		var id			: SItemUniqueId;
		var i			: int;
		
		inv = thePlayer.GetInventory();
		
		if ( inv.GetItemEquippedOnSlot( EES_SilverSword, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_SteelSword, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_Armor, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_Boots, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_Pants, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_Gloves, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_RangedWeapon, id ) )
			ids.PushBack(id);
		if ( inv.GetItemEquippedOnSlot( EES_Quickslot1, id ) )
			ids.PushBack(id);		
		if ( inv.GetItemEquippedOnSlot( EES_Quickslot2, id ) )
			ids.PushBack(id);				
		if ( inv.GetItemEquippedOnSlot( EES_Petard1, id ) )
			ids.PushBack(id);		
		if ( inv.GetItemEquippedOnSlot(EES_Petard2, id ) )
			ids.PushBack(id);				
		if ( inv.GetItemEquippedOnSlot( EES_Potion1, id ) )
			ids.PushBack(id);		
		if ( inv.GetItemEquippedOnSlot( EES_Potion2, id ) )
			ids.PushBack(id);				
		if ( inv.GetItemEquippedOnSlot( EES_Potion3, id ) )
			ids.PushBack(id);		
		if ( inv.GetItemEquippedOnSlot(EES_Potion4, id ) )
			ids.PushBack(id);	
		if ( inv.GetItemEquippedOnSlot( EES_Mask, id ) )
			ids.PushBack(id);		
		if ( inv.GetItemEquippedOnSlot(EES_Bolt, id ) )
			ids.PushBack(id);				
			
		for ( i=0 ; i < ids.Size() ; i+=1 )
			GetWitcherPlayer().UnequipItem(ids[i]);
	}

	timer function Explosion( deltaTime : float, optional id : int)
	{
		var damage : W3DamageAction;
		var entitiesInRange : array< CGameplayEntity >;
		var i : int;
		var targetEntity : CActor;
	
			
		StopAllEffects();
		this.PlayEffect('explosion');
		GCameraShake( 1.5, true, GetWorldPosition(), 20.0f );
		
		
		if ( thePlayer.IsCameraLockedToTarget() && thePlayer.GetDisplayTarget() == this )
		{
			thePlayer.OnForceSelectLockTarget();
		}
		
		FindGameplayEntitiesInSphere(entitiesInRange, this.GetWorldPosition(), 8, 1000);		
		entitiesInRange.Remove(this);
		for( i = 0; i < entitiesInRange.Size(); i += 1 )
		{
			targetEntity = (CActor)entitiesInRange[i];
			if(targetEntity)
			{
				damage = new W3DamageAction in this;
				
				damage.Initialize( this, entitiesInRange[i], NULL, this, EHRT_None, CPS_Undefined, false, false, false, true );
				if ( targetEntity == GetWitcherPlayer() )
					damage.AddDamage( theGame.params.DAMAGE_NAME_FIRE, 15 * (int)GetWitcherPlayer().GetLevel() );
				else
					damage.AddDamage( theGame.params.DAMAGE_NAME_FIRE, 15 * (int)CalculateAttributeValue(targetEntity.GetAttributeValue('level',,true)) );
				damage.AddEffectInfo(EET_Burning);
				damage.AddEffectInfo(EET_KnockdownTypeApplicator);
				damage.SetProcessBuffsIfNoDamage(true);
				theGame.damageMgr.ProcessAction( damage );
				
				delete damage;
			}
			else
			{
				entitiesInRange[i].OnFireHit(this);
			}
		}
		GetComponentByClassName('CInteractionComponent').SetEnabled( true );
	}	
	
}