/***********************************************************************/
/** 	 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class W3InvisibilityCharm extends W3UsableItem
{
var alreadyusedhack : bool;	default alreadyusedhack = false;

	event OnUsed( usedBy : CEntity )
	{
		if( thePlayer.IsInCombat() && FactsQuerySum("DPPlayerInvisible") == 0 )
		{	
			SoundEvent("gui_no_stamina");
		}
		
		if( !thePlayer.IsInCombat() && FactsQuerySum("DPPlayerInvisible") == 0 )
		{
			thePlayer.PlayEffectSingle('invisible');
			thePlayer.SetTemporaryAttitudeGroup('neutral_to_player',2);
			thePlayer.BlockAction( EIAB_RunAndSprint, 'DPInvisibility', true );
			theGame.GetBehTreeReactionManager().InitReactionScene( thePlayer, 'Scared', 5.0, 10.0f, 1000.0f, 10 );
			fear();
			FactsSet("DPPlayerInvisible", 1);
			alreadyusedhack = true;
		}
		
		if( FactsQuerySum("DPPlayerInvisible") == 1 && alreadyusedhack == false )
		{
			FactsSet("DPPlayerInvisible", 0);
			thePlayer.ResetTemporaryAttitudeGroup(2);
			thePlayer.UnblockAction( EIAB_RunAndSprint, 'DPInvisibility');
			thePlayer.StopEffect('invisible');
			fear();
		}
		
		super.OnUsed(usedBy);
	}
	
	function fear()
	{
		var i : int;
		var actors : array< CActor >;
		
		actors = GetActorsInRange( thePlayer, 10,,,true);
		
		for(i = actors.Size() - 1; i >= 0; i -= 1)
		{
			actors[i].DrainMorale(100);
		}	
	}

}