/***********************************************************************/
/** 	 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class W3PlayerTrap extends W3TrapTripwire
{
	var isspring : bool;	default isspring = false;
	var springer	: CNode;
	var haschained : bool;	default haschained = false;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		super.OnSpawned(spawnData);
		AddTimer( 'FinishSetup', 1.5, false );
		
		if(GetReadableName() == "dlc\devilspit\data\items\weapons\traps\tripwire.w2ent")
			isspring = true;
	}
	
	timer function FinishSetup( deltaTime : float, id : int )
	{
		thePlayer.SoundEvent("qu_item_disarm_trap");
		thePlayer.PlayerStopAction( PEA_InspectLow );
	}
	
	private function ShouldExcludeActor( _Actor : CActor ) : bool
	{	
		if( _Actor == thePlayer || GetAttitudeBetween( thePlayer, _Actor ) != AIA_Hostile )
		{
			return true;
		}
		return false;
	}	
	
	function SpringTripwire(_Target : CNode)
	{
		var disarmComp : CComponent;
		
		super.SpringTripwire(_Target);
		
		springer = _Target;
		
		if(isspring)
		{
			this.PlayEffectSingle('explosion');
			SoundEvent("bomb_shrapnel_explo");
			DealDamage();
			ChainReaction();
			DestroyAfter(1);
		}
		else
		{
			((CActor)springer).SoundEvent("cmb_play_hit_heavy");
			DealDamageBear();
			disarmComp = GetComponent( DISARM_INTERACTION_COMPONENT_NAME );
			disarmComp.SetEnabled( true );
		}
	}
	
	function GetChainedStatus() : bool
	{
		return haschained;
	}
	
	function SetChainedStatus()
	{
		haschained = true;
	}
	
	function externalspringer(pass : CNode)
	{
		springer = pass;
	}
	
	timer function DelayedTrigger( deltaTime : float, id : int )
	{
		SpringTripwire(springer);
	}
	
	function ChainReaction()
	{
		var ents : array<CEntity>;
		var i : int;
		var distanceToTarget : float;
		
		theGame.GetEntitiesByTag('DPPLAYERTRAP', ents);
		
		for(i=0; i<ents.Size(); i+=1)
		{
			distanceToTarget = VecDistance( this.GetWorldPosition(), ents[i].GetWorldPosition() );
			
			if(distanceToTarget < 6 && !((W3PlayerTrap)ents[i]).haschained)
			{
				((W3PlayerTrap)ents[i]).SetChainedStatus();
				((W3PlayerTrap)ents[i]).externalspringer(springer);
				((W3PlayerTrap)ents[i]).AddTimer( 'DelayedTrigger', distanceToTarget / 10, false );
			}
		}		
	}	
	
	event OnInteraction( actionName : string, activator : CEntity )
	{
		if ( actionName == "Disarm" )
		{
			AddTimer( 'FinishDisarm', 2.5, false );
			DestroyAfter(3);
		}
		super.OnInteraction(actionName,activator);
	}
	
	timer function FinishDisarm( deltaTime : float, id : int )
	{
		if(isspring)
		{
			thePlayer.inv.AddAnItem('SpringTrap');
		}
		else
		{
			thePlayer.inv.AddAnItem('BearTrap');		
		}
		
		thePlayer.SoundEvent("qu_item_disarm_trap");
		thePlayer.PlayerStopAction( PEA_InspectLow );
	}		

	function DealDamage()
	{
		var actors : array< CActor >;
		var i	   : int;
		var act	   : W3DamageAction;
		var distanceToTarget : float;
		
		actors = GetActorsInRange( this, 8, 50, '', true );
		
		for(i = actors.Size() - 1; i >= 0; i -= 1)
		{
			if( GetAttitudeBetween( thePlayer, actors[i] ) == AIA_Hostile && actors[i] != thePlayer )
			{
				distanceToTarget = VecDistance( this.GetWorldPosition(), actors[i].GetWorldPosition() );
				act = new W3DamageAction in this;
				act.Initialize(thePlayer, actors[i], this, "Trap", EHRT_Heavy, CPS_Undefined, false, false, false, true );
				act.SetForceExplosionDismemberment();
				act.AddDamage(theGame.params.DAMAGE_NAME_FIRE, (GetWitcherPlayer().GetLevel() * 5 ) * (distanceToTarget / 8) );
				act.AddDamage(theGame.params.DAMAGE_NAME_FORCE, (GetWitcherPlayer().GetLevel() * 5) * (distanceToTarget / 8) );
				act.AddDamage(theGame.params.DAMAGE_NAME_PHYSICAL, (GetWitcherPlayer().GetLevel() * 10) * (distanceToTarget / 8) );
				act.AddEffectInfo(EET_Burning,4.0 , , , , 0.8f);
				theGame.damageMgr.ProcessAction(act);
				delete act;				
			}
		}
		
		actors = GetActorsInRange( this, 20, 50, '', true );
		for(i = actors.Size() - 1; i >= 0; i -= 1)
		{
			((CNewNPC)actors[i]).SignalGameplayEventParamObject('BombExplosionAction', this);
			theGame.GetBehTreeReactionManager().CreateReactionEventIfPossible( ((CNewNPC)actors[i]), 'BombExplosionAction', 8.0, 1.0f, 999.0f, 1, false); 			
		}
		
	}
	
	function DealDamageBear()
	{
		var act	   : W3DamageAction;
		
		if( GetAttitudeBetween( thePlayer, (CEntity)springer ) == AIA_Hostile && springer != thePlayer )
		{
			act = new W3DamageAction in this;
			act.Initialize(thePlayer, (CGameplayEntity)springer, this, "Trap", EHRT_Heavy, CPS_Undefined, true, false, false, false );
			act.AddDamage(theGame.params.DAMAGE_NAME_PHYSICAL, GetWitcherPlayer().GetLevel() * 7);
			act.AddEffectInfo(EET_Paralyzed,10.0);
			theGame.damageMgr.ProcessAction(act);
			delete act;
		}
	}	
}