/***********************************************************************/
/** 	 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class W3TrapDeployer extends W3UsableItem
{
	var ent : CEntity;
	var traptemplate : CEntityTemplate;
	var mytags : array<name>;
	var traps : array<SItemUniqueId>;
	var spawnpos : Vector;
	var headingvector : Vector;

	event OnUsed( usedBy : CEntity )
	{
		GetItemTags(mytags);
		thePlayer.PlayerStartAction( PEA_InspectLow );
		
		headingvector = thePlayer.GetHeadingVector();
		headingvector.X *= 0.8;
		headingvector.Y *= 0.8;
		spawnpos = thePlayer.GetWorldPosition() + headingvector ;
		
		if(mytags.Contains('SpringTrap'))
		{
			traptemplate = (CEntityTemplate)LoadResource("dlc\devilspit\data\items\weapons\traps\tripwire.w2ent",true);
			ent = theGame.CreateEntity(traptemplate, spawnpos, thePlayer.GetWorldRotation());
		}
		else
		{
			traptemplate = (CEntityTemplate)LoadResource("dlc\devilspit\data\items\weapons\traps\beartrap.w2ent",true);
			ent = theGame.CreateEntity(traptemplate, spawnpos, thePlayer.GetWorldRotation());		
		}
		
		removeitem();
		super.OnUsed(usedBy);
	}
	
	function removeitem()
	{ 	 
	 if(mytags.Contains('SpringTrap'))
	 {
		traps = thePlayer.inv.GetItemsByTag('SpringTrap');
		thePlayer.inv.RemoveItem(traps[0]);
	 }
	 
	 if(mytags.Contains('BearTrap'))
	 {
		traps = thePlayer.inv.GetItemsByTag('BearTrap');
		thePlayer.inv.RemoveItem(traps[0]);
	 }	 
	 
	}
}