/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

statemachine class CDPDopplerNPC extends CNewNPC
{	
	var killedbyttl : bool; default killedbyttl = false;
	var droppedpb : bool;	default droppedpb = false;
	var inv : CInventoryComponent;
	
	event OnSpawned(spawnData : SEntitySpawnData )
	{
		super.OnSpawned(spawnData);
		SoundEvent("magic_geralt_teleport");
		SoundSwitch( "entity_gender", "male" );
		SoundSwitch( "entity_name", "geralt" );
		AddTimer( 'TTL', 300, false );
		
		SetTemporaryAttitudeGroup( 'hostile_to_player', AGP_Default );
		SetUpStats();
		SetUpInventory();
	}
	
	function SetUpStats()
	{
		AddEffectDefault(EET_AutoStaminaRegen, this, 'doppler');		
		AddEffectDefault(EET_AutoMoraleRegen, this, 'doppler');	
		SetLevel(GetWitcherPlayer().GetLevel());
		SignalGameplayEventParamInt('ChangePreferedCombatStyle',(int)EBG_Combat_Witcher );
		SetPreferedCombatStyle(EBG_Combat_Witcher);
		if( FactsDoesExist("DPDOPPLERDEFEATED") )
		{
			clearInvOnDeath = true;
		}
		else
		{
			clearInvOnDeath = false;
		}
		grantNoExperienceAfterKill == true;
		AddAbility('ablComboAttacks',false);
		AddAbility('ablSignAttacks',false);
		AddAbility('IsNotScaredOfMonsters',false);
		AddAbility('ReflectOnBeingParried',false);
		AddAbility('ablParryHeavyAttacks',false);
		AddAbility('BurnIgnore',false);
		AddAbility('ablPrioritizeAvoidingHeavyAttacks',false);
		AddAbility('ablCounterHeavyAttacks',false);
		AddAbility('ablAttackKnockeddownTarget',false);
		AddAbility('DisableDismemberment',false);
		AddAbility('InstantKillImmune',false);
		AddAbility('SkillWitcher',false);
		AddAbility('MinDamage',false);
		AddAbility('MedDamage',false);
		RemoveAbilityAll('NPCLevelBonus');
		
		ForceSetStat(BCS_Vitality, thePlayer.GetStatMax(BCS_Vitality));
		ForceSetStat(BCS_Stamina, thePlayer.GetStatMax(BCS_Stamina));
		ForceSetStat(BCS_Morale, 9999);
		SetHealth(thePlayer.GetMaxHealth());	
	}

	timer function TTL( time : float, id : int)
	{
		killedbyttl = true;
		Kill('TTL');
	}	
	
	event OnDeath( damageAction : W3DamageAction  )
	{
		RemoveTimer( 'TTL' );	
		
		if(!FactsDoesExist("DPDOPPLERDEFEATED") && !killedbyttl)		
		{	
			PlayEffect('teleport_appear');
			SetVisibility(false);	
			inv = this.GetInventory();
			FactsSet("DPDOPPLERDEFEATED",1);
			clearInvOnDeath = false;		
			inv.RemoveAllItems();
			inv.AddAnItem('Plaguebearer');
			inv.ThrowAwayLootableItems( true );
			droppedpb = true;
		}		
		
		super.OnDeath(damageAction);		
		
		if(!droppedpb)
			AddTimer( 'DelayedHide', 0.7, false );
	}
	
	timer function DelayedHide( time : float, id : int)	
	{
		PlayEffect('teleport_appear');
		SetVisibility(false);
	}
	
	function SetUpInventory()
	{
		var inv : CInventoryComponent;
		var witcher : W3PlayerWitcher;
		var item : SItemUniqueId;
		var ids : array<SItemUniqueId>;
		var k : int;
		var size : int;	
		var acs : array< CComponent >;
		var head : name;
		var aname,pname,bname,gname : name;
		var defau,black,blue,brown,gray,green,orange,pink,purple,red,silver,white,yellow : array<SItemUniqueId>;
		var ename : array< name >;
		var enchq : int;
		var runame : array< SItemUniqueId>;
		var abs : array<name>;
		var absize : int;	
		
		inv = this.GetInventory();
		
		witcher = GetWitcherPlayer();
		if(witcher.GetItemEquippedOnSlot(EES_Armor, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			aname = witcher.inv.GetItemColor(item);	
			
			if(NameToString(aname) == "Dye Default")
			{
				inv.AddAnItem('Dye Default',1);
				defau = inv.GetItemsByName('Dye Default');
				inv.ColorItem(ids[0], defau[0]);
				inv.RemoveItem(defau[0]);
			}		
			
			if(NameToString(aname) == "Dye Black")
			{
				inv.AddAnItem('Dye Black',1);
				black = inv.GetItemsByName('Dye Black');
				inv.ColorItem(ids[0], black[0]);
				inv.RemoveItem(black[0]);
			}
			
			if(NameToString(aname) == "Dye Blue")
			{
				inv.AddAnItem('Dye Blue',1);
				blue = inv.GetItemsByName('Dye Blue');
				inv.ColorItem(ids[0], blue[0]);
				inv.RemoveItem(blue[0]);
			}		
			
			if(NameToString(aname) == "Dye Brown")
			{
				inv.AddAnItem('Dye Brown',1);
				brown = inv.GetItemsByName('Dye Brown');
				inv.ColorItem(ids[0], brown[0]);
				inv.RemoveItem(brown[0]);
			}

			if(NameToString(aname) == "Dye Gray")
			{
				inv.AddAnItem('Dye Gray',1);
				gray = inv.GetItemsByName('Dye Gray');
				inv.ColorItem(ids[0], gray[0]);
				inv.RemoveItem(gray[0]);
			}
			
			if(NameToString(aname) == "Dye Green")
			{
				inv.AddAnItem('Dye Green',1);
				green = inv.GetItemsByName('Dye Green');
				inv.ColorItem(ids[0], green[0]);
				inv.RemoveItem(green[0]);
			}		
			
			if(NameToString(aname) == "Dye Orange")
			{
				inv.AddAnItem('Dye Orange',1);
				orange = inv.GetItemsByName('Dye Orange');
				inv.ColorItem(ids[0], orange[0]);
				inv.RemoveItem(orange[0]);
			}	

			if(NameToString(aname) == "Dye Pink")
			{
				inv.AddAnItem('Dye Pink',1);
				pink = inv.GetItemsByName('Dye Pink');
				inv.ColorItem(ids[0], pink[0]);
				inv.RemoveItem(pink[0]);
			}		

			if(NameToString(aname) == "Dye Purple")
			{
				inv.AddAnItem('Dye Purple',1);
				purple = inv.GetItemsByName('Dye Purple');
				inv.ColorItem(ids[0], purple[0]);
				inv.RemoveItem(purple[0]);
			}		

			if(NameToString(aname) == "Dye Red")
			{
				inv.AddAnItem('Dye Red',1);
				red = inv.GetItemsByName('Dye Red');
				inv.ColorItem(ids[0], red[0]);
				inv.RemoveItem(red[0]);
			}			
			
			if(NameToString(aname) == "Dye Silver")
			{
				inv.AddAnItem('Dye Silver',1);
				silver = inv.GetItemsByName('Dye Silver');
				inv.ColorItem(ids[0], silver[0]);
				inv.RemoveItem(silver[0]);
			}

			if(NameToString(aname) == "Dye White")
			{
				inv.AddAnItem('Dye White',1);
				white = inv.GetItemsByName('Dye White');
				inv.ColorItem(ids[0], white[0]);
				inv.RemoveItem(white[0]);
			}		
			
			if(NameToString(aname) == "Dye Yellow")
			{
				inv.AddAnItem('Dye Yellow',1);
				yellow = inv.GetItemsByName('Dye Yellow');
				inv.ColorItem(ids[0], yellow[0]);
				inv.RemoveItem(yellow[0]);
			}
			
			
			ename.Clear();
			enchq = 0;
			witcher.inv.GetItemEnhancementItems(item,ename);
			if( ename.Size() > 0 )
			{
				for( enchq = 0; enchq < ename.Size(); enchq+=1 )
				{
					if(witcher.inv.GetEnchantment( item ) != '')
					{
						inv.EnchantItem( ids[0], ename[enchq], getEnchamtmentStatName(ename[enchq]) );
					}
					else
					{
						runame = inv.AddAnItem(ename[enchq]);
						inv.EnhanceItemScript( ids[0], runame[0]);
					}
				}
			}		
			
			inv.MountItem(ids[0]);	
		}
		
		defau.Clear();
		blue.Clear();
		brown.Clear();
		gray.Clear();
		green.Clear();
		orange.Clear();
		pink.Clear();
		purple.Clear();
		red.Clear();
		silver.Clear();
		white.Clear();
		yellow.Clear();
		
		if(witcher.GetItemEquippedOnSlot(EES_Boots, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			aname = witcher.inv.GetItemColor(item);	
			
			if(NameToString(aname) == "Dye Default")
			{
				inv.AddAnItem('Dye Default',1);
				defau = inv.GetItemsByName('Dye Default');
				inv.ColorItem(ids[0], defau[0]);
				inv.RemoveItem(defau[0]);
			}		
			
			if(NameToString(aname) == "Dye Black")
			{
				inv.AddAnItem('Dye Black',1);
				black = inv.GetItemsByName('Dye Black');
				inv.ColorItem(ids[0], black[0]);
				inv.RemoveItem(black[0]);
			}
			
			if(NameToString(aname) == "Dye Blue")
			{
				inv.AddAnItem('Dye Blue',1);
				blue = inv.GetItemsByName('Dye Blue');
				inv.ColorItem(ids[0], blue[0]);
				inv.RemoveItem(blue[0]);
			}		
			
			if(NameToString(aname) == "Dye Brown")
			{
				inv.AddAnItem('Dye Brown',1);
				brown = inv.GetItemsByName('Dye Brown');
				inv.ColorItem(ids[0], brown[0]);
				inv.RemoveItem(brown[0]);
			}

			if(NameToString(aname) == "Dye Gray")
			{
				inv.AddAnItem('Dye Gray',1);
				gray = inv.GetItemsByName('Dye Gray');
				inv.ColorItem(ids[0], gray[0]);
				inv.RemoveItem(gray[0]);
			}
			
			if(NameToString(aname) == "Dye Green")
			{
				inv.AddAnItem('Dye Green',1);
				green = inv.GetItemsByName('Dye Green');
				inv.ColorItem(ids[0], green[0]);
				inv.RemoveItem(green[0]);
			}		
			
			if(NameToString(aname) == "Dye Orange")
			{
				inv.AddAnItem('Dye Orange',1);
				orange = inv.GetItemsByName('Dye Orange');
				inv.ColorItem(ids[0], orange[0]);
				inv.RemoveItem(orange[0]);
			}	

			if(NameToString(aname) == "Dye Pink")
			{
				inv.AddAnItem('Dye Pink',1);
				pink = inv.GetItemsByName('Dye Pink');
				inv.ColorItem(ids[0], pink[0]);
				inv.RemoveItem(pink[0]);
			}		

			if(NameToString(aname) == "Dye Purple")
			{
				inv.AddAnItem('Dye Purple',1);
				purple = inv.GetItemsByName('Dye Purple');
				inv.ColorItem(ids[0], purple[0]);
				inv.RemoveItem(purple[0]);
			}		

			if(NameToString(aname) == "Dye Red")
			{
				inv.AddAnItem('Dye Red',1);
				red = inv.GetItemsByName('Dye Red');
				inv.ColorItem(ids[0], red[0]);
				inv.RemoveItem(red[0]);
			}			
			
			if(NameToString(aname) == "Dye Silver")
			{
				inv.AddAnItem('Dye Silver',1);
				silver = inv.GetItemsByName('Dye Silver');
				inv.ColorItem(ids[0], silver[0]);
				inv.RemoveItem(silver[0]);
			}

			if(NameToString(aname) == "Dye White")
			{
				inv.AddAnItem('Dye White',1);
				white = inv.GetItemsByName('Dye White');
				inv.ColorItem(ids[0], white[0]);
				inv.RemoveItem(white[0]);
			}		
			
			if(NameToString(aname) == "Dye Yellow")
			{
				inv.AddAnItem('Dye Yellow',1);
				yellow = inv.GetItemsByName('Dye Yellow');
				inv.ColorItem(ids[0], yellow[0]);
				inv.RemoveItem(yellow[0]);
			}
			
			ename.Clear();
			enchq = 0;		
			witcher.inv.GetItemEnhancementItems(item,ename);
			if( ename.Size() > 0 )
			{
				for( enchq = 0; enchq < ename.Size(); enchq+=1 )
				{
					if(witcher.inv.GetEnchantment( item ) != '')
					{
						inv.EnchantItem( ids[0], ename[enchq], getEnchamtmentStatName(ename[enchq]) );
					}
					else
					{
						runame = inv.AddAnItem(ename[enchq]);
						inv.EnhanceItemScript( ids[0], runame[0]);
					}
				}
			}	
			
			inv.MountItem(ids[0]);		
		}
		
		defau.Clear();
		blue.Clear();
		brown.Clear();
		gray.Clear();
		green.Clear();
		orange.Clear();
		pink.Clear();
		purple.Clear();
		red.Clear();
		silver.Clear();
		white.Clear();
		yellow.Clear();	
		
		if(witcher.GetItemEquippedOnSlot(EES_Pants, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			aname = witcher.inv.GetItemColor(item);	
			
			if(NameToString(aname) == "Dye Default")
			{
				inv.AddAnItem('Dye Default',1);
				defau = inv.GetItemsByName('Dye Default');
				inv.ColorItem(ids[0], defau[0]);
				inv.RemoveItem(defau[0]);
			}		
			
			if(NameToString(aname) == "Dye Black")
			{
				inv.AddAnItem('Dye Black',1);
				black = inv.GetItemsByName('Dye Black');
				inv.ColorItem(ids[0], black[0]);
				inv.RemoveItem(black[0]);
			}
			
			if(NameToString(aname) == "Dye Blue")
			{
				inv.AddAnItem('Dye Blue',1);
				blue = inv.GetItemsByName('Dye Blue');
				inv.ColorItem(ids[0], blue[0]);
				inv.RemoveItem(blue[0]);
			}		
			
			if(NameToString(aname) == "Dye Brown")
			{
				inv.AddAnItem('Dye Brown',1);
				brown = inv.GetItemsByName('Dye Brown');
				inv.ColorItem(ids[0], brown[0]);
				inv.RemoveItem(brown[0]);
			}

			if(NameToString(aname) == "Dye Gray")
			{
				inv.AddAnItem('Dye Gray',1);
				gray = inv.GetItemsByName('Dye Gray');
				inv.ColorItem(ids[0], gray[0]);
				inv.RemoveItem(gray[0]);
			}
			
			if(NameToString(aname) == "Dye Green")
			{
				inv.AddAnItem('Dye Green',1);
				green = inv.GetItemsByName('Dye Green');
				inv.ColorItem(ids[0], green[0]);
				inv.RemoveItem(green[0]);
			}		
			
			if(NameToString(aname) == "Dye Orange")
			{
				inv.AddAnItem('Dye Orange',1);
				orange = inv.GetItemsByName('Dye Orange');
				inv.ColorItem(ids[0], orange[0]);
				inv.RemoveItem(orange[0]);
			}	

			if(NameToString(aname) == "Dye Pink")
			{
				inv.AddAnItem('Dye Pink',1);
				pink = inv.GetItemsByName('Dye Pink');
				inv.ColorItem(ids[0], pink[0]);
				inv.RemoveItem(pink[0]);
			}		

			if(NameToString(aname) == "Dye Purple")
			{
				inv.AddAnItem('Dye Purple',1);
				purple = inv.GetItemsByName('Dye Purple');
				inv.ColorItem(ids[0], purple[0]);
				inv.RemoveItem(purple[0]);
			}		

			if(NameToString(aname) == "Dye Red")
			{
				inv.AddAnItem('Dye Red',1);
				red = inv.GetItemsByName('Dye Red');
				inv.ColorItem(ids[0], red[0]);
				inv.RemoveItem(red[0]);
			}			
			
			if(NameToString(aname) == "Dye Silver")
			{
				inv.AddAnItem('Dye Silver',1);
				silver = inv.GetItemsByName('Dye Silver');
				inv.ColorItem(ids[0], silver[0]);
				inv.RemoveItem(silver[0]);
			}

			if(NameToString(aname) == "Dye White")
			{
				inv.AddAnItem('Dye White',1);
				white = inv.GetItemsByName('Dye White');
				inv.ColorItem(ids[0], white[0]);
				inv.RemoveItem(white[0]);
			}		
			
			if(NameToString(aname) == "Dye Yellow")
			{
				inv.AddAnItem('Dye Yellow',1);
				yellow = inv.GetItemsByName('Dye Yellow');
				inv.ColorItem(ids[0], yellow[0]);
				inv.RemoveItem(yellow[0]);
			}
			
			
			ename.Clear();
			enchq = 0;		
			witcher.inv.GetItemEnhancementItems(item,ename);
			if( ename.Size() > 0 )
			{
				for( enchq = 0; enchq < ename.Size(); enchq+=1 )
				{
					if(witcher.inv.GetEnchantment( item ) != '')
					{
						inv.EnchantItem( ids[0], ename[enchq], getEnchamtmentStatName(ename[enchq]) );
					}
					else
					{
						runame = inv.AddAnItem(ename[enchq]);
						inv.EnhanceItemScript( ids[0], runame[0]);
					}
				}
			}		
			
			inv.MountItem(ids[0]);	
		}

		defau.Clear();
		blue.Clear();
		brown.Clear();
		gray.Clear();
		green.Clear();
		orange.Clear();
		pink.Clear();
		purple.Clear();
		red.Clear();
		silver.Clear();
		white.Clear();
		yellow.Clear();
		
		if(witcher.GetItemEquippedOnSlot(EES_Gloves, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			aname = witcher.inv.GetItemColor(item);	
			
			if(NameToString(aname) == "Dye Default")
			{
				inv.AddAnItem('Dye Default',1);
				defau = inv.GetItemsByName('Dye Default');
				inv.ColorItem(ids[0], defau[0]);
				inv.RemoveItem(defau[0]);
			}		
			
			if(NameToString(aname) == "Dye Black")
			{
				inv.AddAnItem('Dye Black',1);
				black = inv.GetItemsByName('Dye Black');
				inv.ColorItem(ids[0], black[0]);
				inv.RemoveItem(black[0]);
			}
			
			if(NameToString(aname) == "Dye Blue")
			{
				inv.AddAnItem('Dye Blue',1);
				blue = inv.GetItemsByName('Dye Blue');
				inv.ColorItem(ids[0], blue[0]);
				inv.RemoveItem(blue[0]);
			}		
			
			if(NameToString(aname) == "Dye Brown")
			{
				inv.AddAnItem('Dye Brown',1);
				brown = inv.GetItemsByName('Dye Brown');
				inv.ColorItem(ids[0], brown[0]);
				inv.RemoveItem(brown[0]);
			}

			if(NameToString(aname) == "Dye Gray")
			{
				inv.AddAnItem('Dye Gray',1);
				gray = inv.GetItemsByName('Dye Gray');
				inv.ColorItem(ids[0], gray[0]);
				inv.RemoveItem(gray[0]);
			}
			
			if(NameToString(aname) == "Dye Green")
			{
				inv.AddAnItem('Dye Green',1);
				green = inv.GetItemsByName('Dye Green');
				inv.ColorItem(ids[0], green[0]);
				inv.RemoveItem(green[0]);
			}		
			
			if(NameToString(aname) == "Dye Orange")
			{
				inv.AddAnItem('Dye Orange',1);
				orange = inv.GetItemsByName('Dye Orange');
				inv.ColorItem(ids[0], orange[0]);
				inv.RemoveItem(orange[0]);
			}	

			if(NameToString(aname) == "Dye Pink")
			{
				inv.AddAnItem('Dye Pink',1);
				pink = inv.GetItemsByName('Dye Pink');
				inv.ColorItem(ids[0], pink[0]);
				inv.RemoveItem(pink[0]);
			}		

			if(NameToString(aname) == "Dye Purple")
			{
				inv.AddAnItem('Dye Purple',1);
				purple = inv.GetItemsByName('Dye Purple');
				inv.ColorItem(ids[0], purple[0]);
				inv.RemoveItem(purple[0]);
			}		

			if(NameToString(aname) == "Dye Red")
			{
				inv.AddAnItem('Dye Red',1);
				red = inv.GetItemsByName('Dye Red');
				inv.ColorItem(ids[0], red[0]);
				inv.RemoveItem(red[0]);
			}			
			
			if(NameToString(aname) == "Dye Silver")
			{
				inv.AddAnItem('Dye Silver',1);
				silver = inv.GetItemsByName('Dye Silver');
				inv.ColorItem(ids[0], silver[0]);
				inv.RemoveItem(silver[0]);
			}

			if(NameToString(aname) == "Dye White")
			{
				inv.AddAnItem('Dye White',1);
				white = inv.GetItemsByName('Dye White');
				inv.ColorItem(ids[0], white[0]);
				inv.RemoveItem(white[0]);
			}		
			
			if(NameToString(aname) == "Dye Yellow")
			{
				inv.AddAnItem('Dye Yellow',1);
				yellow = inv.GetItemsByName('Dye Yellow');
				inv.ColorItem(ids[0], yellow[0]);
				inv.RemoveItem(yellow[0]);
			}
			
			
			ename.Clear();
			enchq = 0;		
			witcher.inv.GetItemEnhancementItems(item,ename);
			if( ename.Size() > 0 )
			{
				for( enchq = 0; enchq < ename.Size(); enchq+=1 )
				{
					if(witcher.inv.GetEnchantment( item ) != '')
					{
						inv.EnchantItem( ids[0], ename[enchq], getEnchamtmentStatName(ename[enchq]) );
					}
					else
					{
						runame = inv.AddAnItem(ename[enchq]);
						inv.EnhanceItemScript( ids[0], runame[0]);
					}
				}
			}	
			
			inv.MountItem(ids[0]);	
		}
		if(witcher.GetItemEquippedOnSlot(EES_RangedWeapon, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			inv.MountItem(ids[0]);
		}
		
		if(witcher.GetItemEquippedOnSlot(EES_SilverSword, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			
			
			ename.Clear();
			enchq = 0;		
			witcher.inv.GetItemEnhancementItems(item,ename);
			if( ename.Size() > 0 )
			{
				for( enchq = 0; enchq < ename.Size(); enchq+=1 )
				{
					if(witcher.inv.GetEnchantment( item ) != '')
					{
						inv.EnchantItem( ids[0], ename[enchq], getEnchamtmentStatName(ename[enchq]) );
					}
					else
					{
						runame = inv.AddAnItem(ename[enchq]);
						inv.EnhanceItemScript( ids[0], runame[0]);
					}
				}
			}	
			
			inv.MountItem(ids[0]);
		}
		
		if(witcher.GetItemEquippedOnSlot(EES_SteelSword, item))
		{
			if( !FactsDoesExist("DPDOPPLERDEFEATED") )		
			{
				ids = inv.AddAnItem('Plaguebearer');
			}
			else
			{
				ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			}
			
			ename.Clear();
			enchq = 0;		
			witcher.inv.GetItemEnhancementItems(item,ename);
			if( ename.Size() > 0 )
			{
				for( enchq = 0; enchq < ename.Size(); enchq+=1 )
				{
					if(witcher.inv.GetEnchantment( item ) != '')
					{
						inv.EnchantItem( ids[0], ename[enchq], getEnchamtmentStatName(ename[enchq]) );
					}
					else
					{
						runame = inv.AddAnItem(ename[enchq]);
						inv.EnhanceItemScript( ids[0], runame[0]);
					}
				}
			}	
			
			inv.MountItem(ids[0]);
		}
		
		if(witcher.GetItemEquippedOnSlot(EES_Quickslot1, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			aname = witcher.inv.GetItemColor(item);	
			
			if(NameToString(aname) == "Dye Default")
			{
				inv.AddAnItem('Dye Default',1);
				defau = inv.GetItemsByName('Dye Default');
				inv.ColorItem(ids[0], defau[0]);
				inv.RemoveItem(defau[0]);
			}		
			
			if(NameToString(aname) == "Dye Black")
			{
				inv.AddAnItem('Dye Black',1);
				black = inv.GetItemsByName('Dye Black');
				inv.ColorItem(ids[0], black[0]);
				inv.RemoveItem(black[0]);
			}
			
			if(NameToString(aname) == "Dye Blue")
			{
				inv.AddAnItem('Dye Blue',1);
				blue = inv.GetItemsByName('Dye Blue');
				inv.ColorItem(ids[0], blue[0]);
				inv.RemoveItem(blue[0]);
			}		
			
			if(NameToString(aname) == "Dye Brown")
			{
				inv.AddAnItem('Dye Brown',1);
				brown = inv.GetItemsByName('Dye Brown');
				inv.ColorItem(ids[0], brown[0]);
				inv.RemoveItem(brown[0]);
			}

			if(NameToString(aname) == "Dye Gray")
			{
				inv.AddAnItem('Dye Gray',1);
				gray = inv.GetItemsByName('Dye Gray');
				inv.ColorItem(ids[0], gray[0]);
				inv.RemoveItem(gray[0]);
			}
			
			if(NameToString(aname) == "Dye Green")
			{
				inv.AddAnItem('Dye Green',1);
				green = inv.GetItemsByName('Dye Green');
				inv.ColorItem(ids[0], green[0]);
				inv.RemoveItem(green[0]);
			}		
			
			if(NameToString(aname) == "Dye Orange")
			{
				inv.AddAnItem('Dye Orange',1);
				orange = inv.GetItemsByName('Dye Orange');
				inv.ColorItem(ids[0], orange[0]);
				inv.RemoveItem(orange[0]);
			}	

			if(NameToString(aname) == "Dye Pink")
			{
				inv.AddAnItem('Dye Pink',1);
				pink = inv.GetItemsByName('Dye Pink');
				inv.ColorItem(ids[0], pink[0]);
				inv.RemoveItem(pink[0]);
			}		

			if(NameToString(aname) == "Dye Purple")
			{
				inv.AddAnItem('Dye Purple',1);
				purple = inv.GetItemsByName('Dye Purple');
				inv.ColorItem(ids[0], purple[0]);
				inv.RemoveItem(purple[0]);
			}		

			if(NameToString(aname) == "Dye Red")
			{
				inv.AddAnItem('Dye Red',1);
				red = inv.GetItemsByName('Dye Red');
				inv.ColorItem(ids[0], red[0]);
				inv.RemoveItem(red[0]);
			}			
			
			if(NameToString(aname) == "Dye Silver")
			{
				inv.AddAnItem('Dye Silver',1);
				silver = inv.GetItemsByName('Dye Silver');
				inv.ColorItem(ids[0], silver[0]);
				inv.RemoveItem(silver[0]);
			}

			if(NameToString(aname) == "Dye White")
			{
				inv.AddAnItem('Dye White',1);
				white = inv.GetItemsByName('Dye White');
				inv.ColorItem(ids[0], white[0]);
				inv.RemoveItem(white[0]);
			}		
			
			if(NameToString(aname) == "Dye Yellow")
			{
				inv.AddAnItem('Dye Yellow',1);
				yellow = inv.GetItemsByName('Dye Yellow');
				inv.ColorItem(ids[0], yellow[0]);
				inv.RemoveItem(yellow[0]);
			}
			
			if(witcher.inv.GetItemName(item) == 'Torch')
			{
				ids = inv.AddAnItem('Torch_work');
//				((CActor)ent).EquipItem(ids[0],,true);
			}
			else
			
			{
			inv.MountItem(ids[0]);
			}
		}	
		
		if(witcher.GetItemEquippedOnSlot(EES_Quickslot2, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));	
			aname = witcher.inv.GetItemColor(item);	
			
			if(NameToString(aname) == "Dye Default")
			{
				inv.AddAnItem('Dye Default',1);
				defau = inv.GetItemsByName('Dye Default');
				inv.ColorItem(ids[0], defau[0]);
				inv.RemoveItem(defau[0]);
			}		
			
			if(NameToString(aname) == "Dye Black")
			{
				inv.AddAnItem('Dye Black',1);
				black = inv.GetItemsByName('Dye Black');
				inv.ColorItem(ids[0], black[0]);
				inv.RemoveItem(black[0]);
			}
			
			if(NameToString(aname) == "Dye Blue")
			{
				inv.AddAnItem('Dye Blue',1);
				blue = inv.GetItemsByName('Dye Blue');
				inv.ColorItem(ids[0], blue[0]);
				inv.RemoveItem(blue[0]);
			}		
			
			if(NameToString(aname) == "Dye Brown")
			{
				inv.AddAnItem('Dye Brown',1);
				brown = inv.GetItemsByName('Dye Brown');
				inv.ColorItem(ids[0], brown[0]);
				inv.RemoveItem(brown[0]);
			}

			if(NameToString(aname) == "Dye Gray")
			{
				inv.AddAnItem('Dye Gray',1);
				gray = inv.GetItemsByName('Dye Gray');
				inv.ColorItem(ids[0], gray[0]);
				inv.RemoveItem(gray[0]);
			}
			
			if(NameToString(aname) == "Dye Green")
			{
				inv.AddAnItem('Dye Green',1);
				green = inv.GetItemsByName('Dye Green');
				inv.ColorItem(ids[0], green[0]);
				inv.RemoveItem(green[0]);
			}		
			
			if(NameToString(aname) == "Dye Orange")
			{
				inv.AddAnItem('Dye Orange',1);
				orange = inv.GetItemsByName('Dye Orange');
				inv.ColorItem(ids[0], orange[0]);
				inv.RemoveItem(orange[0]);
			}	

			if(NameToString(aname) == "Dye Pink")
			{
				inv.AddAnItem('Dye Pink',1);
				pink = inv.GetItemsByName('Dye Pink');
				inv.ColorItem(ids[0], pink[0]);
				inv.RemoveItem(pink[0]);
			}		

			if(NameToString(aname) == "Dye Purple")
			{
				inv.AddAnItem('Dye Purple',1);
				purple = inv.GetItemsByName('Dye Purple');
				inv.ColorItem(ids[0], purple[0]);
				inv.RemoveItem(purple[0]);
			}		

			if(NameToString(aname) == "Dye Red")
			{
				inv.AddAnItem('Dye Red',1);
				red = inv.GetItemsByName('Dye Red');
				inv.ColorItem(ids[0], red[0]);
				inv.RemoveItem(red[0]);
			}			
			
			if(NameToString(aname) == "Dye Silver")
			{
				inv.AddAnItem('Dye Silver',1);
				silver = inv.GetItemsByName('Dye Silver');
				inv.ColorItem(ids[0], silver[0]);
				inv.RemoveItem(silver[0]);
			}

			if(NameToString(aname) == "Dye White")
			{
				inv.AddAnItem('Dye White',1);
				white = inv.GetItemsByName('Dye White');
				inv.ColorItem(ids[0], white[0]);
				inv.RemoveItem(white[0]);
			}		
			
			if(NameToString(aname) == "Dye Yellow")
			{
				inv.AddAnItem('Dye Yellow',1);
				yellow = inv.GetItemsByName('Dye Yellow');
				inv.ColorItem(ids[0], yellow[0]);
				inv.RemoveItem(yellow[0]);
			}
			
			if(witcher.inv.GetItemName(item) == 'Torch')
			{
				ids = inv.AddAnItem('Torch_work');
//				((CActor)ent).EquipItem(ids[0],,true);		
			}
			else
			{
			inv.MountItem(ids[0]);
			}
		}
		
		if(witcher.GetItemEquippedOnSlot(EES_Bolt, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			inv.MountItem(ids[0]);
		}	

		if(witcher.GetItemEquippedOnSlot(EES_Petard1, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			inv.MountItem(ids[0]);
		}

		if(witcher.GetItemEquippedOnSlot(EES_Petard2, item))
		{
			ids = inv.AddAnItem(witcher.inv.GetItemName(item));
			inv.MountItem(ids[0]);
		}	
		
		ids = witcher.inv.GetItemsByCategory( 'steel_scabbards' );
		size = ids.Size();
		if(size > 0 )
		{
			for(k=0; k < size; k+=1 )
			{
				if( witcher.inv.IsItemMounted( ids[k] ) )
				{
					ids = inv.AddAnItem(witcher.inv.GetItemName(ids[k]));
					inv.MountItem(ids[0]);
				}
			}
		}
			
		ids = witcher.inv.GetItemsByCategory( 'silver_scabbards' );
		size = ids.Size();
		if(size > 0 )
		{
			for(k=0; k < size; k+=1 )
			{
				if( witcher.inv.IsItemMounted( ids[k] ) )
				{
					ids = inv.AddAnItem(witcher.inv.GetItemName(ids[k]));
					inv.MountItem(ids[0]);
				}
			}
		}	

		acs = thePlayer.GetComponentsByClassName( 'CHeadManagerComponent' );
		head = ( ( CHeadManagerComponent ) acs[0] ).GetCurHeadName();	
			
		ids = inv.AddAnItem( head );
		inv.MountItem(ids[0]);
			
		ids = witcher.inv.GetItemsByCategory( 'hair' );
		size = ids.Size();
		if(size > 0 )
		{
			for(k=0; k < size; k+=1 )
			{
				if(witcher.inv.GetItemName(ids[k]) != 'Preview Hair' && witcher.inv.IsItemMounted( ids[k] ) )
				{
					ids = inv.AddAnItem(witcher.inv.GetItemName(ids[k]));
					inv.MountItem(ids[0]);
				}
			}
		}		
	}	
	
}