/***********************************************************************/
/** 	 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

class CPlagueRotfiend extends CNewNPC
{
	var l_aiTree		: CAIFollowSideBySideAction;
	var AIBID			: int;
	var tminus			: int;	default tminus = 33;
	var onelinerid		: int;

	event OnSpawned( spawnData : SEntitySpawnData )
	{		
		super.OnSpawned( spawnData );
		
		SetLevel( Clamp(GetWitcherPlayer().GetLevel() - RandRange(10,3), 1, GetWitcherPlayer().GetLevel() ) );
		SetTemporaryAttitudeGroup( 'player', AGP_Default );
		AddTag( 'PLAGUESLAVE' );
		SoundEvent("monster_rotfiend_vo_growl");
	
		l_aiTree = new CAIFollowSideBySideAction in this;
		l_aiTree.OnCreated();
		l_aiTree.params.targetTag = 'PLAYER';
		AIBID = ForceAIBehavior( l_aiTree, BTAP_Emergency );	
		
		AddTimer('DelayedDeath', 35.0f, false );
		AddTimer('UpdateOneliner', 1.0f, true );
		AddTimer('StopFollowing', 32.0f, false );
	}
	
	timer function UpdateOneliner(dt : float, id : int)
	{
		var line : String;
		var hud : CR4ScriptedHud;
		var module : CR4HudModuleOneliners;
		
		line = IntToString(tminus);

		hud = (CR4ScriptedHud)theGame.GetHud();
		module = (CR4HudModuleOneliners)hud.GetHudModule("OnelinersModule");
		module.OnRemoveOneliner( onelinerid );
		onelinerid = RandRange(100000,10000);
		module.OnCreateOneliner( this, tminus, onelinerid );
		tminus -= 1;
	}
	
	timer function StopFollowing(dt : float, id : int)
	{
		CancelAIBehavior(AIBID);
		SoundEvent("monster_rotfiend_uw_dive_short");
	}
	
	timer function DelayedDeath(dt : float, id : int)
	{
		var hud : CR4ScriptedHud;
		var module : CR4HudModuleOneliners;		
	
		RemoveTimer( 'UpdateOneliner' );
		hud = (CR4ScriptedHud)theGame.GetHud();
		module = (CR4HudModuleOneliners)hud.GetHudModule("OnelinersModule");
		module.OnRemoveOneliner( onelinerid );
	
		SoundEvent("monster_rotfiend_vo_scream");
		Kill( 'Timeout' );		
		ResetTemporaryAttitudeGroup( 0 );
	}	
}