/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

statemachine class CSaskiaNPC extends CNewNPC
{
	var facefix							: CStoryScene;
	
	event OnSpawned(spawnData : SEntitySpawnData )
	{
		super.OnSpawned(spawnData);	
		GetComponentByClassName( 'CInteractionComponent' ).SetEnabled( false );
		((CAnimatedComponent)GetComponentByClassName( 'CAnimatedComponent' )).PlaySkeletalAnimationAsync( 'man_work_sleep_ground_loop_1', true );
		
		AddTag('facefixtag');
		facefix = (CStoryScene)LoadResource( "dlc\devilspit\data\quests\facefix.w2scene", true);
		theGame.GetStorySceneSystem().PlayScene(facefix, "greeting_geralt");
		RemoveTag('facefixtag');
		
		AddTimer( 'LoopSleep', 1, false );		
	}
	
	timer function FirstSleep( time : float, id : int)
	{
		PlayMimicAnimationAsync('sleeping_anim_combined_face');
		AddTimer( 'LoopSleep', 20, true );
	}		

	timer function LoopSleep( time : float, id : int)
	{
		PlayMimicAnimationAsync('sleeping_anim_combined_face');
	}	
	
}