/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/

statemachine class CVictoriaNPC extends CNewNPC
{
	var inv : CInventoryComponent;
	var playerinv : CInventoryComponent;
	var ownershipcontract : array<SItemUniqueId>;
	var followingplayer : bool; default followingplayer = false;
	var l_aiTree	: CAISyannaCompanionBehavior;
	var AIBInt	: int;
	var WUBInt	: int;
	var movecomp : CMovingAgentComponent;
	var hud : CR4ScriptedHud;
	var knives : array<SItemUniqueId>;
	var torches : array<SItemUniqueId>;
	var usingtorch : bool; default usingtorch = false;
	var recentlydied : bool; default recentlydied = false;
	var safespot : Vector;
	var safespotresult : bool; default safespotresult = false;
	var ishooded : bool; default ishooded = false;
	var recentlychangedclothes : bool; default recentlychangedclothes = false;
	var PStash	: CInventoryComponent;
	var playerinfistfight : bool; default playerinfistfight = false;

	event OnSpawned(spawnData : SEntitySpawnData )
	{
		super.OnSpawned(spawnData);
		AddTimer('SetVictoriaProperties', 1.0, false);
		isImmortal = false;
	}
	
	public function WillBeUnconscious() : bool
	{
		return true;
	}
	
	public function SetHooded(val : bool)
	{
		ishooded = val;
	}
	
	public function SetRecentlyChanged(val : bool)
	{
		recentlychangedclothes = val;
		RemoveTimer( 'ResetClothesChange' );
		AddTimer('ResetClothesChange', 2.0, false);
	}
	
	timer function ResetClothesChange(dt : float, id : int)
	{
		recentlychangedclothes = false;
	}
	
	event OnProcessActionPost(action : W3DamageAction)
	{
		var actorVictim : CActor;
		var victinv : CInventoryComponent;
		var victitems : array< SItemUniqueId >;
		var i : int;
	
		super.OnProcessActionPost(action);
		
		actorVictim = (CActor)action.victim;
		
		if( !actorVictim.IsAlive() && !actorVictim.HasTag('vip') && !actorVictim.HasTag('Quest') && !actorVictim.HasTag('quest') && actorVictim != thePlayer && action.IsActionMelee() )
		{
			victinv = actorVictim.GetInventory();
			victinv.UpdateLoot();
			victinv.GetAllItems(victitems);
			for( i = 0; i < victitems.Size(); i += 1)
			{
				if( !victinv.ItemHasTag(victitems[i], 'Quest') && !victinv.ItemHasTag(victitems[i], 'NoShow') && !victinv.ItemHasTag(victitems[i], 'NoDrop') && !victinv.ItemHasTag(victitems[i], 'Body') && !victinv.ItemHasTag(victitems[i], 'quest') )
				{
					if( victinv.GetItemName(victitems[i]) == 'Crowns' )
					{
						victinv.GiveItemTo(thePlayer.inv, victitems[i], victinv.GetItemQuantity(victitems[i]) / 2, false, true, false);
					}
					else
					{
						victinv.GiveItemTo(GetWitcherPlayer().GetHorseManager().GetInventoryComponent(), victitems[i], victinv.GetItemQuantity(victitems[i]), false, true, false);
					}
				}			
			}
		}
	}
	
	event OnDeath( damageAction : W3DamageAction  )
	{		
		super.OnDeath(damageAction);
		((CActor)this).CancelAIBehavior(AIBInt);
		recentlydied = true;
		if(FactsDoesExist("VICTORIASPARING"))
		{
			if( damageAction.IsActionMelee() && damageAction.attacker == thePlayer )
			{
				theGame.GetSyncAnimManager().SetupSimpleSyncAnim2('HumanComboFinisher', thePlayer, this  );	
			}
			
			this.SoundEvent("grunt_vo_test_falling_scream_AdultFemale", 'head');
			AddTimer('VictoriaStopSpar', 3.5, false);
			((CGameplayEntity)this).SetFocusModeVisibility(FMV_Interactive, 1);		
			FactsRemove("VICTORIASPARING");
			EnableCharacterCollisions( true );
			this.AddAbility('Ciri_CombatRegen');
		}
		else
		{
			AddTimer('WakeUp', 3.5, true);
		}
	}

	timer function RestartFollowing(dt : float, id : int)
	{
		((CActor)this).CancelAIBehavior(WUBInt);
		l_aiTree = new CAISyannaCompanionBehavior  in ((CActor)this);
		l_aiTree.OnCreated();
		l_aiTree.params.moveType = MT_Sprint;
		l_aiTree.params.animName_1_start = 'stand_mw_music_flute_start';
		l_aiTree.params.animName_1_loop = 'stand_mw_music_flute_jt_loop_01';
		l_aiTree.params.animName_1_stop = 'stand_mw_music_flute_stop';
		l_aiTree.params.animName_2_start = 'stand_mw_training_sword_jt_start';
		l_aiTree.params.animName_2_loop = 'stand_mw_training_sword_jt_loop_01';
		l_aiTree.params.animName_2_stop = 'stand_mw_training_sword_jt_stop';
		l_aiTree.params.animName_3_start = 'stand_mw_training_sword_jt_start';
		l_aiTree.params.animName_3_loop = 'stand_mw_training_sword_jt_loop_02';
		l_aiTree.params.animName_3_stop = 'stand_mw_training_sword_jt_stop';
		l_aiTree.params.animName_4_start = 'woman_crouch_start';
		l_aiTree.params.animName_4_loop = 'woman_crouch_loop_1';
		l_aiTree.params.animName_4_stop = 'woman_crouch_stop';
		AIBInt = ((CActor)this).ForceAIBehavior( l_aiTree, BTAP_Idle );			
		recentlydied = false;
		GetComponentByClassName('CInteractionComponent').SetEnabled( true );
	}
	
	timer function WakeUp(dt : float, id : int)
	{
		if( !thePlayer.IsInCombat() )
		{
			SignalGameplayEvent('ForceStopUnconscious');
			GetComponentByClassName('CInteractionComponent').SetEnabled( false );
			PlayWakeupAnim();
			hud.HideOneliner( this );
			hud.ShowOneliner( "That didn't go too well...", this );
			AddTimer('delayedhideoneliner', 3, false);
			RemoveTimer( 'WakeUp' );
			AddTimer('RestartFollowing', 14.43333, false);
		}
	}
	
	event OnPreAttackEvent(animEventName : name, animEventType : EAnimationEventType, data : CPreAttackEventData, animInfo : SAnimationEventAnimInfo )
	{
		super.OnPreAttackEvent(animEventName, animEventType, data, animInfo);
		EnableCharacterCollisions( true );
	}
	
	event OnHolsteredItem( category : name, slotName : name )
	{
		super.OnHolsteredItem(category, slotName);
		
		if ( slotName == 'r_weapon' )
		{
			EnableCharacterCollisions( true );
		}
	}
	
	timer function VictoriaStopSpar(dt : float, id : int)
	{
		SetTemporaryAttitudeGroup( 'player', AGP_Default );
		PlayWakeupAnim();
		SignalGameplayEvent('ForceStopUnconscious');
		GetComponentByClassName('CInteractionComponent').SetEnabled( false );
		thePlayer.SetImmortalityMode( AIM_None, AIC_Combat );
		thePlayer.SetImmortalityMode(AIM_None,AIC_Default);
		hud.HideOneliner( this );
		hud.ShowOneliner( "That was a good fight!", this );
		EnableCharacterCollisions( true );
		AddTimer('delayedhideoneliner', 4, false);
		AddTimer('RestartFollowing', 14.43333, false);
	}
	
	function tauntplayer()
	{
		hud.HideOneliner( this );
		hud.ShowOneliner( "I expected more!", this );
		AddTimer('delayedhideoneliner', 11, false);
	}
	
	timer function delayedhideoneliner(dt : float, id : int)
	{
		hud.HideOneliner( this );
	}
	
	timer function ManageCompanionSpeed(dt : float, id : int)
	{
		var distance : float;
		var movespeed : float;
		var npcactor : CActor;
		
		npcactor = ((CActor)this);
		distance = VecDistanceSquared(npcactor.GetWorldPosition(), thePlayer.GetWorldPosition());

		if(((CActor)this).IsInCombat())
		{
			movespeed = 0.0;
			movecomp = this.GetMovingAgentComponent();
			movecomp.SetGameplayRelativeMoveSpeed(movespeed);
		}
		else
		{
			if( distance < 25 )
			{
				movespeed = 0.0;
			}
			else
			{
				movespeed = MinF((distance - 25) / 100, 1.0) * 10.0;
			}
			movecomp = this.GetMovingAgentComponent();
			movecomp.SetGameplayRelativeMoveSpeed(movespeed);
		}
		
		if( GetBehaviorVariable('EquippedItemL') == (int) LIT_Torch )
		{
			usingtorch = true;
		}
		else
		{
			usingtorch = false;
		}
		
		if( GetWitcherPlayer().IsInDarkPlace() && !usingtorch && !IsInCombat() || theGame.envMgr.IsNight() && !usingtorch && !IsInCombat() && !thePlayer.IsInInterior() )
		{
			EquipItem(torches[0],,true);
			SetBehaviorVariable( 'EquippedItemL', (int) LIT_Torch );
		}
		
		if( !GetWitcherPlayer().IsInDarkPlace() && usingtorch && !theGame.envMgr.IsNight() || IsInCombat() || theGame.IsDialogOrCutscenePlaying() || !IsAlive() || recentlydied )
		{
			UnequipItem(torches[0]);
			SetBehaviorVariable( 'EquippedItemL', (int) LIT_None );
		}
		
		if( WillItRain() && !IsInInterior() && !ishooded && IsAlive() && !recentlydied && !IsInView() && !theGame.IsDialogOrCutscenePlaying() && !recentlychangedclothes && !IsInCombat() )
		{
			if(GetAppearance() == 'victoria')
			{
				ApplyAppearance("victoria_rain");
			}
			
			if(GetAppearance() == 'victoria_continental')
			{
				ApplyAppearance("victoria_continental_rain");
			}			
			
			ishooded = true;
		}
		
		if( ishooded && !WillItRain() && IsAlive() && !recentlydied && !IsInView() && !theGame.IsDialogOrCutscenePlaying() && !recentlychangedclothes && !IsInCombat() || ishooded && IsInInterior() && IsAlive() && !recentlydied && !IsInView() && !theGame.IsDialogOrCutscenePlaying() && !recentlychangedclothes && !IsInCombat() )
		{
			if(GetAppearance() == 'victoria_rain')
			{
				ApplyAppearance("victoria");
				
			}
			
			if(GetAppearance() == 'victoria_continental_rain')
			{
				ApplyAppearance("victoria_continental");
			}				
			
			ishooded = false;
		}
		
		if( !playerinfistfight && GetWitcherPlayer().IsInFistFight() )
		{
			SetTemporaryAttitudeGroup( 'q104_avallach_friendly_to_all', AGP_Default );
			GetComponentByClassName('CInteractionComponent').SetEnabled( false );
			EnableDynamicMappin( 'victoriabase', false, 10, true );
			EnableCharacterCollisions( false );
			SetVisibility( false );
			playerinfistfight = true;
		}
		if( playerinfistfight && !GetWitcherPlayer().IsInFistFight() && !IsInView() )
		{
			SetTemporaryAttitudeGroup( 'player', AGP_Default );
			GetComponentByClassName('CInteractionComponent').SetEnabled( true );
			EnableDynamicMappin( 'victoriabase', true, 10, true );
			EnableCharacterCollisions( true );
			SetVisibility( true );
			playerinfistfight = false;
		}		
		
		}
	
		function WillItRain() : bool
		{
			var l_weather 				: name;
			
			l_weather 			= GetWeatherConditionName();
			
			if(l_weather == 'WT_Rain_Storm' || l_weather == 'WT_Heavy_Clouds_Dark' || l_weather == 'WT_Snow')
			{
				return true;
			}
			else
			{
				return false;
			}
		}
	
		 timer function ManageCompanionDistance(dt : float, id : int)
		{
			if ( VecDistance2D(thePlayer.GetWorldPosition(), this.GetWorldPosition()) >= 39 )
			{
				if( !thePlayer.IsSwimming() && !thePlayer.IsDiving() && !thePlayer.IsOnBoat() && thePlayer.IsOnGround() )
				{
					safespotresult = theGame.GetWorld().NavigationFindSafeSpot(thePlayer.GetWorldPosition() + theCamera.GetCameraDirection() * -3.0, GetRadius(), GetRadius() * 3, safespot );
					
					if ( !((CActor)this).IsInCombat() && !IsInView() && IsAlive() && safespotresult && !recentlydied )
					{
						this.Teleport( safespot );
					}
				}
			}
		}
	
	function PlayWakeupAnim()
	{
		var l_aiTree		: CAIPlayAnimationSlotAction;
		
		l_aiTree = new CAIPlayAnimationSlotAction in this;
		l_aiTree.OnCreated();
		
		l_aiTree.slotName = 'NPC_ANIM_SLOT';
		l_aiTree.animName = 'low_lying_dead_wake_up_to_high_standing_determined';
		
		WUBInt = ((CActor)this).ForceAIBehavior( l_aiTree, BTAP_Idle);	
	}
	
	timer function ManageOwnership(dt : float, id : int)
	{
		ownershipcontract = playerinv.GetItemsByName('DP_merc_contract');
		
			if(ownershipcontract.Size() >= 1 && !followingplayer)
			{
				l_aiTree = new CAISyannaCompanionBehavior  in ((CActor)this);
				l_aiTree.OnCreated();
				l_aiTree.params.moveType = MT_Sprint;
				l_aiTree.params.animName_1_start = 'stand_mw_music_flute_start';
				l_aiTree.params.animName_1_loop = 'stand_mw_music_flute_jt_loop_01';
				l_aiTree.params.animName_1_stop = 'stand_mw_music_flute_stop';
				l_aiTree.params.animName_2_start = 'stand_mw_training_sword_jt_start';
				l_aiTree.params.animName_2_loop = 'stand_mw_training_sword_jt_loop_01';
				l_aiTree.params.animName_2_stop = 'stand_mw_training_sword_jt_stop';
				l_aiTree.params.animName_3_start = 'stand_mw_training_sword_jt_start';
				l_aiTree.params.animName_3_loop = 'stand_mw_training_sword_jt_loop_02';
				l_aiTree.params.animName_3_stop = 'stand_mw_training_sword_jt_stop';
				l_aiTree.params.animName_4_start = 'woman_crouch_start';
				l_aiTree.params.animName_4_loop = 'woman_crouch_loop_1';
				l_aiTree.params.animName_4_stop = 'woman_crouch_stop';				
				AIBInt = ((CActor)this).ForceAIBehavior( l_aiTree, BTAP_Idle );				
				AddTimer('ManageCompanionSpeed', 0.016, true);
				AddTimer('ManageCompanionDistance', 0.016, true);
				hud.HideOneliner( this );
				hud.ShowOneliner( "Alright, lead the way!", this );
				AddTimer('delayedhideoneliner', 5.5, false);				
				AddTag('victoria_dialog');
				EnableDynamicMappin( 'victoriabase', true, 10, true );
				followingplayer = true;
				
				if(theGame.GetCommonMapManager().GetCurrentArea() == 1)
				{				
					RemoveTimer( 'ReturnToDP' );
				}
			}
			if(ownershipcontract.Size() <= 0 && followingplayer)
			{
				((CActor)this).CancelAIBehavior(AIBInt);
				RemoveTimer( 'ManageCompanionSpeed' );
				RemoveTimer( 'ManageCompanionDistance' );
				movecomp.SetGameplayRelativeMoveSpeed(0);
				RemoveTag( 'victoria_dialog' );
				hud.HideOneliner( this );
				hud.ShowOneliner( "I'll stay here for a while and then head back to the Devils Pit.", this );
				AddTimer('delayedhideoneliner', 8.2, false);
				RemoveTimer( 'RestartFollowing' );
				EnableDynamicMappin( 'victoriabase', false, 10 );
				followingplayer = false;
				
				if(usingtorch)
				{
					UnequipItem(torches[0]);
					SetBehaviorVariable( 'EquippedItemL', (int) LIT_None );
					usingtorch = false;
				}
				
				if(ishooded)
				{
					if(GetAppearance() == 'victoria_rain')
					{
						ApplyAppearance("victoria");
						
					}
					
					if(GetAppearance() == 'victoria_continental_rain')
					{
						ApplyAppearance("victoria_continental");
					}				
					
					ishooded = false;
				}
				
				if(theGame.GetCommonMapManager().GetCurrentArea() == 1)
				{
					AddTimer('ReturnToDP', 30, false);	
				}
			}
	}	

	timer function ReturnToDP(dt : float, id : int)
	{
		if(!IsInView())
		{
			TeleportWithRotation ( Vector(1061.679, 729.068, 15.832, 1), EulerAngles(0, -150.597, 0) );
		}
		else
		{
			AddTimer('ReturnToDP', 0.033, false);	
		}
	}
	
	event OnInteraction( actionName : string, activator : CEntity )
	{
		if(!followingplayer && PStash.GetItemQuantityByName('DP_merc_contract',true) > 0)
		{
			GetWitcherPlayer().GetHorseManager().MoveItemFromHorse(PStash.GetItemId('DP_merc_contract'), 1);	
		}
		else
		{
			super.OnInteraction(actionName, activator);
		}
	}	
	
	timer function SetVictoriaProperties(dt : float, id : int)
	{
			playerinv = thePlayer.GetInventory();
			ownershipcontract = playerinv.GetItemsByName('DP_merc_contract');
			
			this.SetLevel(thePlayer.GetLevel());
			this.ForceSetStat(BCS_Vitality, thePlayer.GetStatMax(BCS_Vitality));
			this.ForceSetStat(BCS_Stamina, thePlayer.GetStatMax(BCS_Stamina));
			this.RemoveAbilityAll('ablSignAttacks');
			this.AddAbility('ForceHiltFinisher');
			this.AddAbility('ForceFinisher');
			this.AddAbility('Throw');
			this.AddAbility('Zero_XP');	
			this.AddAbility('CanPlayIdleAnim');	
			
			inv = GetInventory();
			knives = inv.AddAnItem('ThrowingKnifeExpensive',9);
			torches = inv.AddAnItem('Torch_work_Victoria',1);
			inv.MountItem(knives[0]);
			
			SetImmortalityMode(AIM_Unconscious,AIC_Default);
			SetImmortalityMode(AIM_Unconscious,AIC_Combat);
			((CActor)this).SetHealthPerc(100);
			((CGameplayEntity)this).SetFocusModeVisibility(FMV_Interactive, 1);
			RemoveTag( 'victoria_dialog' );
			if(ownershipcontract.Size() >= 1 && !followingplayer)
			{			
				l_aiTree = new CAISyannaCompanionBehavior  in ((CActor)this);					
				l_aiTree.OnCreated();
		
				l_aiTree.params.moveType = MT_Sprint;
				l_aiTree.params.animName_1_start = 'stand_mw_music_flute_start';
				l_aiTree.params.animName_1_loop = 'stand_mw_music_flute_jt_loop_01';
				l_aiTree.params.animName_1_stop = 'stand_mw_music_flute_stop';
				l_aiTree.params.animName_2_start = 'stand_mw_training_sword_jt_start';
				l_aiTree.params.animName_2_loop = 'stand_mw_training_sword_jt_loop_01';
				l_aiTree.params.animName_2_stop = 'stand_mw_training_sword_jt_stop';
				l_aiTree.params.animName_3_start = 'stand_mw_training_sword_jt_start';
				l_aiTree.params.animName_3_loop = 'stand_mw_training_sword_jt_loop_02';
				l_aiTree.params.animName_3_stop = 'stand_mw_training_sword_jt_stop';
				l_aiTree.params.animName_4_start = 'woman_crouch_start';
				l_aiTree.params.animName_4_loop = 'woman_crouch_loop_1';
				l_aiTree.params.animName_4_stop = 'woman_crouch_stop';
				AIBInt = ((CActor)this).ForceAIBehavior( l_aiTree, BTAP_Idle );
				EnableDynamicMappin( 'victoriabase', true, 10 );
	
				AddTimer('ManageCompanionSpeed', 0.016, true);
				AddTimer('ManageCompanionDistance', 0.016, true);
				AddTag('victoria_dialog');
				followingplayer = true;
			}
			
			hud = (CR4ScriptedHud)theGame.GetHud();
			AddTimer('ManageOwnership', 1, true);
			
			PStash = GetWitcherPlayer().GetHorseManager().GetInventoryComponent();
			
			if(FactsQuerySum("VICTORIACONTINENTAL") == 1)
			{
				ApplyAppearance("victoria_continental");
			}			
	}
	
	public function IsWoman() : bool
	{	
		return false;
	}
	
	public function IsMan() : bool
	{
		return true;
	}	
		
	timer function DelayedStartSparring(dt : float, id : int)
	{
			FactsRemove("VICTORIASPARING");
			theGame.SaveGame(SGT_ForcedCheckPoint, 0);
			FactsSet("VICTORIASPARING",1);	
			this.AddTag('Victoria_Sparing');
			this.RemoveAbilityAll('Ciri_CombatRegen');
			((CActor)this).SetTemporaryAttitudeGroup( 'hostile_to_player', AGP_Default );
			thePlayer.SetImmortalityMode(AIM_Unconscious,AIC_Default);
			thePlayer.SetImmortalityMode(AIM_Unconscious, AIC_Combat);	
	}
	
}

latent storyscene function LetsSparVictoria( player: CStoryScenePlayer)
{
	var ents : array<CEntity>;
	var i : int;
	var victoria : CNewNPC;
	
	theGame.GetEntitiesByTag( 'victoria_dialog', ents );
	
		for( i = 0; ents.Size() > i; i += 1 )
	{
		victoria = (CNewNPC) ents[i];
		
		if( victoria )
		{
			victoria.AddTimer('DelayedStartSparring', 5.5, false);
		}
	}
}

latent storyscene function VictoriaChangeClothes( player: CStoryScenePlayer )
{
		var entity : CEntity;
		
		entity = theGame.GetEntityByTag( 'victoria_dialog' );	
		
		if( ((CActor)entity).GetAppearance() == 'victoria' || ((CActor)entity).GetAppearance() == 'victoria_rain' )
		{
			entity.ApplyAppearance("victoria_continental");
			FactsSet("VICTORIACONTINENTAL",1);	
		}
		else
		{
			entity.ApplyAppearance("victoria");
			FactsRemove("VICTORIACONTINENTAL");
		}
		
		((CVictoriaNPC)entity).SetRecentlyChanged(true);
		((CVictoriaNPC)entity).SetHooded(false);
}

latent storyscene function CarryMyStuff( player: CStoryScenePlayer, merchantTag : CName )
{
			theGame.GameplayFactsAdd("stashMode", 1);
			theGame.RequestMenuWithBackground( 'InventoryMenu', 'CommonMenu' );
}

latent storyscene function GwintHack(player: CStoryScenePlayer)
{
	var gwintManager:CR4GwintManager;
	var roll : int;
	gwintManager = theGame.GetGwintManager();
	gwintManager.setDoubleAIEnabled(false);
	
	roll = RandRange(5,0);
	
	if(roll == 0)
	{
		gwintManager.SetEnemyDeckByName('NKTournament');	
	}

	if(roll == 1)
	{
		gwintManager.SetEnemyDeckByName('NilfTournament');	
	}	

	if(roll == 2)
	{
		gwintManager.SetEnemyDeckByName('ScoiaTournament');	
	}	

	if(roll == 3)
	{
		gwintManager.SetEnemyDeckByName('NMLTournament');	
	}
	
	if(roll >= 4)
	{
		gwintManager.SetEnemyDeckByName('SkelTournament2');	
	}	
	
	gwintManager.testMatch = true;

	if (gwintManager.GetHasDoneTutorial())
	{
		gwintManager.gameRequested = true;
		theGame.RequestMenu( 'DeckBuilder' );
	}
	else
	{
		theGame.RequestMenu( 'GwintGame' );
	}
}