/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/** 	  2017 SkacikPL - Devil's Pit Mod
/***********************************************************************/
class W3ThrowingKnife extends W3ArrowProjectile 
{
	protected 				var snapCollisionGroupNames 			: array<name>;	
	private 				var targetPos 							: Vector;
	protected editable 		var dodgeable							: bool;	
							var	poisonous							: bool;
							var equippedOnSlot 						: EEquipmentSlots;
							var knifemesh							: CComponent;
							var throwangle							: float;
							var	wasInTutorialTrigger				: bool;			
							var cachedname							: name;
							var addedtoinventory					: bool;
							var recoverychance						: float;
							var randdur								: float;
							var storedowner							: CEntity;
	default shouldBeAttachedToVictim = true;
	default projDMG = 5;
	default projSilverDMG = 0;
	default ignoreArmor = false;
	default poisonous = false;
	default throwangle = 7;
	default projSpeed = 15;
	default dodgeable = true;
	default recoverychance = 0.3;
	
	//HAX
	event OnSpawned ( spawnData : SEntitySpawnData )
	{
		var Component : CComponent;
	
		super.OnSpawned(spawnData);
		
		Component = GetComponentByClassName('CAppearanceComponent');
		Component.SetEnabled(false);
		Component = GetComponentByClassName('CDynamicColliderComponent');
		Component.SetEnabled(false);		
		Component = GetComponentByClassName('CTriggerActivatorComponent');
		Component.SetEnabled(false);
		Component = GetComponentByClassName('CEffectDummyComponent');
		Component.SetEnabled(false);
		Component = GetComponentByClassName('CSoundEmitterComponent');
		Component.SetEnabled(false);	

		if(this.GetReadableName() == "dlc\devilspit\data\items\weapons\projectiles\throwables\throwingknife.w2ent")	
			cachedname = 'ThrowingKnife';
				
		if(this.GetReadableName() == "dlc\devilspit\data\items\weapons\projectiles\throwables\throwingknifeexpensive.w2ent")	
			cachedname = 'ThrowingKnifeExpensive';			
				
		if(this.GetReadableName() == "dlc\devilspit\data\items\weapons\projectiles\throwables\throwingknifewitcher.w2ent")	
			cachedname = 'ThrowingKnifeWitcher';
		
		
		AddTimer( 'KnifeMoveDelayed', 0.99, false );		
	}
	
	//Determine stats based on entity
	function DetermineItemStats()
	{	
		if(cachedname == 'ThrowingKnife')
		{
			projDMG = 5 * ((CActor)GetOwnerFix()).GetLevel();	
		}	
	
		if(cachedname == 'ThrowingKnifeExpensive')
		{
			projDMG = 10 * ((CActor)GetOwnerFix()).GetLevel();
			ignoreArmor = true;
			throwangle = 5;
			projSpeed = 25;	
			recoverychance = 0.5;		
		}
		
		if(cachedname == 'ThrowingKnifeWitcher')
		{
			projDMG = 15 * ((CActor)GetOwnerFix()).GetLevel();
			projSilverDMG = 15 * ((CActor)GetOwnerFix()).GetLevel();
			ignoreArmor = true;
			poisonous = true;
			throwangle = 3;
			projSpeed = 37;
			recoverychance = 0.8;	
		}
		
		storedowner = GetOwnerFix();		
	}
	
	//We need to move knife from its spawn position to the hand since entire mesh thing is shitty as hell
	timer function KnifeMoveDelayed( timeDelta : float , id : int)
	{		
//		storedowner = GetOwnerFix();
		
		knifemesh = GetComponentByClassName('CMeshComponent');			
		knifemesh.SetPosition(Vector(0.02, 0.01, 0.02, 1));
	}	

	event OnProcessThrowEvent( animEventName : name )
	{
		var throwPos : Vector;
		var boneIndex : int;
		var orientationTarget	: EOrientationTarget;
		var slideTargetActor : CActor;
		
		if ( animEventName == 'ProjectileThrow' )
		{
			if ( GetOwner() == thePlayer )
			{
				if ( thePlayer.GetDisplayTarget() )
					throwPos = thePlayer.GetLookAtPosition();
				else
				{
					orientationTarget = thePlayer.GetOrientationTarget();
					
					if (!GetOwner().HasBuff(EET_Hypnotized) && (orientationTarget == OT_Camera || orientationTarget == OT_CameraOffset) )
						throwPos = theCamera.GetCameraDirection() * 8 + GetOwner().GetWorldPosition();
					else
						throwPos = GetOwner().GetWorldForward() * 8 + GetOwner().GetWorldPosition();		
				}
			}			
			else
			{
				slideTargetActor = (CActor)( GetOwner().slideTarget );
			
				
				if( GetOwner().slideTarget && !GetOwner().HasBuff(EET_Hypnotized) &&
					( !slideTargetActor || ( slideTargetActor && GetAttitudeBetween(GetOwner(), GetOwner().slideTarget) == AIA_Hostile ) ) )
				{
					boneIndex = GetOwner().slideTarget.GetBoneIndex( 'pelvis' );
					if ( boneIndex > -1 )
						throwPos = MatrixGetTranslation( GetOwner().slideTarget.GetBoneWorldMatrixByIndex( boneIndex ) );
					else
						throwPos = GetOwner().slideTarget.GetWorldPosition();
				}
				else
				{
					orientationTarget = thePlayer.GetOrientationTarget();
					
					if (!GetOwner().HasBuff(EET_Hypnotized) && (orientationTarget == OT_Camera || orientationTarget == OT_CameraOffset) )
						throwPos = theCamera.GetCameraDirection() * 8 + GetOwner().GetWorldPosition();
					else
						throwPos = GetOwner().GetWorldForward() * 8 + GetOwner().GetWorldPosition();		
				}
			}
			
			ThrowProjectile( throwPos );
		}					
			
		return super.OnProcessThrowEvent( animEventName );
	}
	
	function GetOwnerFix() : CActor
	{
		var l_actors		: array<CActor>;
	
		l_actors = GetActorsInRange( this, 1, 1);
		
		return l_actors[0];
	}
	
	public function ThrowProjectile( targetPosIn : Vector )
	{		
		var phantom : CPhantomComponent;
		var inv : CInventoryComponent;		
		
		phantom = (CPhantomComponent)GetComponent('snappingCollisionGroupNames');
		if(phantom)
		{
			phantom.GetTriggeringCollisionGroupNames(snapCollisionGroupNames);
		}
		else
		{
			snapCollisionGroupNames.PushBack('Terrain');
			snapCollisionGroupNames.PushBack('Static');
		}	
	
		targetPos = targetPosIn;
		
		
		AddTimer( 'ReleaseProjectile', 0.01, false, , , true );
		
		
		if ( GetOwner() != thePlayer )
		{
			inv = GetOwner().GetInventory();
			if(inv)
				inv.RemoveItem( itemId );
		}
		else
		{
			if( !GetWitcherPlayer().IsSetBonusActive( EISB_Wolf_2 ) )
			{
				GetWitcherPlayer().AddBombThrowDelay(itemId);
			}
				
			if(GetOwner() == GetWitcherPlayer())
				GetWitcherPlayer().FailFundamentalsFirstAchievementCondition();
		}
	}
	
	
	timer function ReleaseProjectile( time : float , id : int)
	{
		var distanceToTarget, projectileFlightTime : float;
		var target : CActor = thePlayer.GetTarget();
		var actorsInAoE : array<CActor>;
		var i : int;
		var collisionGroups : array<name>;

		DetermineItemStats();
		
		BreakAttachment();
		if( target.HasTag('AddRagdollCollision'))
		{
			collisionGroups.PushBack('Ragdoll');
			collisionGroups.PushBack('Terrain');
			collisionGroups.PushBack('Static');
			collisionGroups.PushBack('Water');
			collisionGroups.PushBack('Destructible');			
			ShootProjectileAtPosition( throwangle, projSpeed, targetPos, theGame.params.MAX_THROW_RANGE, collisionGroups);
		}
		else
		{
			ShootProjectileAtPosition( throwangle, projSpeed, targetPos, theGame.params.MAX_THROW_RANGE );
		}
		
		if(isFromAimThrow && ShouldProcessTutorial('TutorialThrowHold'))
		{
			wasInTutorialTrigger = (FactsQuerySum("tut_aim_in_trigger") > 0);				
		}
		
		if( dodgeable && target )
		{
			distanceToTarget = VecDistance( thePlayer.GetWorldPosition(), target.GetWorldPosition() );	
				
			projectileFlightTime = distanceToTarget / projSpeed;
			target.SignalGameplayEventParamFloat( 'Time2DodgeProjectile', projectileFlightTime );
		}
			
		((CNewNPC)target).OnIncomingProjectile( true );
		
		ActivateTrail( defaultTrail );
		wasThrown = true;
		knifemesh.SetPosition(Vector(0., -0.58, 0, 1));
		
		if(GetOwner() == thePlayer)
			DetractAmmo();
			
		actorsInAoE = GetActorsInRange(GetOwner(), 15, 1000000, '');	
		
		for(i = 0; i < actorsInAoE.Size(); i += 1)
		{
			if(actorsInAoE[i] && ((CNewNPC)actorsInAoE[i]).GetNPCType() == ENGT_Guard && !((CNewNPC)actorsInAoE[i]).IsInCombat() )
			{
				((CNewNPC)actorsInAoE[i]).SignalGameplayEventParamObject('CastSignAction', GetOwner());
				theGame.GetBehTreeReactionManager().CreateReactionEventIfPossible( ((CNewNPC)actorsInAoE[i]), 'CastSignAction', 8.0, 1.0f, 999.0f, 1, false); 
			}
			if(actorsInAoE[i] && ((CNewNPC)actorsInAoE[i]).GetNPCType() == ENGT_Commoner && !((CNewNPC)actorsInAoE[i]).IsInCombat() )
			{
				((CNewNPC)actorsInAoE[i]).SignalGameplayEventParamObject('BombExplosionAction', GetOwner());
				theGame.GetBehTreeReactionManager().CreateReactionEventIfPossible( ((CNewNPC)actorsInAoE[i]), 'BombExplosionAction', 8.0, 1.0f, 999.0f, 1, false); 
			}			
		}
	}
	
//Handle ammo detraction and automatic reequipping of the item	
	function DetractAmmo()
	{
		var availableCount : int;
		var stackexists	: bool;
		var otherstacks : array<SItemUniqueId>;
		
		equippedOnSlot = GetWitcherPlayer().GetItemSlot( itemId );
		thePlayer.inv.RemoveItem( itemId, 1 );
		availableCount = thePlayer.inv.GetItemQuantity( itemId );
		stackexists = false;
		
		//Mount next knife from one stack
		if(availableCount > 0)
		{
			GetWitcherPlayer().EquipItemInGivenSlot(itemId, equippedOnSlot, false);
			GetWitcherPlayer().SelectQuickslotItem(equippedOnSlot);
			stackexists = true;
		}
		
		//Existing stack depleted - look for a new one	
		availableCount = thePlayer.inv.GetItemQuantityByName( cachedname );
		
		if(!stackexists && availableCount > 0)
		{
			otherstacks = thePlayer.inv.GetItemsByName( cachedname );
			GetWitcherPlayer().EquipItemInGivenSlot(otherstacks[0], equippedOnSlot, false);
			GetWitcherPlayer().SelectQuickslotItem(equippedOnSlot);
			theSound.SoundEvent("gui_inventory_other_attach");			
		}
				
		//No ammo of the same type left
		if(!stackexists && availableCount == 0)
		{
			theSound.SoundEvent("gui_inventory_ranged_back");	
		}		
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		var victiminv	: CInventoryComponent;	
		
		if(collidingComponent.GetEntity() != this && collidingComponent.GetEntity() != storedowner && ((CNewNPC)collidingComponent.GetEntity()).GetNPCType() != ENGT_Commoner)
		{
			super.OnProjectileCollision(pos,normal,collidingComponent,hitCollisionsGroups,actorIndex,shapeIndex);
			
			((CGameplayEntity)collidingComponent.GetEntity()).OnBoltHit();
			
			//If we hit a living target, add knife to its inventory - once. Only if we roll a number higher than recovery chance for given knife.
			if((CActor)victim && !addedtoinventory)
			{
				randdur = RandRangeF(1.0, 0.009);
			
				if(randdur <= recoverychance)
				{
					victiminv = ((CActor)victim).GetInventory();
					
					victiminv.AddAnItem(cachedname, 1, true, true);
					addedtoinventory = true;
				}
				else
				{
					//Absolutely disgusting "volume" hack
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");
					this.SoundEvent("cmb_arrow_impact_metal");					
					addedtoinventory = true;
				}
			}
		}
	}

	//Major rebuild and overhaul
	function AttachArrowToShield( victim : CActor, pos : Vector )
	{
		var bones 		: array<name>;
		var res 		: bool;
		var inv 		: CInventoryComponent;
		var shield		: CEntity;
		var rot			: EulerAngles;
		var meshcomp	: CComponent;
		var shieldBB	: Box;
		var shieldfield	: float;
		var shieldwidth : float;
		
		StopProjectile();
		StopActiveTrail();
		isActive = false;
		
		inv = victim.GetInventory();
		
		//Attach knife to shield based on circle with field slightly smaller than it's bounding box width.
		shield = inv.GetItemEntityUnsafe(inv.GetItemFromSlot('l_weapon'));
		meshcomp = shield.GetComponentByClassName('CMeshComponent');
		shieldBB = ((CMeshComponent)meshcomp).GetBoundingBox();		
		
		shieldwidth = (shieldBB.Max.X - shieldBB.Min.X) / 2;
		shieldfield = ( Pi() * ( shieldwidth * shieldwidth ) ) * 0.27;
		
		pos = meshcomp.GetWorldPosition();
		pos.X = RandRangeF(shieldfield, -shieldfield);
		pos.Z = RandRangeF(shieldfield, -shieldfield);
		pos.Y = RandRangeF(0.27,0.18);
		
		rot = this.GetWorldRotation();
		rot.Yaw = RandRangeF(200,160);
		rot.Roll = RandRangeF(200,160);
		
		knifemesh.SetRotation(EulerAngles(RandRangeF(45,-45),0,0));
		knifemesh.SetPosition(Vector(0, 0, 0, 1));
		this.CreateAttachment( shield , , pos, rot );
	}
	
	function AttachArrowToRagdoll(victim : CActor, pos : Vector, boneName : name)
	{
		var bones 				: array<name>;
		var res 				: bool;
		var arrowHitPos 		: Vector;
		var timerAmount 		: float;
		var shouldPierceVictim 	: bool;
		
		var meshComponent		: CMeshComponent;
		var arrowSize			: Vector;
		var boundingBox			: Box;
		var rotMat				: Matrix;
		
		shouldPierceVictim = ShouldPierceVictim( victim );
		if( !shouldPierceVictim )
		{
			StopProjectile();
			StopActiveTrail();	
			isActive = false;
		}
		
		bones.PushBack( 'head' );
		bones.PushBack( 'hroll' );
		bones.PushBack( 'neck' );
		
		if ( ( victim == thePlayer && bones.Contains(boneName) ) || ( ((CNewNPC)victim).IsHorse() && !shouldPierceVictim ) ) 
		{
			SmartDestroy();
		}
		else if( !shouldPierceVictim )
		{
			arrowHitPos = pos;
			
			
			meshComponent = (CMeshComponent)GetComponentByClassName('CMeshComponent');
			if( meshComponent )
			{
				boundingBox = meshComponent.GetBoundingBox();
				arrowSize = boundingBox.Max - boundingBox.Min;
				
				rotMat = MatrixBuiltRotation( this.GetWorldRotation() );
				rotMat = MatrixGetInverted( rotMat );
				arrowSize = VecTransformDir( rotMat, arrowSize );
				
				
				
				if( arrowSize.Y > 0 )	
					arrowHitPos += RotForward(  this.GetWorldRotation() ) * arrowSize.Y * 0.1f; 
				else	
					arrowHitPos -= RotForward(  this.GetWorldRotation() ) * arrowSize.Y * 0.9f; 
			}
			
			if ( boneName )
			{
				res = this.CreateAttachmentAtBoneWS(victim, boneName, arrowHitPos, this.GetWorldRotation());
			}
			else
			{
				res = this.CreateAttachmentAtBoneWS(victim, 'torso3', arrowHitPos, this.GetWorldRotation());
			}
			
			if ( res )
			{
				if( victim == thePlayer && !GetShouldBeAttachedToVictim() )
					timerAmount = 0.01;
				else if( victim == thePlayer )
					timerAmount = 3;
				else
					timerAmount = 5;
				
				AddTimer('TimeDestroy', timerAmount, false);
				isScheduledForDestruction = true;
				
			}
			else
				SmartDestroy();
		}
	}

		protected function ProcessDamageAction(victim : CGameplayEntity, pos : Vector, boneName : name)
		{
			caster = storedowner;
			super.ProcessDamageAction(victim,pos,boneName);

			//Some additional logic for the knives, like headshot debuffs and poison for witcher gear knife.
			if ( (CActor)victim )
			{
				if ( boneName == 'head' || boneName == 'neck' || boneName == 'hroll' )
				{
					((CActor)victim).AddEffectDefault(EET_Stagger, (CGameplayEntity)storedowner);
					((CActor)victim).AddEffectDefault(EET_Bleeding, (CGameplayEntity)storedowner);
				}
			
				if(poisonous)
					((CActor)victim).AddEffectDefault(EET_Poison, (CGameplayEntity)storedowner);
			}		
		}
	
}