function PNEffects() {
	if ( PNHungerOn() ) PNHungerEffects();
	if ( PNFatigueOn() ) PNFatigueEffects();
}

// ==========
//   Hunger
// ==========

function PNHungerEffects() {
	var witcher : W3PlayerWitcher;
	var currVital : float;
	var vitalDrain : float;
	
	witcher = GetWitcherPlayer();
	if (PNGetHunger() >= 50) {
		currVital = thePlayer.GetStat(BCS_Vitality);
		vitalDrain = PNGetHungerEffectsMult();
		
		if (currVital - vitalDrain <= 0.f) 
		{
			thePlayer.DrainVitality( currVital - 1 );
			thePlayer.AddEffectDefault( EET_VitalityDrain, thePlayer, "Starvation", false );
		}
		else 
		{
			thePlayer.DrainVitality( vitalDrain );
		}
	}
}

function PNGetHungerEffectsMult() : float {
	if ( PNHungerOn() ) {
		return (float) PNGetHungerDamage() * ( (float) PNGetHunger() / 100 );
	} else {
		return 0;
	}
}

function PNGetHungerAdrenalineDrain() : float {
	if (PNHungerOn()) {
		if (PNIsPatch())
			return 1.5 - ((float) PNGetHunger() / 100 );
		else 
			return (float) PNGetHunger() / 100 + 0.5;
	} else {
		return 1;
	}
}

// ==========
//   Thirst
// ==========

function PNGetThirstStaminaRegenMult() : float {
	if ( PNThirstOn() ) {
		return PNGetThirstStaminaMult() - ( ((float) PNGetThirst() * PNGetThirstStaminaMult()) / 100 );
	} else {
		return 1;
	}
}

// ===========
//   Fatigue
// ===========

function PNArmorType() : float {
	var witcher : W3PlayerWitcher;
	var armor : SItemUniqueId;
	var gloves : SItemUniqueId;
	var pants : SItemUniqueId;
	var boots : SItemUniqueId;
	var total : float ;
	var items : array <SItemUniqueId>;
	var i : int ;
	
	witcher = GetWitcherPlayer();
	total = 0;
	
	witcher.GetItemEquippedOnSlot(EES_Armor, armor); items.PushBack (armor);
	witcher.GetItemEquippedOnSlot(EES_Gloves, gloves); items.PushBack (gloves);
	witcher.GetItemEquippedOnSlot(EES_Boots, pants); items.PushBack (pants);
	witcher.GetItemEquippedOnSlot(EES_Pants, boots); items.PushBack (boots);
	
	for( i = 0; i < items.Size(); i += 1 ) {	
		if( witcher.inv.ItemHasTag(items[i], 'LightArmor'))
			total += PNGetLightArmorAdd();
		else if( witcher.inv.ItemHasTag(items[i], 'MediumArmor'))
			total += PNGetMediumArmorAdd();
		else if( witcher.inv.ItemHasTag(items[i], 'HeavyArmor'))
			total += PNGetHeavyArmorAdd();
	}
	return total;
}

function PNFatigueEffects() {
	if ( PNFatigueLevel5() ) {
		thePlayer.SetWalkToggle( true );
	}
}

function PNFatigueLevel1() : bool {
	return PNGetFatigue() >= 50;
}

function PNFatigueLevel2() : bool {
	return PNGetFatigue() >= 60;
}

function PNFatigueLevel3() : bool {
	return PNGetFatigue() >= 70;
}

function PNFatigueLevel4() : bool {
	return PNGetFatigue() >= 80;
}

function PNFatigueLevel5() : bool {
	return PNGetFatigue() >= 90;
}