function PNRiseFatigue( diff : int ) {
	if (!PNPeekMeditationFlag()) {
		if ( diff > 1 ) {
			if (diff / PNGetFatigueCounter() >= PNGetFatigueMaxFastTravel()) {
				diff = PNGetFatigueMaxFastTravel() * PNGetFatigueCounter();
			}
			PNMeditateDrop( RoundMath( ( (float) diff / (float) PNGetFatigueCounter() ) * ( -1 ) ) );
		} else {
			PNDecFatigueCnt( PNGetFatigueInc() );
		}
	} else {
		PNMeditate( diff );
	}
}

function PNGetFatigueInc() : float {
	var combatadd : float;
	var healthadd : float;
	var totaladd : float;
	var staminaadd : float;
	var adrenalineadd : float;
	var toxadd : float;
	var weightadd : float;
	var hasHorseUpgrade : bool;
	var weightPercent : float;
	
	combatadd = 0;
	if ( thePlayer.IsInCombat() ) {
		combatadd = PNGetFatigueCombatAdd();
	}
	weightPercent = GetWitcherPlayer().GetEncumbrance() / GetWitcherPlayer().GetMaxRunEncumbrance(hasHorseUpgrade);
	healthadd = (1 - (thePlayer.GetStat(BCS_Vitality) / thePlayer.GetStatMax(BCS_Vitality))) * PNGetFatigueVitalityAdd();
	staminaadd = (1 - (thePlayer.GetStat(BCS_Stamina) / thePlayer.GetStatMax(BCS_Stamina))) * PNGetFatigueStaminaAdd();
	if (!PNIsPatch())
		adrenalineadd = (thePlayer.GetStat(BCS_Focus) / thePlayer.GetStatMax(BCS_Focus)) * PNGetFatigueAdrenalineAdd();
	else 
		adrenalineadd = (1 - (thePlayer.GetStat(BCS_Focus) / thePlayer.GetStatMax(BCS_Focus))) * PNGetFatigueAdrenalineAdd() * (-1.f);
	toxadd = (thePlayer.GetStat(BCS_Toxicity) / thePlayer.GetStatMax(BCS_Toxicity)) * PNGetFatigueToxAdd();
	if (weightPercent >= PNGetFatigueWeightThreshold()) {
		weightadd = weightPercent * PNGetFatigueWeightAdd();
	} else {
		weightadd = 0;
	}
	totaladd = 1 + combatadd + healthadd + staminaadd + weightadd + PNArmorType() - adrenalineadd - toxadd;
	if (PNPukeAnimOn()) if (thePlayer.PukeEffect) totaladd += 1; 
	if (totaladd < 0) { totaladd = 0; } 
	return totaladd;
}

function PNMeditate( mins : int ) {
	var dec : float;
	dec = (float) mins / 3.6;
	PNSetFatigue( RoundMath( PNGetFatigue() - dec ) );
	PNResetFatigueCnt();
}

function PNMeditateDrop( mins : int ) {
	var dec : float;
	dec = (float) mins;
	PNSetFatigue( RoundMath( PNGetFatigue() - dec ) );
	PNResetFatigueCnt();
}

