class PNVars {
	public var hungercnt : float;
	public var thirstcnt : float;
	public var fatiguecnt : float;
	public var currHunger : int;
	public var currThirst : int;
	public var currFatigue : int;
	public var currPee : int;
	public var currPoop : int;
	public var peeStr : string;
	public var poopStr : string;
	
	public var lasttime : int;
	public var daychanged : int;
	public var timeinit : bool;
	
	public function SetF( val : float ) { fatiguecnt = val; }
	public function SetT( val : float ) { thirstcnt = val; }
	public function SetH( val : float ) { hungercnt = val; }
	public function SetFatigue( val : int ) { currFatigue = val; }
	public function SetHunger( val : int ) { currHunger = val; }
	public function SetThirst( val : int ) { currThirst = val; }
	public function SetPee( val : int ) { currPee = val; }
	public function SetPeeStr( val : string ) { peeStr = val; }
	public function SetPoop( val : int ) { currPoop = val; }
	public function SetPoopStr( val : string ) { poopStr = val; }
	
	public function SetDayChanged( val : int ) { daychanged = val; }
	public function SetLT( value : int) { lasttime = value; }
	public function SetTimeInit( val : bool ) { timeinit = val; }
	
	public function Init() {
		var temp : int;
		hungercnt = PNGetHungerCounter();
		thirstcnt = PNGetThirstCounter();
		fatiguecnt = PNGetFatigueCounter();
		
		currHunger = PNGetHungerLevel();
		currThirst = PNGetThirstLevel();
		currFatigue = PNGetFatigueLevel();
		
		daychanged = GameTimeDays(theGame.GetGameTime());
		lasttime = GameTimeToSeconds(theGame.GetGameTime()) / 60;
		
		currPee = PNGetPeeLevel();
		currPoop = PNGetPoopLevel();
		PNUpdatePeeStr();
		PNUpdatePoopStr();
	}
}

function PNResetFatigueCnt() { theGame.PNOptions().SetF( PNGetFatigueCounter() ); }
function PNResetThirstCnt() { theGame.PNOptions().SetT( PNGetThirstCounter() ); }
function PNResetHungerCnt() { theGame.PNOptions().SetH( PNGetHungerCounter() ); }

function PNDecFatigueCnt( fat : float ) { theGame.PNOptions().SetF( PNGetFatigueCnt() - fat ); }
function PNDecThirstCnt( thr : float ) { theGame.PNOptions().SetT( PNGetThirstCnt() - thr ); }
function PNDecHungerCnt( hun : float ) { theGame.PNOptions().SetH( PNGetHungerCnt() - hun ); }

function PNGetFatigueCnt() : float { return theGame.PNOptions().fatiguecnt; }
function PNGetThirstCnt() : float { return theGame.PNOptions().thirstcnt; }
function PNGetHungerCnt() : float { return theGame.PNOptions().hungercnt; }

function PNSetHunger( val : int ) { 
	PNCleanHunger();
	if ( val > 100 ) val = 100;
	if ( val < 0 ) val = 0;
	thePlayer.AddAbility(PNHungerToName(val));
	theGame.PNOptions().SetHunger( val );
}
function PNSetThirst( val : int ) {
	PNCleanThirst();
	if ( val > 100 ) val = 100;
	if ( val < 0 ) val = 0;
	thePlayer.AddAbility( PNThirstToName(val));
	theGame.PNOptions().SetThirst( val );
}
function PNSetFatigue( val : int ) {
	PNCleanFatigue();
	if ( val > 100 ) val = 100;
	if ( val < 0 ) val = 0;
	thePlayer.AddAbility( PNFatigueToName(val) );
	theGame.PNOptions().SetFatigue( val );
}

function PNCleanHunger() {
	var i : int;
	var ability : name;
	thePlayer.RemoveAbility(PNHungerToName(PNGetHunger()));
	if (PNGetHungerLevel() > 0) {
		for (i = 0; i <= 100; i+=1) {
			ability = PNHungerToName(i);
			while ( thePlayer.HasAbility(ability)) {
				thePlayer.RemoveAbility(ability);
			}
		}
	}
}
function PNCleanThirst() {
	var i : int;
	var ability : name;
	thePlayer.RemoveAbility(PNThirstToName( PNGetThirst()));
	if (PNGetThirstLevel() > 0) {
		for (i = 0; i <= 100; i+=1) {
			ability = PNThirstToName(i);
			while ( thePlayer.HasAbility(ability)) {
				thePlayer.RemoveAbility(ability);
			}
		}
	}
}
function PNCleanFatigue() {
	var i : int;
	var ability : name;
	thePlayer.RemoveAbility( PNFatigueToName( PNGetFatigue()) );
	if (PNGetFatigueLevel() > 0) {
		for (i = 0; i <= 100; i+=1) {
			ability = PNFatigueToName(i);
			while ( thePlayer.HasAbility(ability)) {
				thePlayer.RemoveAbility(ability);
			}
		}
	}
}

function PNGetHunger() : int { return theGame.PNOptions().currHunger; };
function PNGetThirst() : int { return theGame.PNOptions().currThirst; };
function PNGetFatigue() : int { return theGame.PNOptions().currFatigue; };

function PNSetLastTime( val : int ) { theGame.PNOptions().SetLT( val ); }
function PNGetLastTime() : int { return theGame.PNOptions().lasttime; }

function PNGetPee() : int { return theGame.PNOptions().currPee;}
function PNGetPoop() : int { return theGame.PNOptions().currPoop;}
function PNGetPeeStr() : string { return theGame.PNOptions().peeStr; }
function PNGetPoopStr() : string { return theGame.PNOptions().poopStr; }
function PNSetPee( val : int ) {
	PNCleanPee();
	if ( val > 9 ) val = 9;
	if ( val < 0 ) val = 0;
	thePlayer.AddAbility(PNPeeToName(val));
	theGame.PNOptions().SetPee( val );
	PNUpdatePeeStr();
}
function PNSetPoop( val : int ) {
	PNCleanPoop();
	if ( val > 19 ) val = 19;
	if ( val < 0 ) val = 0;
	thePlayer.AddAbility(PNPoopToName(val));
	theGame.PNOptions().SetPoop( val );
	PNUpdatePoopStr();
}
function PNCleanPee() {
	var i : int;
	var ability : name;
	thePlayer.RemoveAbility(PNPeeToName(PNGetPee()));
	if (PNGetPeeLevel() > 0) {
		for (i = 0; i <= 9; i+=1) {
			ability = PNPeeToName(i);
			while ( thePlayer.HasAbility(ability)) {
				thePlayer.RemoveAbility(ability);
			}
		}
	}
}
function PNCleanPoop() {
	var i : int;
	var ability : name;
	thePlayer.RemoveAbility(PNPoopToName(PNGetPoop()));
	if (PNGetPoopLevel() > 0) {
		for (i = 0; i <= 19; i+=1) {
			ability = PNPoopToName(i);
			while ( thePlayer.HasAbility(ability)) {
				thePlayer.RemoveAbility(ability);
			}
		}
	}
}
function PNUpdatePeeStr() {
	var pee : int;
	var str : string;
	var i : int;
	pee = PNGetPee();
	if (pee <= 0) {
		theGame.PNOptions().SetPeeStr( "<font color=\"#1c1c1c\">||||||||||||||||||||</font>" );
	}
	else {
		str = "<font color=\"#FCAD36\">";
		for (i = 0; i < pee; i+=1) {
			str += "||";
		}
		str += "</font><font color=\"#1c1c1c\">";
		for (i = pee; i < 10; i+=1) {
			str += "||";
		}
		str += "</font>";
		theGame.PNOptions().SetPeeStr( str );
	}
}
function PNUpdatePoopStr() {
	var poop : int;
	var str : string;
	var i : int;
	poop = PNGetPoop();
	if (poop <= 0) {
		theGame.PNOptions().SetPoopStr( "<font color=\"#1c1c1c\">||||||||||||||||||||</font>" );
	} else {
		str = "<font color=\"#8e5f0e\">";
		for (i = 0; i < poop; i+=1) {
			str += "|";
		}
		str += "</font><font color=\"#1c1c1c\">";
		for (i = poop; i < 20; i+=1) {
			str += "|";
		}
		str += "</font>";
		theGame.PNOptions().SetPoopStr( str );
	}
}

function PNTimeInit() : bool {
	if ( theGame.PNOptions().timeinit ) {
		theGame.PNOptions().SetTimeInit(false);
		return true;
	} else {
		return false;
	}
}

function PNIncDayChanged() { theGame.PNOptions().SetDayChanged( PNGetDayChanged() + 1 ); }
function PNGetDayChanged() : int { return theGame.PNOptions().daychanged; }

function PNTimePass() {
	var dayNow : int;
	var time : int;
	var diff : int;
		
	// Real Time Meditation Support
	if ( thePlayer.GetCurrentStateName() == 'AlchemyBrewing' 		// Primer support
	  || thePlayer.GetCurrentStateName() == 'ExplorationMeditation' // Preparation + Friendly Meditation support
	  || thePlayer.GetCurrentStateName() == 'W3EEMeditation' ) {	// W3EE support
		PNSetMeditationFlag();
	}
	
	ForcedPeePoop();
	// Forced Collapse
	if ( PNGetFatigue() == 100 && PNSleepAnimOn()) {
		PNCollapseAnim();
	}
	
	dayNow = GameTimeDays(theGame.GetGameTime());
	
	time = GameTimeToSeconds(theGame.GetGameTime()) / 60;
	diff = (time - PNGetLastTime());
	PNSetLastTime(time);
	
	if ( thePlayer.IsCiri() ) {
		if ( PNGetDayChanged() != dayNow) {
			PNIncDayChanged();
		}
		return;
	}
	
	if (PNExpireOn()) {
		if ( PNGetDayChanged() != dayNow) {
			PNDecrementDay();
			PNIncDayChanged();
		}
	}
	
	if (PNHungerOn()) {
		PNRiseHunger( diff );
		if ( PNGetHungerCnt() <= 0 ) {
			PNSetHunger( PNGetHunger() + 1 );
			PNResetHungerCnt();
		}
	}
	
	if (PNThirstOn()) {
		PNRiseThirst( diff );
		if ( PNGetThirstCnt() <= 0 ) {
			PNSetThirst( PNGetThirst() + 1 );
			PNResetThirstCnt();
		}
	}
	
	if (PNFatigueOn()) {
		PNRiseFatigue( diff );
		if ( PNGetFatigueCnt() <= 0 ) {
			PNSetFatigue( PNGetFatigue() + 1 );
			PNResetFatigueCnt();
		}
	}
	
	if ( PNPeekMeditationFlag() ) {
		PNResetMeditationFlag();
	}
	
}