// nw相关的访问，通过全局变量访问
(function () {
    const gui = require('nw.gui');
    const win = gui.Window.get();
    const fs = require('fs');
    const utils = require('wxb-utils');
    const homeDir = process.env.HOME || (process.env.HOMEDRIVE + process.env.HOMEPATH);
    const materialDir = `${homeDir}/.wxb_muti`;
    // 最大化
    win.maximize();
    // 初始化
    gui.App.on('open', function () {
        win.focus();
    });
    /* 创建数据存储目录，存在则忽略*/
    fs.mkdir(materialDir, '0776', function (err) {
        if (err) {
            if (err.code === 'EEXIST') {
                return;
            }
        }
    });
    // 处理新打开窗口的行为
    win.on('new-win-policy', function (frame, url, policy) {
        if (frame) {
            if ($(frame.contentWindow.document).find(`[href="${url}"]`).hasClass('extra-link')) {
                gui.Shell.openExternal(url);
                policy.ignore();
                return;
            }
        }
        policy.setNewWindowManifest({
            'title': '微小宝多平台助手',
            'icon': 'assest/img/icon.png',
            'position': 'center',
            'width': 1280,
            'height': 680,
            'frame': true,
            'resizable': true,
            'min_width': 1028
        });
    });
    // 禁止文件拖拽进入
    // window.ondragover = function (e) {
    //     e.preventDefault();
    //     return false;
    // };
    // window.ondrop = function (e) {
    //     e.preventDefault();
    //     return false;
    // };
    document.onkeydown = utils.banBackSpace;
    // 开启可以编辑的菜单
    if (process.platform === 'darwin') {
        const _mb = new gui.Menu({ type: 'menubar' });
        _mb.createMacBuiltin('微小宝多平台助手', {
            hideEdit: false,
        });
        win.menu = _mb;
    }
})();
