var _$proxyMethod = ['post', 'get'];
var $proxy = {};
_$proxyMethod.forEach(function (name) {
    $proxy[name] = function () {
        var args = arguments;
        return new Promise(function (resolve, reject) {
            $[name].apply($, args).then(function (res) {
                resolve(res);
            }).fail(function (res) {
                reject(res);
            });
        });
    };
});


function sougouSpider(_atob, options) {
    var cheerio = require('cheerio');
    var fs = require('fs');
    var macAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_0) AppleWebKit/537.36' +
    ' (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36';

    this.options = options || {};
    this._atob = _atob;
    // this.tasks = [];
    // this.running = -1;  // -1 未开始, 0 停止, 1 运行, 2 暂停
    // this.complete = [];
    // this.failure = [];
    this.callback = this.options.callback || {};
    // this.noSleep = true;
    // this.initTime = null;
    // this.sougouVerifyCount = 0; // 搜狗出现验证码次数
    // this.weixinVerifyCount = 0; // 微信出现验证码次数
    // this.sougouMaxVerify = 2; // 最大搜狗出现验证码次数
    // this.weixinMaxVerify = 2; // 最大微信出现验证码次数
    this.verifyFrame = this.options.verifyFrame; // 用来显示验证码的iframe

    // 显示验证码的iframe需要注入js;
    if (this.verifyFrame) {
        var _self = this;
        this.verifyFrame.onload = function () {
            var doc = _self.verifyFrame.contentDocument;
            var js = doc.createElement('script');
            js.src = 'http://s.weituibao.com/static/1482458620047/t.js';
            doc.head.appendChild(js);
        };
    }
    // promise延时处理，默认10~20秒时间间隔
    this._retTimeout = function (res, time, force) {
        var _time = time || 10000;
        // return Promise.resolve(res);
        if (this.noSleep && !force) {
            // 关闭等待时
            return Promise.resolve(res);
        }
        return new Promise(function (resolve) {
            setTimeout(function () {
                resolve(res || null);
            }, _time + parseInt(_time * Math.random(), 10));
        });
    };

    this._randomTime = function (t, min) {
        // return 500;
        var v = parseInt(t * Math.random(), 10);
        if (min && v < min) {
            return min;
        }
        return v;
    };

    this.recover = function() {
        this.tasks = [];
        this.running = -1;  // -1 未开始, 0 停止, 1 运行, 2 暂停
        this.complete = [];
        this.failure = [];
        this.noSleep = true;
        this.initTime = null;
        this.sougouVerifyCount = 0; // 搜狗出现验证码次数
        this.weixinVerifyCount = 0; // 微信出现验证码次数
        this.sougouMaxVerify = 2; // 最大搜狗出现验证码次数
        this.weixinMaxVerify = 2; // 最大微信出现验证码次数
    }

    this.start = function (tasks, _id, onAllDone) {
        this.recover();
        // 检查状态再进行操作，控制值守时间等
        var self = this;
        this._id = _id;
        this.running = 1;
        this.tasks = tasks;
        this.initTime = Date.now();
        // 任务全部结束
        if (onAllDone) this.callback.onAllDone = onAllDone;

        this.callback.onStart && this.callback.onStart(_id)
        console.log('start:::::', this.tasks.length);
        this.allTasksNum = this.tasks.length;

        // 获取cookie之后5s开始执行任务
        this._updateSogouCookie().then(function () {
            return self._retTimeout(null);
        }).then(function () {
            self._doTask();
        });
    };

    // 递归执行任务
    this._doTask = function () {
        var self = this;
        var starTime = Date.now();
        console.log('current status:', this.tasks.length);
        // 如果是暂停,延时后继续下一次轮训
        if (this.running === 2 || this.running === 0) {
            console.log('已停止或者暂停', '搜狗验证次数:', self.sougouVerifyCount, ', 微信验证次数:', self.weixinVerifyCount, '已完成账号:', self.complete.length);
            return;
        }

        var task = this.tasks.shift();
        this.currentTask = task;
        this.callback.onTaskStart && this.callback.onTaskStart(this._id, task, this.tasks.length);
        console.log('do task::', task);
        this._search(task).then(function (taskRes) {
            console.log('one task done::费时:', (Date.now() - starTime) / 1000, ', 还有:', self.tasks.length, ', 总时间:', (Date.now() - self.initTime) / 60000);
            self.complete.push(task);
            // 发送给服务器
            self.callback.onTaskDone && self.callback.onTaskDone(self._id, task, 'complete');
            self.sendTaskResult([task, taskRes]);
            // 一个账号成功, 更新cookie，延时后继续
            // null, self._randomTime(10 * 1000, 5 * 1000), true
            // 1484128909149 7
            return false
        }).catch(function (e) {
            if (e === 404) {
                console.log('账号未找到:', task);
                self.complete.push(task);

                self.callback.onTaskDone && self.callback.onTaskDone(self._id, task, 'notFound');
            } else if(e === 400){
                console.log('账号最近未发文', task);
                self.complete.push(task);

                self.callback.onTaskDone && self.callback.onTaskDone(self._id, task, 'complete');
            } else if(e === 302){
                console.log('需要填验证码', task);
                // 该任务需要重新执行
                self.tasks.push(task);
            }  else{
                self.failure.push(task);
                self.callback.onTaskDone && self.callback.onTaskDone(self._id, task, 'failure');
                // 记录一条失败, 延时后继续
                console.log('one task error:', e, (Date.now() - starTime) / 1000);
            }

            return true;
        }).then(function(isSleep){
            if (!self.tasks.length) {
                self.callback.onDone && self.callback.onDone(self._id, self.complete.length, self.failure.length);
                self.callback.onAllDone && self.callback.onAllDone(self._id, self.complete.length, self.failure.length);
                self._stop();
                return;
            }
            if (isSleep) {
                self._retTimeout(null, self._randomTime(10 * 1000, 5 * 1000), true).then(function () {
                    self._doTask();
                });
            } else {
                self._retTimeout().then(function () {
                    self._doTask();
                });
            }
        });
    };

    // 搜索账号
    this._search = function (task) {
        var self = this;
        return new Promise(function (resolve, reject) {
            // 按页递归查找，判断账号是否匹配
            function _doSearch(page) {
                console.log('search:page:', page);
                // 最大搜索页
                if (page >= 2) {
                    reject(404); // 没有找到账号
                    return;
                }

                // 暂停时直接结束
                if (self.running === 2 || self.running === 0) {
                    reject('pause-stop');
                    return;
                }
                self._searchPage(task.wx_alias || task.name, 0).then(function (res) {
                    // console.log('page res:', res);
                    // 解析当前搜索结果页中的账号列表
                    var info = self._parsePageAccounts(res);
                    if (!info.length) {
                        // 没有info则是302，被搜狗屏蔽了，更新cookie
                        return 302;
                    }

                    console.log('info::', info);
                    // 有wx_alias时，更具info列表来筛选出账号
                    if (task.wx_alias) {
                        var hasAccount = false;
                        info.forEach(function (item) {
                            if (item.account === task.wx_alias) {
                                hasAccount = item;
                            }
                        });
                        if (hasAccount) {
                            // 如果该账号最近未发文章则直接跳过
                            if (!hasAccount.lastLink || hasAccount.lastLink.indexOf('http') !== 0){
                                reject(400);
                                return;
                            }
                            console.log('find account by alias:');
                            // 当页列表中找到了账号，直接抓取该账号完整数据
                            return self.crawlAccountDetail(hasAccount);
                        }
                        return false;
                    }
                    // 递归info列表，获取搜索账号更多信息来判断是否有匹配的账号
                    return self._searchInfoList(info, task);
                }).then(function (accountRes) {
                    console.log('one page done.');
                    if (accountRes === 302) {
                        console.log('302');
                        // 如果出现验证码次数达到最大限制次数，则返回错误，继续下一个任务
                        if (self.sougouVerifyCount >= self.sougouMaxVerify) {
                            console.log('已达搜狗最大验证次数.');
                            reject(false);
                            return;
                        }
                        // 暂停，显示验证码页面
                        self.pause();
                        self.sougouVerifyCount++;
                        var url = 'http://weixin.sogou.com/antispider/?from=' + encodeURIComponent(self._makeSearchUrl(task.wx_alias || name, page));
                        if (self.verifyFrame) {
                            self._showVerify(url);
                        }
                        self.callback.onVerify && self.callback.onVerify(self._id, url);
                        reject(302);
                        return;
                    }
                    // 一页处理完了之后，还是没有账号，延时后下一页
                    if (!accountRes) {
                        self._retTimeout(null, 5 * 1000, true).then(function () {
                            _doSearch(page + 1);
                        });
                        return;
                    }
                    console.log('find account:has data');
                    resolve(accountRes);
                }).catch(function (e) {
                    reject(e);
                });
            }
            _doSearch(0);
        });
    };

    this._makeSearchUrl = function (kw, page) {
        return 'http://weixin.sogou.com/weixin?query=' + encodeURIComponent(kw) + '&_sug_type_=&_sug_=y&type=1&page=' + (page || 1) + '&ie=utf8';
    };

    this._searchPage = function (kw, page) {
        var getListUrl = this._makeSearchUrl(kw, page);
        return $proxy.get(getListUrl).then(function (res) {
            console.log('search:kw:', kw);
            var suvMatch = res.match(/wuid".*?"(.*?)"/);
            if (suvMatch) {
                console.log('get SUV:', suvMatch[1]);
            }
            return res;
        });
    };

    this._parsePageAccounts = function (html) {
        var $ = cheerio.load(html, { decodeEntities: false });
        var info = [];
        $('.news-list2>li').map(function (i, item) {
            var infoDom = $(item).find('.txt-box .info');
            var _info = {};
            // 微信号
            _info.account = $(infoDom).find('label').html();
            // 微信链接
            _info.url = $(item).find('.tit a').attr('href');
            // 月发文
            var _articleNum = parseInt($(infoDom).html().split('月发文')[1], 10);
            if (_articleNum) {
                _info.articleNum = _articleNum;
            }
            // 平均阅读
            var _readNum = parseInt($(infoDom).html().split('平均阅读')[1], 10);
            if (_readNum) {
                _info.readNum = _readNum;
            }
            var links = $(item).find('a');
            _info.lastLink = $(links[links.length - 1]).attr('href');
            info.push(_info);
            return null;
        });
        console.log('find info::');
        return info;
    };

    this._searchInfoList = function (info, task) {
        var self = this;
        return new Promise(function (resolve, reject) {
            function _doSearch() {
                if (!info.length) {
                    reject(404);
                    return;
                }

                // 暂停时直接结束
                if (self.running === 2 || self.running === 0) {
                    reject(false);
                    return;
                }

                var infoItem = info.shift();

                // 没有最后一盘文章的，直接跳过
                if (!infoItem.lastLink || infoItem.lastLink.indexOf('http') !== 0) {
                    self._retTimeout(null, 1000, true).then(function () {
                        _doSearch();
                    });
                    return;
                }
                // 先抓取一片文章，来判断账户的uin是否匹配
                self._getLastArticle(infoItem.lastLink).then(function (linkRes) {
                    console.log('lastlink::', linkRes.bizuin, linkRes.nick_name);
                    // 如果没有文章或者没有bizuin， 延时后继续找下一个账号
                    if (!linkRes || !linkRes.bizuin) {
                        self._retTimeout(null, 1000, true).then(function () {
                            _doSearch();
                        });
                        return;
                    }
                    // biz不匹配，延时后继续下一个
                    console.log(1);
                    if (window.atob(linkRes.bizuin) !== task.uin) {
                        console.log(2);
                        self._retTimeout(null, 1000, true).then(function () {
                            _doSearch();
                        });
                        return;
                    }
                    // 匹配到了账号, 获取完整的8篇文章
                    console.log('find account:');
                    self.crawlAccountDetail(infoItem, 8).then(function (accountMoreRes) {
                        resolve(accountMoreRes);
                    }).catch(function (e) {
                        console.log(e);
                        reject(false);
                    });
                }).catch(function (e) {
                    console.log(e);
                    reject(false);
                });
            }
            _doSearch();
        });
    };

    this._stop = function () {
        this.running = 0;
        // this.tasks = [];
        // this.allTasksNum = 0;
        // this.complete = [];
        // this.failure = [];
        console.log('all done.');
    };

    this.clear = function () {
        this.running = 0;
        this.tasks = [];
        this.allTasksNum = 0;
        this.complete = [];
        this.failure = [];
    };

    this._getSogouHeaders = function () {
        // TODO：每次只要更新cookie就能保证info获取正常，尝试用webview更新
        console.log('cooie::::', this.sogouCookiesStr1 + this.sogouCookiesStr2);
        // TODO：每次只要更新cookie就能保证info获取正常，尝试用webview更新
        return {
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Encoding': 'gzip, deflate, sdch',
            'Accept-Language': 'zh-CN,zh;q=0.8,en;q=0.6',
            'Cache-Control': 'no-cache',
            'Connection': 'keep-alive',
            'Cookie': '' + this.sogouCookiesStr1 + this.sogouCookiesStr2,
            'Host': 'weixin.sogou.com',
            'Pragma': 'no-cache',
            'Upgrade-Insecure-Requests': 1,
            'User-Agent': macAgent
        };
    };

    // 获取一个账号的更多详细
    this.crawlAccountDetail = function (item, articleCount) {
        var self = this;
        var url = item && item.url.replace(/&amp;/g, '&');
        console.log('account page::', url);
        return self._getAccountPage(url || '').then(function (res) {
            var accountData = self._getAccountPageContent(res, item);
            // 数据不完整，没有抓到
            if (!accountData.msgList) {
                if (self.weixinVerifyCount >= self.weixinMaxVerify) {
                    throw new Error('已达微信最大验证次数');
                }

                // 暂停任务，显示验证页面
                self.pause();
                self.weixinVerifyCount++;
                if (self.verifyFrame) {
                    self._showVerify(url);
                }
                self.callback.onVerify && self.callback.onVerify(self._id, url);
                throw new Error('账号页面被微信屏蔽');
            }
            // 延迟5秒去抓取文章数据
            return self._retTimeout(null, 5000, true).then(function () {
                return self.crawlEveryArticle(accountData, articleCount);
            }).then(function (articleRes) {
                accountData.articles = articleRes;
                return accountData;
            });
        });
    };

    // 获取微信账户首页
    this._getAccountPage = function (url) {
        // console.log('Req:', url);
        return $proxy.get(url);
    };

    this._getLastArticle = function (url) {
        console.log('last article url::', url);
        return this._getArticleJson(url.replace(/amp;/g, '') + '&f=json');
    };

    // 获取账户页面详情
    this._getAccountPageContent = function (res, item) {
        var $ = cheerio.load(res, { decodeEntities: false });
        var msgListMatch = res.match(/var msgList =(.*)/);
        var msgList = msgListMatch ? JSON.parse(msgListMatch[1].trim().match(/({.+});/)[1]) : [];
        var content = {
            info: item, // avatar name desc company
            articles: []
        };
        try {
            content.info.avatar = $('.radius_avatar img').attr('src');
            content.info.name = $('.profile_nickname').html().trim();
            content.info.desc = $('.profile_desc_value').eq(0).html();
            content.info.wx_verify = $('.icon_verify').length ? 1 : 0;
            var _html = $('.profile_desc_value').eq(1).html();
            var _company = _html.split('">')[1];
            if (_company) {
                content.info.company = _company;
            }
            content.msgList = msgList;
        } catch (e) {
            console.log('出现微信验证码了');
            console.log($('.weui_cell_hd').html());
        }
        return content;
    };

    this._updateSogouCookie = function () {
        return new Promise(function (resolve, reject) {
            $proxy.get('http://weixin.sogou.com/').then(function () {
                resolve();
            }).catch(function () {
                reject();
            });
        });
    };

    this._changeArticleUrl = function (url) {
        var temp = url.replace(/&amp;/g, '&').replace(/#wechat_redirect/g, '');
        if (temp) {
            if (!/http:\/\/mp\.weixin\.qq\.com/.test(temp)) {
                return 'http://mp.weixin.qq.com' + temp + '&f=json';
            }
            return temp + '&f=json';
        }
        return '';
    };

    // 获取一个账号下的8篇文章
    this.crawlEveryArticle = function (account, maxArticle) {
        var self = this;
        var resultAll = [];
        var sourceUrl = [];
        if (account.msgList && account.msgList.list.length) {
            account.msgList.list.forEach(function (msg) {
                sourceUrl.push(self._changeArticleUrl(msg.app_msg_ext_info.content_url));
                msg.app_msg_ext_info.multi_app_msg_item_list.forEach(function (msgItem) {
                    sourceUrl.push(self._changeArticleUrl(msgItem.content_url));
                });
            });
        }
        // 只获取8篇文章
        sourceUrl = sourceUrl.splice(0, maxArticle || 8);
        return new Promise(function (resolve, reject) {
            function __getArticle() {
                // 暂停时直接结束
                if (self.running === 2) {
                    reject(resultAll);
                    return;
                }
                var url = sourceUrl.shift();
                if (!url) {
                    resolve(resultAll);
                    return;
                }
                console.log('获取文章内容:', url, sourceUrl.length, account.info.account);
                self._getArticleJson(url).then(function (res) {
                    if (res.link) {
                        res.content_noencode = '';
                    } else if (url) {
                        res.link = url.split('&f=json')[0];
                    }
                    resultAll.push(res || {});
                    // console.log(res);
                    // 延时抓取下一篇文章
                    self._retTimeout(null, 500, true).then(function () {
                        __getArticle();
                    });
                }).catch(function (e) {
                    console.log('获取文章错误:', e);
                    // 如果出错，把已经抓取成功的文章返回;
                    resolve(resultAll);
                    self._stop();
                });
            }
            __getArticle();
        });
    };

    this._getArticleJson = function (url) {
        if (!url) {
            Promise.resolve({});
        }
        // 有些情况下_getArticleJson会一直卡住，没有响应，暂时不知道为啥
        // console.log('getArticleJson:', url);
        return new Promise(function (resolve, reject) {
            var t = setTimeout(function () {
                reject(false);
            }, 20 * 1000);
            return $proxy.get(url).then(function (resJson) {
                var htmlUrl = url.split('&f=json')[0];
                // console.log('Req::', htmlUrl);
                return $proxy.get(htmlUrl).then(function (resHtml) {
                    return {
                        resJson,
                        resHtml
                    };
                });
            }).then(function (res) {
                var sgData = {};
                if (res.resHtml.match(/window\.sg_data/)) {
                    sgData.src = res.resHtml.match(/src:"(.*?)"/)[1];
                    sgData.ver = res.resHtml.match(/ver:"(.*?)"/)[1];
                    sgData.timestamp = res.resHtml.match(/timestamp:"(.*?)"/)[1];
                    sgData.signature = res.resHtml.match(/signature:"(.*?)"/)[1];
                } else {
                    // 如果没有抓到阅读量和点赞
                    return res.resJson;
                }
                var commentUrl = 'http://mp.weixin.qq.com/mp/getcomment?src=' + sgData.src + '&ver=' + sgData.ver + '&timestamp=' + sgData.timestamp + '&signature=' + sgData.signature + '&&uin=&key=&pass_ticket=&wxtoken=&devicetype=&clientversion=0&x5=0';
                // console.log('req::', commentUrl);
                return $proxy.get(commentUrl).then(function (resComment) {
                    res.resJson.like_num = resComment.like_num;
                    res.resJson.read_num = resComment.read_num;
                    return res.resJson;
                });
            }).then(function (res) {
                clearTimeout(t);
                console.log('文章：：', res.title, res.like_num, res.read_num);
                return resolve(res);
            }).catch(function (e) {
                clearTimeout(t);
                console.log(e);
                reject(e);
            });
        });
    };

    this.getStatus = function () {
        return {
            allTasksNum: this.allTasksNum,
            currentTask: this.currentTask,
            complete: this.complete,
            failure: this.failure,
            tasks: this.tasks
        };
    };

    this.sendTaskResult = function (result) {
        // 保存任务
        console.warn('::::::::::::::saveTaskResult');
        var articles = result[1].articles;
        var info = result[1].info;
        var rawId = '';
        if (articles[0]) {
            info.originId = articles[0].user_name;
            rawId = articles[0].user_name;
        }
        var d = {
            raw_id: rawId,
            articles,
            info
        };
        return $proxy.post('http://api.wxb.com/client/saveback2', {
            t: 'following',
            d
        }).then(function (res) {
            console.warn('saved success');
            // console.warn(res);
            // console.warn(d);
        }).catch(function (e) {
            console.warn(e);
        });
    };

    // 暂停，只会暂停后续任务，当前已开始的任务不会暂停
    this.pause = function () {
        this.running = 2;
    };
    // 暂停后，重新启动
    this.reStart = function () {
        // 把上一个失败的重新加入任务
        // if (this.failure.length) {
        //     this.tasks = [this.failure.pop()].concat(this.tasks);
        // }
        this.running = 1;
        this._doTask();
    };

    this.sendWXVerifycode = function (code, cert) {
        return $proxy.post('http://mp.weixin.qq.com/mp/verifycode', {
            input: code,
            cert
        }).then(function (res) {
            console.warn(res);
            return res;
        });
    };
    this.getSGCode = function () {
        var time = Date.now();
        return $proxy.get('http://weixin.sogou.com/antispider/util/seccode.php?tc=' + time).then(function (res) {
            console.log('write code::', time);
            fs.writeFileSync('./1.jpg', res, {
                encoding: 'binary'
            });
            return time;
        });
    };
    this.sendSGVerifycode = function (code) {
        return $proxy.post('http://weixin.sogou.com/antispider/thank.php', {
            c: code,
            r: '',
            v: 5
        }).then(function (res) {
            fs.writeFileSync('./1.html', res, {
                encoding: 'binary'
            });
            console.log(res);
            return res;
        });
    };

    this.clearCookies = function () {
        var url = 'http://weixin.sogou.com';
        var win = require('nw.gui').Window.get();
        win.cookies.getAll({
            url
        }, function (cookies) {
            cookies.forEach(function (item) {
                win.cookies.remove({
                    url,
                    name: item.name
                });
            });
        });
    };

    this.getAllCookie = function () {
        var url = 'http://weixin.sogou.com';
        var win = require('nw.gui').Window.get();
        win.cookies.getAll({
            url
        }, function (cookies) {
            console.log(cookies);
        });
    };

    this._showVerify = function (url) {
        if (!this.verifyFrame) {
            return;
        }
        console.log('show verify.', url);
        this.verifyFrame.src = url;
        this.verifyFrame.style.display = 'block';
        var self = this;
        function _detect() {
            var doc = self.verifyFrame.contentDocument;
            console.log('detect in iframe....');
            if (doc.querySelector('.searchnav2') || doc.querySelector('.header-box') || doc.querySelector('.profile_info') || doc.querySelector('#page-content')) {
                // 已经验证通过
                self.verifyFrame.src = '';
                self.verifyFrame.style.display = 'none';
                self.reStart();
            } else {
                setTimeout(function () {
                    _detect();
                }, 200);
            }
        }
        _detect();
    };
}

// module.exports = Spider;
