(function (){
    var utils = baidu.editor.utils,
        UIBase = baidu.editor.ui.UIBase;
    var editorui = baidu.editor.ui;
    var dialog = editorui.Dialog;
    var buttons = editorui.buttons;
    var domUtils = UE.dom.domUtils;

    var extendDialogs = {
        'weixin-video': {
            title: '插入腾讯视频',
            iframeUrl: '~/dialogs/video/video.html'
        },
        'weixin-music': {
            title: '插入腾讯音乐',
            iframeUrl: '~/dialogs/music/music.html',
        }
    }

    Object.keys(extendDialogs).forEach(function(key){
        var item = extendDialogs[key];
        editorui[key] = function (editor) {
            var dialog = new editorui.Dialog({
                iframeUrl: editor.ui.mapUrl(item.iframeUrl),
                editor: editor,
                className: 'dialog-' + key,
                title: item.title,
                autoReset: true,
                draggable: true,
                fullscreen: false,
                closeDialog: editor.getLang("closeDialog"),
                buttons:[
                    {
                        className:'edui-okbutton',
                        label:editor.getLang("ok"),
                        editor:editor,
                        onclick:function () {
                            dialog.close(true);
                        }
                    },
                    {
                        className:'edui-cancelbutton',
                        label:editor.getLang("cancel"),
                        editor:editor,
                        onclick:function () {
                            dialog.close(false);
                        }
                    }
                ]
            });
            editor.ui._dialogs[key + "Dialog"] = dialog;

            var ui = new editorui.Button({
                className: 'tool-' + key,
                title: item.title,
                label: item.label || '',
                showText: item.showText,
                onclick:function () {
                    dialog.render();
                    dialog.open();
                },
                theme: editor.options.theme
            });
            editorui.buttons[key] = ui;
            return ui;
        };
    });

    var extendBtns = {
        'autosave-status': {
            title: '已开启自动保存',
            label: '自动保存',
            showText: true
        },
        'show-style': {
            title: '样式面板',
            label: '显示样式',
            showText: true,
            onclick: function(e){
                var el = $(this.target);
                console.log(el.attr('show'));
                if(el.attr('show')){
                    el.find('.edui-label').text('显示样式');
                    this.editor.fireEvent('closeStylePannel');
                    el.removeAttr('show');
                }else{
                    el.find('.edui-label').text('收起样式');
                    this.editor.fireEvent('showStylePannel');
                    el.attr('show', 'true');
                }
            }
        },
        // 扩展选择图片
        'show-image-select': {
            title: '插入图片',
            onclick: function(){
                //触发编辑器事件，让外部来处理
                this.editor.fireEvent('extendImageSelect');
            }
        },
        // 导入内容
        'import-page': {
            title: '导入内容',
            label: '导入内容',
            onclick: function(){
                //触发编辑器事件，让外部来处理
                this.editor.fireEvent('extendImportPage');
            }
        },
        // 仅视频
        'only-show-video': {
            title: '仅显示视频',
            label: '仅显示视频',
            onclick: function(){
                //触发编辑器事件，让外部来处理
                this.editor.fireEvent('extendOnlyShowVideo');
            }
        },
        // 微博视频
        'weibo-video': {
            title: '插入秒拍视频',
            onclick: function(){
                this.editor.fireEvent('extendWeiboVideoClick');
            }
        },
        // 简书视频
        'jianshu-video': {
            title: '插入视频',
            onclick: function(){
                this.editor.fireEvent('extendJianshuVideoClick');
            }
        },
        'insert-voice': {
            title: '插入语音',
            onclick: function(){
                //触发编辑器事件，让外部来处理
                this.editor.fireEvent('extendInsertVoice');
            }
        },
        // 一点资讯特殊标题
        'headline1': {
            title: '标题1',
            label: '标题1',
            onclick: function(){
                this.editor.fireEvent('extendHeadline1');
            }
        },
        'headline2': {
            title: '标题2',
            label: '标题2',
            onclick: function(){
                this.editor.fireEvent('extendHeadline2');
            }
        },
        'sohu-video': {
            title: '插入视频',
            onclick: function(){
                this.editor.fireEvent('extendSohuVideoClick');
            }
        }
    }

    Object.keys(extendBtns).forEach(function(key){
        var item = extendBtns[key];
        editorui[key] = function(editor){
            var ui = new editorui.Button(utils.extend({
                className: 'tool-' + key,
                theme: editor.options.theme,
                editor: editor
            }, item));
            editorui.buttons[key] = ui;
            return ui;
        }
    });

    // 扩展缩进
    function makeIndentCombox(uiName){
        //创建下拉菜单中的键值对，这里我用字体大小作为例子
        var items = [];
        for(var i= 0,ci;ci=[ 0.1,0.5, 1, 2, 3, 4][i++];){
            if (ci=='0.1') {ci='0'};
            items.push({
                //显示的条目
                label:' ' + ci,
                //选中条目后的返回值
                value:ci,
                //针对每个条目进行特殊的渲染
                renderLabelHtml:function () {
                    //这个是希望每个条目的字体是不同的

                    return '<div class="edui-label %%-label" style="text-align:center;line-height:2;font-size:12px;">' + (this.label || '') + '</div>';
                }
            });
        }
        return function(editor) {
            var combox = new UE.ui.Combox({
                //需要指定当前的编辑器实例
                editor:editor,
                className: 'tool-' + uiName,
                theme: editor.options.theme,
                //添加条目
                items:items,
                //当选中时要做的事情
                onselect:function (t, index) {
                    //拿到选中条目的值
                    editor.execCommand(uiName, this.items[index].value);
                },
                //提示
                title: '缩进',
                //当编辑器没有焦点时，combox默认显示的内容
                initValue: '缩进'
            });
            editorui.buttons[uiName] = combox;
            return combox;
        };
    }

    editorui['ex-indent'] = makeIndentCombox('ex-indent');

    UE.registerUI('ex-indent',function (editor,uiName) {
        var me = this;
        me.commands['margin'] = {
            execCommand : function(cmd,value) {
                 var me = this;
                 var value = me.queryCommandState("margin") ? "0em" : (me.options.indentValue || value);
                 me.execCommand('Paragraph','p',{style:'margin:'+ value});
            },
            queryCommandState : function() {
                var pN = domUtils.filterNodeList(this.selection.getStartElementPath(),'p h1 h2 h3 h4 h5 h6');
                return pN && pN.style.margin && parseInt(pN.style.margin) ?  1 : 0;
            }
        };

        editor.registerCommand(uiName, {
            execCommand:function(cmdName,value){
                //这里借用fontsize的命令
                this.execCommand('margin','0em '+value + "em");
                this.execCommand('justify', 'justify');
            },
            queryCommandValue:function(){
                //这里借用fontsize的查询命令
                return this.queryCommandValue('margin');
            }
        });
    });

    // 扩展搜狐的标题字体
    function makeFontsizeCombox(uiName){
        var items = [];
        items.push({
            label: '正文',
            value: 16,
            renderLabelHtml:function () {
                return '<div class="edui-label %%-label" style="text-align:center;line-height:1;font-size:16px;">正文</div>';
            }
        });
        items.push({
            label: '标题',
            value: 20,
            renderLabelHtml:function () {
                return '<div class="edui-label %%-label" style="text-align:center;line-height:1;font-size:20px;font-weight:bold;">标题</div>';
            }
        });
        return function(editor) {
            var combox = new UE.ui.Combox({
                editor:editor,
                className: 'tool-' + uiName,
                theme: editor.options.theme,
                items: items,
                onselect:function (t, index) {
                    editor.execCommand(uiName, this.items[index].value);
                },
                title: '字号',
                initValue: '正文'
            });
            editorui.buttons[uiName] = combox;
            return combox;
        };
    }

    editorui['sohu-fontsize'] = makeFontsizeCombox('sohu-fontsize');

    UE.registerUI('sohu-fontsize',function (editor,uiName) {
        var me = this;
        me.commands['sohu-fontsize-20'] = {
            execCommand : function(cmd,value) {
                var me = this;
                var range = this.selection.getRange();
                debugger;
            },
            queryCommandValue: function (cmdName) {
                var startNode = this.selection.getStart();
                var styleVal = domUtils.getComputedStyle(startNode, style),
                    tmp = /^([\d\.]+)(\w+)$/.exec( styleVal );
                if( tmp ) {
                    return Math.floor( tmp[1] ) + tmp[2];
                }
                return styleVal;
            },
            queryCommandState: function (cmdName) {
                return 0;
            }
        };
    });
})();
