(function(){
    domUtil = UE.dom.domUtils;
    utils = UE.utils;

    function makeGetter(editor){
        return function(name){
            return document.getElementById(editor.container.id + '_' + name);
        };
    }

    function removeStyle(e, list) {
        var style = e.getAttribute('style') || '';
        list.forEach(function (item) {
            var reg = new RegExp(item + ':.*[;]?');
            style = style.replace(reg, '');
        });
        e.setAttribute('style', style);
    }

    function setStyle(e, css) {
        var style = e.getAttribute('style');
        if (style) {
            style = style.split(';');
        } else {
            style = [];
        }
        Object.keys(css).forEach(item => {
            var reg = new RegExp(item + ':.*[;]?');
            style.forEach(function (it, k) {
                if (it.match(reg)) {
                    style.splice(k, 1);
                }
            })
            style.push(item + ': ' + css[item]);
        })
        e.setAttribute('style', style.join(';'));
    }

    function elementShow(e) {
        elemntDisplay(e, 'block');
    }

    function elementHide(e) {
        elemntDisplay(e, 'none');
    }

    function elemntDisplay(e, type) {
        var style = e.getAttribute('style') || '';
        style = style.replace(/display:.*[;]?/, '');
        style += 'display: ' + type;
        e.setAttribute('style', style);
    }

    function createExtendTitle(maxlength) {
        var div = document.createElement('div');
        div.setAttribute('class', 'editor-extend-title');
        var input = document.createElement('input');
        input.setAttribute('type', 'text');
        input.setAttribute('placeholder', '输入文章标题');
        div.appendChild(input);

        var length = document.createElement('em');
        length.setAttribute('class', 'extend-title-input-length');
        if (maxlength) {
            input.setAttribute('maxlength', maxlength);
            length.textContent = '0/' + maxlength;
            div.appendChild(length);
        }

        return {
            div,
            input,
            length
        };
    }

    function createAlert(text, type) {
        var div = document.createElement('div');
        div.setAttribute('class', 'ant-alert ant-alert-' + type);
        div.setAttribute('style', 'margin: 0;')
        var i = document.createElement('i');
        i.setAttribute('class', 'anticon anticon-exclamation-circle ant-alert-icon');
        var message = document.createElement('span');
        message.setAttribute('class', 'ant-alert-message');
        message.innerText = text;
        div.appendChild(i);
        div.appendChild(message);

        return div;
    }

    function createContentErrorAlert(message) {
        var div = document.createElement('div');
        div.setAttribute('id', 'editor-content-error-Alert');
        div.setAttribute('style', 'z-index: 9999;position: absolute;width: 100%;');
        div.appendChild(createAlert(message, 'warning'));

        return div;
    }

    UE.plugins['editor-extend'] = function(){
        var me = this;
        var getDom = makeGetter(this);
        me.commands['set-title-data'] = {
            execCommand : function( cmdName , val) {
                this.$$extendTitleInput.value = val;
                me.fireEvent('titleChange', val, me);
            }
        };

        //附加标题输入框
        me.addListener('ready', function(){
            this.$$toolbar = getDom('toolbarbox');
            this.$$iframeholder = getDom('iframeholder');
            var toolbarOffsetHeight = this.$$toolbar.offsetHeight;

            if (this.options.showTitle == false) {
                setStyle(this.$$iframeholder, { top: toolbarOffsetHeight + 'px' })
                me.fireEvent('readyAll');
                return;
            }

            var maxlength = me.options.titleLength ? parseInt(me.options.titleLength, 10) : null;
            var minlength = null;
            if (me.options.titleLength && me.options.titleLength.toString().match(/\//)) {
                var ls = me.options.titleLength.split('/');
                maxlength = parseInt(ls[1], 10);
                minlength = parseInt(ls[0], 10);
            }

            var titleObject = createExtendTitle(maxlength);
            this.container.insertBefore(titleObject.div, this.container.childNodes[1]);
            this.$$extendTitle = titleObject.div;
            this.$$extendTitleInput = titleObject.input;
            this.$$extendTitleInputLength = titleObject.length;
            this.$$extendTitleInput.addEventListener('keyup', function (e) {
                // var value = e.target.value;
                me.fireEvent('titleChange', e.target.value, me);
            });

            if (maxlength) {
                me.addListener('titleChange', function () {
                    var value = this.$$extendTitleInput.value;
                    if (maxlength) {
                        if (maxlength < value.length) {
                            this.$$extendTitleInput.value = value.slice(0, maxlength);
                            me.fireEvent('titleChange');
                            return;
                        }
                        me.$$extendTitleInputLength.textContent = value.length + '/' + maxlength;
                    }
                    if (minlength > value.length) {
                        setStyle(me.$$extendTitleInputLength, { color: 'red' })
                    } else {
                        removeStyle(me.$$extendTitleInputLength, ['color'])
                    }
                })
            }

            this.$$extendTitleInput.addEventListener('blur', function (e) {
                me.fireEvent('titleChangeEnd');
            })

            me.fireEvent('resize');
            me.fireEvent('readyAll');
        });
        me.addListener('editorShow', function() {
            me.show();
            me.fireEvent('resize');
        })
        me.addListener('resize', function() {
            var toolbarOffsetHeight = this.$$toolbar.offsetHeight;
            var extendTitleOffsetHeight = 0;
            var extendTitleOffsetWidth = 0;
            var extendTitleInputOffsetWidth = 0;
            if (this.$$extendTitle) {
                extendTitleOffsetHeight = this.$$extendTitle.offsetHeight;
                extendTitleOffsetWidth = this.$$extendTitle.offsetWidth;
                extendTitleInputOffsetWidth = this.$$extendTitleInput.offsetWidth;
                setStyle(this.$$extendTitle, { top: toolbarOffsetHeight + 'px' });
            }
            var contentErrorAlertHeight = this.$$contentErrorAlert ? this.$$contentErrorAlert.offsetHeight + 5 : 0;
            var iframeholderTop = toolbarOffsetHeight + extendTitleOffsetHeight + 5 + contentErrorAlertHeight;

            setStyle(this.$$iframeholder, { top: iframeholderTop + 'px' });
            if (this.$$contentErrorAlert) {
                setStyle(this.$$contentErrorAlert, {
                    top: toolbarOffsetHeight + extendTitleOffsetHeight + 5 + 'px',
                    padding: '0 ' + (extendTitleOffsetWidth - extendTitleInputOffsetWidth) / 2 + 'px'
                });
            }
        })

        me.addListener('contentWarning', function(event, message) {
            var alert = createContentErrorAlert(message);
            this.fireEvent('removeContentWarning');
            this.$$contentErrorAlert = alert;
            this.container.insertBefore(alert, this.container.childNodes[3]);
            this.fireEvent('resize');
        });

        me.addListener('removeContentWarning', function() {
            if (me.container && me.container.childNodes) {
                for (var i = 0; i < me.container.childNodes.length; i++) {
                    if (me.container.childNodes[i].getAttribute('id') === 'editor-content-error-Alert') {
                        me.container.removeChild(me.container.childNodes[i]);
                        me.fireEvent('resize');
                        me.$$contentErrorAlert = null;
                    }
                }
            }
        })
    };

    function clearNodeStyle(root){
        if(root.type == 'element'){
            if(root.children && root.children.length){
                utils.each(root.children,function(item){
                    clearNodeStyle(item);
                });
            }
            root.setAttr('style', '');
        }
    }

    function clearTextNbsp(root){
        if(root.type == 'element'){
            if(root.children && root.children.length){
                utils.each(root.children,function(item){
                    clearTextNbsp(item);
                });
            }
        }else if(root.type=='text'){
            root.data = root.data.replace(/\&[a-zA-Z]+;/g,'');
        }

    }

    function clearNodeTagName(root,tagName) {
        if(root.type === 'element'){
            if(root.children && root.children.length){
                utils.each(root.children,function (item) {
                    clearNodeTagName(item,tagName);
                });
            }
            if(root.tagName === tagName){
                toTextNode(root);
            }
        }
    }

    function clearNodeWithQQVideo(root) {
        if(root.type == 'element'){
            if(root.children && root.children.length){
                utils.each(root.children,function(item){
                    clearNodeWithQQVideo(item);
                });
            }
            if(root.tagName === 'iframe' && root.attrs.src &&root.attrs.src.indexOf('v.qq.com/iframe')){
                toTextNode(root);
            }
        }
    }

    function clearNodeIframeBackgroundImg(root) {
        if(root.type == 'element'){
            if(root.children && root.children.length){
                utils.each(root.children,function(item){
                    clearNodeIframeBackgroundImg(item);
                });
            }
            if(root.tagName === 'iframe' && root.attrs.class === 'video_iframe'){
                root.attrs.style = '';
            }
        }
    }


    function toTextNode(node, text){
        node.data = text || '';
        node.children = undefined;
        node.type = 'text';
        node.tagName = undefined;
        node.attrs = {};
        return node;
    }

    function toEmptyNode(node) {
        toTextNode(node, '');
    }
    var InputFilterMap = {
        'remove-style': function(root){
            utils.each(root.children,function(item){
                clearNodeStyle(item);
            });
        },
        'weibo-link': function(root){
            var aList = root.getNodesByTagName('a');
            utils.each(aList,function(item){
                var href = item.getAttr('href');
                if(href && href.indexOf('weibo.com/') > -1){

                }else{
                    console.log('not weibo link', item);
                    var text = item.innerText();
                    toTextNode(item, text);
                }
            });
        },
        'remove-image-webp': function(root) {
            var imgs = root.getNodesByTagName('img');
            utils.each(imgs, function(item){
                var src = item.getAttr('src');
                if (src) {
                    src = item.getAttr('src').replace(/tp=webp[&]?/ig, '');
                    item.setAttr('src', src);
                }
            })
        },
        'remove-image-local': function(root) {
            var imgs = root.getNodesByTagName('img');
            utils.each(imgs, function(item){
                if (item.getAttr('src') && item.getAttr('src').match(/^file:\/\//ig, '')) {
                    toEmptyNode(item);
                }
            })
        },
        'remove-nbsp':function(root) {
            utils.each(root.children,function(item){
                clearTextNbsp(item);
            });
        },
        'remove-iframe':function(root) {
            utils.each(root.children,function(item){
                clearNodeTagName(item,'iframe');
            });
        },
        'remove-qqVideo':function(root) {
            utils.each(root.children,function(item){
                clearNodeWithQQVideo(item);
            });
        },
        'remove-video':function(root) {
            utils.each(root.children,function(item){
                clearNodeTagName(item,'video');
            });
        },
        'remove-audio':function(root) {
            utils.each(root.children,function(item){
                clearNodeTagName(item,'audio');
                clearNodeTagName(item,'qqmusic');
            });
        },
        'remove-iframe-background-img':function(root) {
            utils.each(root.children,function(item){
                clearNodeIframeBackgroundImg(item);
            });
        },
        'set-mpvoice-attr': function(root){
            var l = root.getNodesByTagName('mpvoice');
            utils.each(l,function(item){
                var _src = item.getAttr('src');
                // console.log(_src);
                // if(_src.indexOf('http://mp.weixin') < 0){
                //     var bg = 'http://mp.weixin.qq.com' + _src;
                //     item.setAttr('src', bg);
                // }
                item.setAttr('data-name', decodeURIComponent(item.getAttr('name')));
                var time = parseInt(item.getAttr('play_length'), 10);
                item.setAttr('data-length', Math.floor(time/60000) + ':' + ( (time%60000)/1000) );
            });
        },
        'remove-gif': function(root) {
            var l = root.getNodesByTagName('img');
            utils.each(l,function(item){
                var _src = item.getAttr('src');
                var type = item.getAttr('data-type');
                if(type && type === 'gif') {
                    toEmptyNode(item);
                }
                if(_src && _src.match(/wx_fmt=gif/)){
                    toEmptyNode(item);
                }
                if (_src && _src.match(/\.gif/)) {
                    toEmptyNode(item);
                }
            });
        },
        'remove-weixin-vote': function(root) {
            var l = root.getNodesByTagName('vote_iframe');
            utils.each(l,function(item){
                toEmptyNode(item);
            });
            var voteSpan = root.getNodesByTagName('span');
            utils.each(voteSpan, function(item){
                if (item.getAttr('class') == 'vote_area') {
                    item.setAttr('class', '');
                }
            });
        },
        'remove-mpvoice': function(root) {
            var l = root.getNodesByTagName('mpvoice');
            utils.each(l,function(item){
                toEmptyNode(item);
            });
        },
        'replace-iframe-weixin': function(root) {
            var iframes = root.getNodesByTagName('iframe');
            utils.each(iframes, function(item){
                if (item.getAttr('class') == 'video' || (item.getAttr('class') == 'video_iframe' && !!!item.getAttr('data-src'))) {
                    const src = item.getAttr('src');
                    const vid = src.match(/vid=(\w*)/)[1];
                    item.parentNode.innerHTML('<iframe class="video_iframe" style="position:relative; z-index:1;" height="258" '
                        + 'width="345" frameborder="0" data-src="https://v.qq.com/iframe/preview.html?vid=' + vid + '" '
                        + 'allowfullscreen="" src="https://v.qq.com/iframe/preview.html?vid=' + vid + '&width=500&height=375&auto=0"></iframe><br/>');
                }
                if (item.getAttr('type') == 'music') {
                    const dataMusic = item.getAttr('data-music');
                    const info = JSON.parse(decodeURIComponent(dataMusic));
                    const music_name = info.songname;
                    const singer = info.singername;
                    item.parentNode.innerHTML('<qqmusic data-music="' + dataMusic + '" class="res_iframe qqmusic_iframe js_editor_qqmusic" '
                        + 'musicid="' + info.id + '" mid="' + info.mid + '" albumurl="' + info.albumurl + '" audiourl="' + info.m4a + '" '
                        + 'music_name="' + music_name + '" commentid="00111" singer="' + singer + '" '
                        + 'play_length="237000" src="/cgi-bin/readtemplate?t=tmpl/qqmusic_tmpl&amp;singer=' + encodeURIComponent(singer) + '&amp;music_name='
                        + encodeURIComponent(music_name) + '"></qqmusic>')
                }
            });
        },
        'replace-video-qq': function(root) {
            var iframes = root.getNodesByTagName('iframe');
            utils.each(iframes, function(item){
                if (item.getAttr('class') == 'video' || (item.getAttr('class') == 'video_iframe' && !!item.getAttr('data-src'))) {
                    const src = item.getAttr('src');
                    const vid = src.match(/vid=(\w*)/)[1];
                    item.parentNode.innerHTML('<iframe class="video_iframe" height="375" width="500" frameborder="0" '
                        + 'src="http://v.qq.com/iframe/preview.html?vid=' + vid + '&width=500&height=375&auto=0" '
                        + 'scrolling="no" allowfullscreen=""></iframe>');
                }
            });
        },
        'replace-video-omqq': function(root) {
            var iframes = root.getNodesByTagName('iframe');
            utils.each(iframes, function(item){
                if (item.getAttr('class') == 'video_iframe') {
                    const src = item.getAttr('src');
                    const vid = src.match(/vid=(\w*)/)[1];
                    item.parentNode.innerHTML('<iframe class="video" type="video" vid="' + vid + '" f="no" height="270" '
                        + 'width="480" frameborder="0" src="https://v.qq.com/iframe/preview.html?vid=' + vid + '&width=480&height=270&auto=0" '
                        + 'allowfullscreen=""></iframe>');
                }
            });
        },
        'replace-music-omqq': function(root) {
            var musics = root.getNodesByTagName('qqmusic');
            utils.each(musics, function(item){
                const dataMusic = item.getAttr('data-music');
                const id = item.getAttr('musicid');
                const musicname = item.getAttr('music_name');
                const musicinfo = item.getAttr('singer');
                item.parentNode.setAttr('class', 'empty');
                item.parentNode.innerHTML('<iframe data-music="' + dataMusic + '" class="music" type="music" '
                    + 'id="' + id + '" f="no" frameborder="0" '
                    + 'src="https://mats.gtimg.com/om/om_2.0/libs/ueditor/iframe/music20160714.html?musicid=' + id
                    + '&musicname=' + encodeURIComponent(musicname) + '&musicinfo=' + encodeURIComponent(musicinfo)
                    + '" allowfullscreen="false" style=" width:90%;height: 38px;"></iframe>')
            })
        },
        'clear-image-style': function(root) {
            var images = root.getNodesByTagName('img');
            utils.each(images, function(item){
                var style = item.getAttr('style');
                if (style) {
                    var matchWidth = style.match(/width:[^\d]*(\d*)[^\d]*?;/);
                    if(matchWidth && matchWidth[1]) {
                        if (parseInt(matchWidth[1]) > 640) {
                            style = style.replace(/width:.*?;/, '').replace(/height:.*?;/, '');
                            style += 'width:auto !important;max-width:100% !important;height:auto !important;';
                            item.setAttr('style', style);
                        }
                    } else {
                        style = style.replace(/width:.*?;/, '').replace(/height:.*?;/, '');
                        style += 'width:auto !important;max-width:100% !important;height:auto !important;';
                        item.setAttr('style', style);
                    }
                }
            })
        }
    }

    UE.plugin.register('content-filter', function (){
        return {
            bindEvents:{
                'ready':function(){

                }
            },

           outputRule: function(root){

           },

           inputRule:function(root){
              const me = this;
               if(this.options.inputFilter){
                   this.options.inputFilter.forEach(function(item){
                       console.log(item);
                       if(InputFilterMap[item]){
                           InputFilterMap[item](root);
                       }
                   });
               }
           },

           commands:{

           }
        }
    });

    // 图片地址映射
    // UE.plugin.register('imgsr-map', function (){
    //     return {
    //        outputRule: function(root){
    //
    //        },
    //        inputRule:function(root){
    //            var imgs = root.getNodesByTagName('img');
    //            utils.each(imgs,function(item){
    //                var src = item.getAttr('src');
    //                if(src.indexOf('mmbiz') > 0){
    //                    var _src = src.replace(/^https?:\/\/mmbiz\.(?:qlogo|qpic)\.cn/, 'http://mmbiz-qpic-cn.weituibao.com');
    //                    item.setAttr('src', _src);
    //                }
    //            });
    //        },
    //        commands:{
    //
    //        }
    //     }
    // });

})();
