/**
 * ueditor完整配置项
 * 可以在这里配置整个编辑器的特性
 */
(function () {


    var URL = window.UEDITOR_HOME_URL || getUEBasePath();

    /**
     * 配置项主体。注意，此处所有涉及到路径的配置别遗漏URL变量。
     */
    window.UEDITOR_CONFIG = {
        UEDITOR_HOME_URL: URL,
        serverUrl: URL + "ueditor.serverUrl.json",
        themePath: URL+"themes-custom/",
        iframeCssUrl: URL+'themes-custom/default/iframe.css',
        enableAutoSave: false,//启用自动保存 -- 这个配置项无效 坑爹
        saveInterval: 1000 * 60 * 60 * 24


    };

    function getUEBasePath(docUrl, confUrl) {

        return getBasePath(docUrl || self.document.URL || self.location.href, confUrl || getConfigFilePath());

    }

    function getConfigFilePath() {

        var configPath = document.getElementsByTagName('script');

        return configPath[ configPath.length - 1 ].src;

    }

    function getBasePath(docUrl, confUrl) {

        var basePath = confUrl;


        if (!/^([a-z]?)+-+([a-z]?)+:\/\//.test(confUrl)) { // 修改UE-editor文件引入

            if (/^(\/|\\\\)/.test(confUrl)) {

                basePath = /^.+?\w(\/|\\\\)/.exec(docUrl)[0] + confUrl.replace(/^(\/|\\\\)/, '');

            } else if (!/^[a-z]+:/i.test(confUrl)) {

                docUrl = docUrl.split("#")[0].split("?")[0].replace(/[^\\\/]+$/, '');

                basePath = docUrl + "" + confUrl;

            }

        }

        return optimizationPath(basePath);

    }

    function optimizationPath(path) {

        var protocol = /^([a-z]?)+-+([a-z]?)+:\/\//.exec(path),
            tmp = null,
            res = [];

        protocol = protocol ? protocol[0] : '';

        path = path.replace(protocol, "").split("?")[0].split("#")[0];

        path = path.replace(/\\/g, '/').split(/\//);

        path[ path.length - 1 ] = "";

        while (path.length) {

            if (( tmp = path.shift() ) === "..") {
                res.pop();
            } else if (tmp !== ".") {
                res.push(tmp);
            }

        }
        console.log('protocol::', protocol)
        return protocol + res.join("/");

    }

    window.UE = {
        getUEBasePath: getUEBasePath
    };

})();
