/**
 * Created by zhouxiaobo on 16/6/6.
 */
var getFileType = require('./fileType');
/**
 * 根据options格式 转换出 protocol://hostname:port/path
 * @param options
 * @returns {string}
 */
module.exports.url_format = function (options) {
    var uri = (options.protocol || "http:") + "//" + (options.hostname || options.host);
    if (options.port) {
        uri += ':' + options.port;
    }
    uri += (options.path || '/');
    return uri;
};

/**
 * 尝试转换为int
 * @param number
 * @returns {Number}
 */
module.exports.tryToInt = function (number) {
    return isNaN(number) ? number : parseInt(number, 10);
};

/**
 * 返回各种格式的时间
 * @param timestamp
 * @returns {{timestamp: (number|*), ret: string, seeRet: string, fullRet: string}}
 */
module.exports.dateParse = function dateParse(timestamp) {
    timestamp = timestamp ? timestamp : Date.now();
    var getDate = new Date(timestamp);
    var D = {};
    D.year = getDate.getFullYear();
    D.month = getDate.getMonth() + 1;
    D.date = getDate.getDate();
    D.hour = getDate.getHours();
    D.min = getDate.getMinutes();
    D.sec = getDate.getSeconds();
    var array = ["month", "date", "hour", "min", "sec"];
    for (var i = 0; i < array.length; i++) {
        var num = array[i];
        if (D[num] < 10) {
            D[num] = '0' + D[num];
        }
    }
    var ret = D.year + '' + D.month + '' + D.date;
    var seeRet = D.year + '-' + D.month + '-' + D.date;
    var fullRet = seeRet + ' ' + D.hour + ':' + D.min + ':' + D.sec;
    return {
        timestamp: timestamp,
        ret: ret,
        seeRet: seeRet,
        fullRet: fullRet
    };
}
/**
 * 获取url的一个参数
 * @param url
 * @param key
 * @returns {*}
 */
module.exports.getParam = function getParam(url, key) {
    url = url ? url : '';
    var temp = url.split('?')[1].split('&');
    for (var i = 0; i < temp.length; i++) {
        var obj = temp[i];
        var pos = obj.search('=');
        if (obj.substr(0, pos) === key) {
            return obj.substr(pos + 1);
        }
    }
    return '';
}

/**
 * 生成随机数
 * @param start
 * @param end
 * @returns {number}
 */
module.exports.random = function random(start, end) {
    return Math.floor(Math.random() * (end - start) + start);
}

/**
 * 判断是否为手机号
 * @param value
 * @returns {boolean}
 */
module.exports.isMobile = function (value) {
    value += '';
    var length = value.length;
    var rule = /^1[3-8][0-9]{9}$/;
    return length === 11 && rule.test(value);
};


module.exports.base64ToBin = base64ToBin;
/**
 * base64 转化为buffer
 * @param base64Data
 * @returns {Buffer}
 */
function base64ToBin(base64Data) {
    var img = new Buffer(base64Data, 'base64');
    return img;
}


module.exports.binToBase64 = binToBase64;
/**
 *
 * @param binData
 * @returns {{ext, mime}}
 */
function binToBase64(binData) {
    var img = new Buffer(binData, 'binary').toString('base64');
    var fileInfo = getFileType(binData);
    fileInfo.data = 'data:' + fileInfo.mime + ';base64,' + img
    return fileInfo;
}

module.exports.compressImage = function (fileData) {
    var maxPiexl = 4000000;//最大400万像素
    var fileInfo = binToBase64(fileData)
    var oldImage = document.createElement('img');
    oldImage.src = fileInfo.data;
    var naturalWidth = oldImage.naturalWidth;
    var naturalHeight = oldImage.naturalHeight;
    var overNum = naturalWidth * naturalHeight / maxPiexl;
    if (overNum >= 1) {
        naturalWidth = naturalWidth / overNum;
        naturalHeight = naturalHeight / overNum;
        var cvs = document.createElement('canvas');
        cvs.width = naturalWidth;
        cvs.height = naturalHeight;
        cvs.getContext("2d").drawImage(oldImage, 0, 0, naturalWidth, naturalHeight);
        fileInfo.data = cvs.toDataURL('image/jpeg', 50 / 100);
    }
    fileInfo.data = base64ToBin(fileInfo.data.match(/^data:([A-Za-z-+\/]+);base64,(.+)$/)[2]);
    return fileInfo;
}
/**
 * 禁止拖拽文件进客户端， 防止页面被顶掉
 * @param window
 */
module.exports.disableDragIn = function (window) {
    window.ondragover = function (e) {
        e.preventDefault();
        return false
    };
    window.ondrop = function (e) {
        e.preventDefault();
        return false
    };
}


/**
 * 处理键盘事件 禁止后退键（Backspace）密码或单行、多行文本框除外
 * @param e
 * @returns {boolean}
 */
module.exports.banBackSpace = function (e) {
    var ev = e || window.event;//获取event对象
    var obj = ev.target || ev.srcElement;//获取事件源

    var t = obj.type || obj.getAttribute('type');//获取事件源类型

    //获取作为判断条件的事件类型
    var vReadOnly = obj.getAttribute('readonly');
    var vEnabled = obj.getAttribute('enabled');
    //处理null值情况
    vReadOnly = (vReadOnly == null) ? false : vReadOnly;
    vEnabled = (vEnabled == null) ? true : vEnabled;

    //当敲Backspace键时，事件源类型为密码或单行、多行文本的，
    //并且readonly属性为true或enabled属性为false的，则退格键失效
    var flag1 = (ev.keyCode === 8 && (t === "password" || t === "number" || t === "text" || t === "url" || t === "search" || t === "textarea")
    && (vReadOnly === true || vEnabled !== true)) ? true : false;

    //当敲Backspace键时，事件源类型非密码或单行、多行文本的，则退格键失效
    var flag2 = (ev.keyCode === 8 && t !== "password" && t !== "number" && t !== "text" && t !== "url" && t !== "search" && t !== "textarea")
        ? true : false;

    //判断
    if (flag2) {
        return false;
    }
    if (flag1) {
        return false;
    }
}