const mflow = require('./server/modules/mflow');
const os = require('os');

const mserver = new mflow();
// 加入nwjs环境的参数
mserver.manifest = require('./package.json');
mserver.homeDir = './';
mserver.materialDir = `${os.homedir()}/.wxb_muti`;

// 加入protected目录下的api
mserver.WxbApi = require('./protected/WxbApi');
mserver.PlatformApi = require('./protected/PlatformApi');
mserver.PlatformApi.TouTiao = require('./protected/PlatformApi.TouTiao');
mserver.PlatformApi.JianShu = require('./protected/PlatformApi.JianShu');
mserver.PlatformApi.OMQQ = require('./protected/PlatformApi.OMQQ');
mserver.PlatformApi.QQ = require('./protected/PlatformApi.QQ');
mserver.PlatformApi.SoHu = require('./protected/PlatformApi.SoHu');
mserver.PlatformApi.OMQQ = require('./protected/PlatformApi.OMQQ');
mserver.PlatformApi.SoHu = require('./protected/PlatformApi.SoHu');
mserver.PlatformApi.TouTiao = require('./protected/PlatformApi.TouTiao');
mserver.PlatformApi.UC = require('./protected/PlatformApi.UC');
mserver.PlatformApi.WeiBo = require('./protected/PlatformApi.WeiBo');
mserver.PlatformApi.WeiXin = require('./protected/PlatformApi.WeiXin');
mserver.PlatformApi.YiDianZiXun = require('./protected/PlatformApi.YiDianZiXun');
mserver.PlatformApi.ZhiHu = require('./protected/PlatformApi.ZhiHu');
mserver.VUtil = require('./protected/Util');

// cookie操作暂时无法引入
// mserver.Cookie = {
//     getCookies: V.Util.getCookies,
//     removeCookies: V.Util.removeCookies,
//     removeCookie: V.Util.removeCookie,
//     setCookie: V.Util.setCookie,
//     setCookies: V.Util.setCookies
// };

// 初始化其它配置项
require('./server/modules/appconfig')(mserver);
require('./server/model')(mserver).then(() => {
    require('./server/modules/data-collection')(mserver);
    require('./server/modules/monitor')(mserver);
});

// 错误日志上传
require('./server/modules/error-log')(mserver);
mserver.use(require('./server/modules/message-parse'));
mserver.use(require('./server/modules/article-prepare'));
// message路由
mserver.use(require('./server/router').routes());

module.exports = mserver;
