(function (window) {
    const mflow = require('./server/modules/mflow');
    const mserver = new mflow();
    console.log('mserver init:', mserver);

    // // 判断数据库加载完成
    mserver.dbOnReady = (callback) => {
        if (mserver.dbReady) {
            callback();
            return;
        }
        mserver.on('dbready', callback);
    };

    // 加入nwjs环境的参数
    mserver.manifest = nw.App.manifest;
    mserver.homeDir = process.env.HOME || (process.env.HOMEDRIVE + process.env.HOMEPATH);
    mserver.materialDir = `${mserver.homeDir}/.wxb_muti`;
    // 加入protected目录下的api
    const apiList = ['AccountService', 'ArticleService',
        'SyncHistoryService', 'LocalImageService', 'PlatformApi', 'WxbApi', 'Util'];
    apiList.forEach(name => {
        // 编辑器窗口打开时偶尔
        mserver[name] = window[name] || window.opener[name];
    });
    require('./server/modules/watch')(mserver);
    require('./server/modules/wxbapi')(mserver.WxbApi);
    // 初始化其它配置项
    require('./server/modules/appconfig')(mserver);
    // 注入数据库
    require('./server/model')(mserver).then(() => {
        require('./server/modules/data-collection')(mserver);
        require('./server/modules/monitor')(mserver);
    });
    // 错误日志上传
    require('./server/modules/error-log')(mserver);
    // require('./server/modules/weixin-spider')(mserver);
    require('./server/modules/sogou-spider')(mserver);
    require('./server/modules/body-cache')(mserver);

    mserver.use(require('./server/modules/message-parse'));
    mserver.use(require('./server/modules/article-prepare'));
    // message路由
    mserver.use(require('./server/router').routes());

    window.MServer = mserver;
    console.log('mserver ready.');

    // UI层的error记录
    window.onerror = function (err) {
        MServer.sendMessage('/log/send', {
            log: err
        });
    };
})(window);
