const co = require('co');
const fetch = require('fetch');
const platform = require('../config/platform');
const AccountModel = require('../model/Account');
const AppConfigModel = require('../model/AppConfig');
const needle = require('needle');
const cheerio = require('cheerio');
needle.defaults({
    open_timeout: 1000 * 60 * 20,
    user_agent: 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) '
        + 'AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36'
});

function cookieToMap(list) {
    const _res = {};
    list.forEach(function (item) {
        if (item.name && item.value) {
            _res[item.name] = item.value;
        }
    });
    return _res;
}

function splitCookies(str) {
    const res = [];
    str.split(';').forEach(item => {
        const _str = item.split('=');
        const o = {
            name: _str[0].trim(),
            value: _str.splice(1, _str.length - 1).join('=')
        };
        res.push(o);
    });
    return res;
}

module.exports = {
    initState: co.wrap(function*(ctx, next) {
        // const { app } = ctx;
        // const response = yield app.AccountService.getAccountList('all');
        const response = yield AccountModel.getAccountList();
        const list = [];
        const detail = {};
        const detailList = [];
        const platformCount = {}; // 已有账号的平台列表

        for (let i = 0; i < response.rows.length; i++) {
            const row = response.rows[i];
            const doc = row.doc;
            doc.data._id = doc._id;
            doc.data._rev = doc._rev;
            detail[row.id] = doc;
            detailList.push(doc);
            if (platformCount[doc.type]) {
                platformCount[doc.type]++;
            } else {
                platformCount[doc.type] = 1;
            }
        }
        // a-b < 0, a在前
        detailList.sort(function (a, b) {
            return -((a.data.order || 0) - (b.data.order || 0));
        });
        detailList.map(function (item) {
            return list.push(item._id);
        });
        ctx.body = {
            list,
            detail,
            detailList,
            platformCount
        };
        yield next();
    }),
    parseCookie: co.wrap(function*(ctx, next) {
        const userInfo = ctx.message.userInfo;
        const ck = userInfo.cookies;
        const platfromInfo = platform[userInfo.type];
        let cookies = [];
        Object.keys(ck).forEach(key => {
            if (key.indexOf(platfromInfo.cookieDomain) > -1) {
                cookies = cookies.concat(splitCookies(ck[key]));
            }
        });
        userInfo.cookiesMap = cookieToMap(cookies);
        yield next();
    }),
    parseWeixinInfo: co.wrap(function*(ctx, next) {
        const userInfo = ctx.message.userInfo;
        if (userInfo.type != 'weixin') {
            yield next();
            return;
        }
        ctx.log('set weixin');
        const ckMap = userInfo.cookiesMap;
        userInfo.avatar = `http://open.weixin.qq.com/qr/code/?username=${ckMap.ticket_id}`;
        userInfo.uid = ckMap.slave_user;
        userInfo.unid = ckMap.data_bizuin;
        const res = yield ctx.app.PlatformApi.WeiXin.getUserInfo(userInfo.token, userInfo.cookiesMap);
        const resUser = res.user_info;
        const nav = res.base_resp.nav.nav_items[0].nav_item;
        let hasMsgcopyright = false;
        nav.forEach(item => {
            if (item.id == 10042) {
                hasMsgcopyright = true;
            }
        });
        console.log('weixin user::', resUser);
        userInfo.hasMsgcopyright = hasMsgcopyright;
        userInfo.username = resUser.nick_name;
        userInfo.is_verify = !!resUser.is_wx_verify;
        userInfo.ticket = res.base_resp.media_ticket;
        userInfo.ticket_id = resUser.user_name;
        yield next();
    }),

    parseQQInfo: co.wrap(function* (ctx, next) {
        const userInfo = ctx.message.userInfo;
        if (userInfo.type != 'qq') {
            yield next();
            return;
        }
        const ckMap = userInfo.cookiesMap;
        if (ckMap.ptui_loginuin) {
            userInfo.uid = ckMap.ptui_loginuin;
        } else if (ckMap.uin) {
            userInfo.uid = ckMap.uin.match(/[1-9]\d*/)[0];
        }
        ctx.log('set qq');
        ctx.log(userInfo.uid);
        yield next();
    }),

    // parseJianShuInfo: co.wrap(function* (ctx, next) {
    //     const userInfo = ctx.message.userInfo;
    //     if (userInfo.type != 'jianshu') {
    //         yield next();
    //         return;
    //     }
    //     const info = yield ctx.app.PlatformApi.JianShu.getStatistics(userInfo.cookiesMap, userInfo.uid);
    //     userInfo.username = info.account_name;
    //     userInfo.avatar = info.avatar;
    //     ctx.log('set jianshu');
    //     yield next();
    // }),

    parseYiDianInfo: co.wrap(function* (ctx, next) {
        const userInfo = ctx.message.userInfo;
        if (userInfo.type != 'yidianzixun') {
            yield next();
            return;
        }
        const info = yield ctx.app.PlatformApi.YiDianZiXun.getUserInfo(userInfo);
        userInfo.uid = info.uid;
        ctx.log('set yidian');
        yield next();
    }),
    // parseBaiJiaInfo: co.wrap(function* (ctx, next) {
    //     const userInfo = ctx.message.userInfo;
    //     if (userInfo.type != 'baijiahao') {
    //         yield next();
    //         return;
    //     }
    //     userInfo.uid = userInfo.cookiesMap.BAIDUID;
    //     ctx.log('set baijiahao');
    //     yield next();
    // }),

    save: co.wrap(function* (ctx, next) {
        const app = ctx.app;
        const message = ctx.message;
        const userInfo = message.userInfo;
        const ckMap = userInfo.cookiesMap;
        const platfromInfo = platform[userInfo.type];
        if (!userInfo.uid && platfromInfo.cookieUidKey) {
            userInfo.uid = ckMap[platfromInfo.cookieUidKey];
        }
        if (!userInfo.uid) {
            throw new Error('缺少uid');
        }
        console.log('userInfo::::::', userInfo);
        ctx.log('userInfo完成');
        let exist;
        let body;
        // 平台之间uid冲突概率和同平台uid冲突一样低
        const uid = userInfo.uid;
        try {
            // exist = yield app.AccountService.getAccount(id);
            exist = yield AccountModel.findOne({
                uid
            });
        } catch (e) {
            console.log(e);
            // 查询获取不到时，会抛出异常
        }
        // 兼容头条 m + uid
        if (userInfo.type === 'toutiao' && !exist) {
            try {
                let _uid = '';
                if (!uid.includes('m')) {
                    _uid = `m${uid}`;
                } else {
                    _uid = uid.replace('m', '');
                }
                exist = yield AccountModel.findOne({
                    uid: _uid
                });
            } catch (e) {
                console.log(e);
                // 查询获取不到时，会抛出异常
            }
        }
        if (exist) {
            ctx.log('已存在');
            userInfo.order = exist.order;
            // 登录用的账号和密码如果当前获取的信息里没有的话不能覆盖原来的
            userInfo.account = userInfo.account || exist.account || '';
            // 密码加密保存
            userInfo.password = userInfo.password
                ? app.WxbApi.encodeForCloud(userInfo.password)
                : (exist.password || '');

            userInfo.loginTime = new Date();
            // body = yield app.AccountService.updateAccount(id, userInfo);
            body = yield AccountModel.updateAccount(uid, userInfo);
            body.action = 'update';
        } else {
            ctx.log('不存在');
            userInfo.order = Date.now();
            userInfo.password = userInfo.password ? app.WxbApi.encodeForCloud(userInfo.password) : '';
            userInfo.loginTime = new Date();
            userInfo.createTime = new Date();
            // body = yield app.AccountService.addAccount(userInfo.type, userInfo.uid, userInfo);
            console.log('baocun:::', userInfo);
            body = yield AccountModel.addAccount(userInfo);
            body.action = 'add';
        }
        ctx.log('保存成功');
        console.log('baocun:::', body);
        ctx.body = body;
        yield next();
    }),

    // 数据库相关方法
    // 转移数据，后期可以移除
    migrationData: co.wrap(function* (ctx, next) {
        ctx.log('数据迁移：migrationData');
        const accountList = yield ctx.app.AccountService.getAccountList('all');
        let appConfig = yield AppConfigModel.findOne({});
        appConfig = appConfig ? appConfig.toJSON() : {};
        if (accountList.total_rows > 0 && !appConfig.migrationAccountTag) {
            const plist = accountList.rows.map(a => {
                // fix weixin type
                const data = a.doc.data;
                data.type = a.doc.data.type || a.doc.type;
                return AccountModel.addAccount(data);
            });
            yield Promise.all(plist);

            // 在nedb中标记已迁移状态
            appConfig.migrationAccountTag = true;
            console.warn('-----------account');
            yield AppConfigModel.findOneAndUpdate({
                _id: appConfig._id
            }, appConfig);
        }
        yield next();
    }),
    getAccount: co.wrap(function* (ctx, next) {
        // TODO: 缺少id？
        ctx.body = yield AccountModel.getAccount();
        yield next();
    }),
    getAccountList: co.wrap(function* (ctx, next) {
        const rows = yield AccountModel.getAccountList();

        ctx.body = {
            rows
        };
        yield next();
    }),
    deleteAccount: co.wrap(function* (ctx, next) {
        const id = ctx.message.id;
        yield AccountModel.deleteOne({
            _id: id
        });
        yield next();
    }),
    deleteAllAccount: co.wrap(function* (ctx, next) {
        yield AccountModel.deleteMany({});
        yield next();
    }),
    updateAccount: co.wrap(function* (ctx, next) {
        yield AccountModel.updateAccount(ctx.message.id, ctx.message.data);
        yield next();
    }),
    saveToLocal: co.wrap(function* (ctx, next) {
        const accounts = [];
        const cloudAccountList = ctx.message.data;
        while (cloudAccountList.length) {
            const oneCloudAccount = cloudAccountList.pop();
            const uid = oneCloudAccount.uid;
            let currentAccount = yield AccountModel.findOne({ uid });
            // 头条针对Uid做一层兼容
            if (!currentAccount && oneCloudAccount.type === 'toutiao') {
                let _uid = uid;
                if (!uid.includes('m')) {
                    _uid = `m${uid}`;
                } else {
                    _uid = uid.replace('m', '');
                }
                currentAccount = yield AccountModel.findOne({ uid: _uid });
            }
            if (currentAccount) {
                currentAccount = yield AccountModel.findOneAndUpdate({ uid }, oneCloudAccount);
            } else {
                currentAccount = yield AccountModel.create(oneCloudAccount).save();
            }
            accounts.push(currentAccount);
            console.warn(currentAccount);
        }
        ctx.body = {
            accounts
        };
        yield next();
    }),
    getLoginStatusList: co.wrap(function* (ctx, next) {
        const uidList = ctx.message.uidList;
        const accounts = yield AccountModel.getAccountList();
        const accountsMap = {};
        accounts.forEach(item => {
            accountsMap[item.uid] = item;
        });
        // 判断全部本地账号
        let accountList = accounts;
        const resMap = {};
        const tokenMap = {};
        // 判断传入账号
        if (uidList && uidList[0]) {
            accountList = [];
            uidList.forEach(uid => {
                accountList.push(accountsMap[uid]);
            });
        }
        const plist = [];
        accountList.forEach((item) => {
            if (!item.cookiesMap) {
                resMap[item.uid] = false;
            } else {
                const _home = platform[item.type].home;
                const _cookies = item.cookiesMap;
                // needle带上cookie请求各个平台
                const options = {
                    cookies: _cookies,
                    parse: true,
                    follow_max: 2,
                    timeout: 20000
                };

                const agent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5)' +
                    '  AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36';
                switch (item.type) {
                case 'omqq': {
                    plist.push(fetch.getHtml(platform[item.type].home, '', {
                        cookies: fetch.objectToArray(_cookies),
                        headers: {
                            'User-Agent': agent,
                            Referer: platform[item.type].home,
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    }).then((response) => {
                        const _$ = cheerio.load(response, { decodeEntities: false });
                        resMap[item.uid] = !!_$('.Fname').eq(0).text();
                    }));
                    break;
                }
                case 'zhihu': {
                    const _options = {
                        headers: {
                            Cookie: item.cookies['www.zhihu.com']
                        }
                    };
                    plist.push(new Promise(function (resolve) {
                        needle.get(_home, _options, function (err, resp) {
                            const _$ = cheerio.load(resp.body, { decodeEntities: false });
                            resMap[item.uid] = !!_$('.zu-top-nav-userinfo .name').text();
                            resolve();
                        });
                    }));
                    break;
                }
                default:
                    plist.push(new Promise(function (resolve) {
                        needle.get(_home, options, function (err, resp) {
                            try {
                                const $ = cheerio.load(resp.body, { decodeEntities: false });
                                // 判断请求返回页面是否有登录后的元素，可以参考lister中的注入代码
                                switch (item.type) {
                                case 'weixin': {
                                    resMap[item.uid] = !!$('.head_box .nickname').text();
                                    // weixin的话存储token
                                    if (resMap[item.uid]) {
                                        tokenMap[item.uid] = $('.head_box .nickname')
                                            .attr('href').split('token=')[1].split('&')[0];
                                    }
                                    break;
                                }
                                case 'weibo': {
                                    resMap[item.uid] = /\$CONFIG\['nick'\]='/.test(resp.body);
                                    break;
                                }
                                case 'omqq': {
                                    console.warn(resp.body);
                                    resMap[item.uid] = !!$('.header-login .name').text();
                                    break;
                                }
                                case 'qq': {
                                    resMap[item.uid] = !!$('.header_r .header_name').text();
                                    break;
                                }
                                case 'sohu': {
                                    resMap[item.uid] = !!$('.user-head .user-name').text();
                                    break;
                                }
                                case 'uc': {
                                    resMap[item.uid] = !!$('.header-user').text();
                                    break;
                                }
                                case 'jianshu': {
                                    resMap[item.uid] = !!$('.user.avatar img');
                                    break;
                                }
                                case 'yidianzixun': {
                                    resMap[item.uid] = !!$('.header .user-name').text();
                                    break;
                                }
                                case 'toutiao': {
                                    resMap[item.uid] = !!$('.shead_right .new_user_name').text();
                                    break;
                                }
                                case 'zhihu': {
                                    console.warn(resp.body);
                                    resMap[item.uid] = !!$('.zu-top-nav-userinfo .name').text();
                                    break;
                                }
                                case 'baijiahao': {
                                    console.warn(resp.body);
                                    resMap[item.uid] = !!$('.mp-header-user .name').text();
                                    break;
                                }
                                default: break;
                                }
                            } catch (e) {
                                console.warn(e);
                            }
                            resolve();
                        });
                    }));
                }
            }
        });
        // 限制网络请求
        // yield Promise.all(plist);
        while (plist.length) {
            const currentAccount = plist.pop();
            yield currentAccount;
        }
        const res = {
            login: [],
            unLogin: [],
            loginMap: resMap,
            tokenMap
        };
        Object.keys(resMap).forEach(uid => {
            if (resMap[uid]) {
                res.login.push(accountsMap[uid]);
            } else {
                res.unLogin.push(accountsMap[uid]);
            }
        });
        ctx.body = {
            res
        };
        yield next();
    }),
    getWeiXinAuthorList: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.getWeiXinAuthorList(ctx.message.token, ctx.message.verifyType);
        ctx.body = {
            res
        };
        yield next();
    }),
    // 获取微信群发二维码
    getBatchQrcode: co.wrap(function* (ctx, next) {
        const { user, token, id } = ctx.message;
        let error = '';
        let copyright = '';
        // 获取剩余请求次数
        // const resNum = yield ctx.app.PlatformApi.WeiXin.getBatchQrcodeNum(user, token);
        // console.warn('resNum');
        // console.warn(resNum);
        // if (resNum.base_resp.ret === 0) {
        //     error = 'no times';
        // // 提前中断，避免多余请求
        //     ctx.body = {
        //         error
        //     };
        //     yield next();
        //     return;
        // }
        // 检测版权 post
        yield ctx.app.PlatformApi.WeiXin.getCopyRight(user, token, id);
        const resCopyRight = yield ctx.app.PlatformApi.WeiXin.getCopyRight(user, token, id, true);
        console.warn('resCopyRight');
        console.warn(resCopyRight);
        if (resCopyRight.base_resp.err_msg !== 'default') {
            error = resCopyRight.base_resp.err_msg;
            copyright = resCopyRight.list;
        }
        // 检测广告 post
        const resCheckAd = yield ctx.app.PlatformApi.WeiXin.checkAd(user, token, id);
        console.warn('resCheckAd');
        console.warn(resCheckAd);
        if (resCheckAd.base_resp.err_msg !== 'ok') {
            error = resCheckAd.base_resp.err_msg;
        }
        // 获取ticket post, weixin发了两次
        const resTicket = yield ctx.app.PlatformApi.WeiXin.getBatchTicket(user, token);
        console.warn('resTicket');
        console.warn(resTicket);
        if (resTicket.base_resp.err_msg !== 'ok') {
            error = resTicket.base_resp.err_msg;
        }
        const ticket = resTicket.ticket;
        // 获取uuid post
        const resUuid = yield ctx.app.PlatformApi.WeiXin.getBatchUuid(user, token, ticket);
        console.warn('resUuid');
        console.warn(resUuid);
        const uuid = resUuid.uuid;
        // 构造二维码
        ctx.body = {
            url: `https://mp.weixin.qq.com/safe/safeqrcode?ticket=${ticket}&uuid=${uuid}&action=check&type=msgs&msgid=${id}`,
            error,
            uuid,
            copyright,
            operation_seq: resTicket.operation_seq
        };
        yield next();
    }),
    checkBatchQrcode: co.wrap(function* (ctx, next) {
        const { user, token, uuid, id, copyright, operation_seq } = ctx.message;
        const resQrcode = yield ctx.app.PlatformApi.WeiXin.checkBatchQrcode(user, token, uuid);
        console.warn('resQrcode');
        console.warn(resQrcode);
        const { errcode, code } = resQrcode;
        const list = copyright;
        if (errcode === 405) {
            const resFinish = yield ctx.app.PlatformApi.WeiXin.finishBatchSend(
                user,
                token,
                id,
                list,
                code,
                operation_seq
            );
            console.warn('resFinish');
            console.warn(resFinish);
            if (resFinish.base_resp.err_msg === 'system error') {
                ctx.body = {
                    status: 'error',
                    res: resFinish
                };
            } else {
                ctx.body = {
                    status: 'finish',
                    res: resFinish
                };
            }
            yield next();
            return;
        }
        ctx.body = {
            status: 'wait'
        };
        yield next();
    }),
    getUsableAccount: co.wrap(function* (ctx, next) {
        const { account, token } = ctx.message;
        if (!account) {
            ctx.body.account = undefined;
            yield next();
            return;
        }
        try {
            ctx.body.account = yield ctx.app.sendMessage({
                name: '/account/getLoginStatusList',
                uidList: [account.uid]
            }).then(res => {
                const { login } = res.body.res;
                if (login[0]) {
                    return login[0];
                }
                return null;
            });
            if (!ctx.body.account) {
                const cloudAccountInfo = yield ctx.app.WxbApi.getAccountSyncLogin(token, {
                    type: account.type,
                    media_id: account.uid
                }).then(res => {
                    console.log(res);
                    if (res.errcode || !res.data) {
                        return null;
                    }
                    return JSON.parse(ctx.app.WxbApi.decodeForCloud(res.data));
                });
                console.log('cloudAccountInfo', cloudAccountInfo);
                if (cloudAccountInfo) {
                    console.warn(cloudAccountInfo);
                    ctx.body.account = yield ctx.app.sendMessage('/account/save', {
                        html: null,
                        userInfo: Object.assign({}, account, cloudAccountInfo)
                    }).then(res => res.body);
                    console.log('user:::', ctx.body.account);
                    // yield AccountModel.updateAccount(account.uid, JSON.parse(JSON.stringify(cloudAccountInfo)));
                }
            }
            if (!ctx.body.account) {
                ctx.body.account = Object.assign({}, account);
            }
        } catch (e) {
            ctx.log('getUsableAccount', `token: ${token}; account: ${account}`, e);
        }
        yield next();
    }),
    saveUsableAccount: co.wrap(function* (ctx, next) {
        const { token } = ctx.message; // 微小宝的token
        if (!token) {
            yield next();
            return;
        }
        try {
            // ctx.body
            const data = ctx.app.WxbApi.encodeForCloud(JSON.stringify({
                cookies: ctx.body.cookies,
                token: ctx.body.token // 微信的token
            }));
            yield ctx.app.WxbApi.saveAccountSyncLogin(token, {
                media_id: ctx.body.uid,
                type: ctx.body.type,
                data
            }).then(res => {
                console.warn(res);
            });
        } catch (e) {
            ctx.log('saveUsableAccount', `token: ${token};uid: ${ctx.body}`, e);
        }
        yield next();
    })
};
