const co = require('co');
const fs = require('fs-extra');
const ImageModel = require('../model/Image');
const ReportDataModel = require('../model/ReportData');
const ArticleModel = require('../model/Article');
const MultiArticleModel = require('../model/MultiArticle');
const AccountModel = require('../model/Account');
const SyncModel = require('../model/Sync');
const CacheDataModel = require('../model/CacheData');
const DBMap = {
    images: ImageModel,
    reportdatas: ReportDataModel,
    articles: ArticleModel,
    multiarticles: MultiArticleModel,
    accounts: AccountModel,
    syncs: SyncModel,
    cachedatas: CacheDataModel
};
// function deleteFolderRecursive(path) {
//     let files = [];
//     if (fs.existsSync(path)) {
//         files = fs.readdirSync(path);
//         files.forEach((file) => {
//             const curPath = `${path}/${file}`;
//             if (fs.statSync(curPath).isDirectory()) { // recurse
//                 deleteFolderRecursive(curPath);
//             } else {
//                 fs.unlinkSync(curPath);
//             }
//         });
//         fs.rmdirSync(path);
//     }
// }
module.exports = {
    checkUpdate: co.wrap(function*(ctx, next) {
        const { WxbApi, manifest } = ctx.app;
        const { evn } = ctx.message;
        let checkUrl = manifest.checkUpdateUrl;
        if (evn) {
            checkUrl = checkUrl.replace('.json', `_${evn}.json`);
        }
        const res = yield WxbApi.hasNewVersion(manifest, checkUrl);
        ctx.body = res;
        yield next();
    }),
    clearWebViewCache: co.wrap(function*(ctx, next) {
        let isSuccess = false;
        const macPath = `${nw.App.dataPath}/Storage`;
        const winPath = `${nw.App.dataPath}\\User Data\\Default\\Storage`;
        const pathArr = [macPath, winPath];
        pathArr.forEach(path => {
            if (fs.existsSync(macPath)) {
                isSuccess = true;
                try {
                    fs.emptyDirSync(path);
                } catch (e) {
                    ctx.log(`webView路径:${path}`, e);
                }
            }
        });
        if (!isSuccess) {
            console.log('macPath:', macPath);
            console.log('winPath:', winPath);
            ctx.log('webView路径:', pathArr);
        }
        yield next();
    }),
    clearCache: co.wrap(function*(ctx, next) {
        const { dbList } = ctx.message;
        while (dbList.length) {
            const currentDb = dbList.pop();
            yield DBMap[currentDb].deleteMany({});
        }
        yield next();
    }),
};
