const co = require('co');
const ArticleModel = require('../model/Article');
// const AppConfigModel = require('../model/AppConfig');
const Util = require('../modules/util');
const PLAT_FORM = require('../config/platform');

function getPlatformList(model) {
    if (model) {
        return Object.keys(PLAT_FORM).filter(it => (it == 'weixin' || it == 'qq'));
    }

    return Object.keys(PLAT_FORM);
}

module.exports = {
    // migrationData: co.wrap(function*(ctx, next) {
    //     const articleList = yield ctx.app.ArticleService.getArticleList();
    //     let appConfig = yield AppConfigModel.findOne({});
    //     appConfig = appConfig ? appConfig.toJSON() : {};
    //     console.warn(articleList);
    //     if (articleList.total_rows > 0 && !appConfig.migrationArticleTag) {
    //         const plist = articleList.rows.map(item =>
    //             ArticleModel.addArticle(item.data)
    //         );
    //         yield Promise.all(plist);
    //         // 在nedb中标记已迁移状态
    //         appConfig.migrationArticleTag = true;
    //         console.warn('-----------article');
    //         yield AppConfigModel.findOneAndUpdate({
    //             _id: appConfig._id
    //         }, appConfig);
    //     }
    //     yield next();
    // }),
    // 检查是否有1.x版本的文章数据
    hasV1Articles: co.wrap(function*(ctx, next) {
        const articleList = yield ctx.app.ArticleService.getArticleList();
        ctx.body.hasV1Articles = articleList.total_rows > 0;
        yield next();
    }),
    getV1Articles: co.wrap(function*(ctx, next) {
        const articleList = yield ctx.app.ArticleService.getArticleList();
        let list = [];
        if (articleList.total_rows > 0) {
            list = articleList.rows.map(item => {
                const data = item.data;
                data._id = item._id;
                data.displayInfo = Util.Article.getV1ArticleDisplayInfo(data);
                return data;
            });
        }
        ctx.body = list;
        yield next();
    }),
    importV1Articles: co.wrap(function*(ctx, next) {
        ctx.log('数据迁移importV1Articles开始');
        // 导入数据转换
        let newArticle = ctx.message.data;
        try {
            // 转换封面字段
            newArticle.displayInfo.platform.forEach(type => {
                const res = newArticle[type];
                const typeMap = {
                    0: 1,
                    1: 2,
                    3: 3
                };
                if (res.covers && res.covers[0]) { // toutiao    单图或3图
                    // 转换covers里的字段
                    res.covers.forEach(c => {
                        if (c) {
                            c.url = c.file;
                            // delete res.file;
                            c.source = c.sourceurl;
                        }
                    });
                    res.cover = {
                        model: typeMap[res.covers.length],
                        type: 'select',
                        url: res.covers
                    };
                } else if (typeof(res.cover) === 'object') { // weixin， weibo
                    const url = res.cover.file;
                    res.cover.source = res.cover.sourceurl;
                    res.cover = {
                        type: 'normal',
                        url
                    };
                } else if (typeof(res.cover) === 'string') { // 其他单图
                    const url = Object.assign({}, res.cover);
                    res.cover = {
                        type: 'normal',
                        url
                    };
                } else if (!res.cover) { // toutiao    自动类型
                    res.cover = {
                        type: 'normal'
                    };
                }
                delete res.covers;
            });
        } catch (e) {
            ctx.log(e);
            throw new Error('转换数据错误');
        }

        try {
            let _stringArticle = JSON.stringify(newArticle);
            ctx.log({
                '图片上传开始': _stringArticle
            });
            // 上传本地图片
            const reg = /"file:\/\/(.*?)"/g;
            let match;
            const _localImgList = [];
            while (match = reg.exec(_stringArticle)) {
                _localImgList.push(match[1].split('\\')[0]);
            }
            const plist = [];
            const token = ctx.message.token;
            const _localImgListAbs = [...new Set(_localImgList)];
            _localImgListAbs.forEach(url => {
                plist.push(ctx.app.WxbApi.uploadImage(token, url));
            });
            const urlList = yield Promise.all(plist);

            // 替换链接
            urlList.forEach((url, index) => {
                const _localUrl = _localImgListAbs[index];
                const _reg = new RegExp(`file://${_localUrl}`, 'g');
                _stringArticle = _stringArticle.replace(_reg, url.full_url);
            });
            newArticle = JSON.parse(_stringArticle);

            newArticle.createtime = new Date();
            newArticle.updatetime = new Date();
            // 存入数据库
            yield ArticleModel.addArticle(newArticle);
            yield next();
        } catch (e) {
            console.log(e);
            ctx.log(e);
            throw new Error('您的数据或许被损坏了');
        }
    }),
    addArticle: co.wrap(function*(ctx, next) {
        const article = yield ArticleModel.addArticle(ctx.message.data);
        ctx.body = {
            article
        };
        yield next();
    }),
    getArticle: co.wrap(function*(ctx, next) {
        const article = yield ArticleModel.findOne(
            ctx.message.query,
            ctx.message.options
        );
        ctx.body = {
            article
        };
        yield next();
    }),
    getArticles: co.wrap(function*(ctx, next) {
        const articles = yield ArticleModel.find(
            ctx.message.query,
            ctx.message.options || { sort: '-createtime' }
        );
        ctx.body = {
            articles
        };
        yield next();
    }),
    getArticleList: co.wrap(function*(ctx, next) {
        ctx.log('获取文章列表成功');
        const {
            query = {},
            options = {}
        } = ctx.message;
        options.sort = '-createtime';
        options.populate = true;
        if (options.page) {
            options.limit = options.page.limit || 10;
            if (options.page.page) {
                options.skip = (options.page.page - 1) * options.limit;
            }
            delete options.page;
        }
        const articleList = yield ArticleModel.find(query, options).catch(e => {
            console.log(e);
        });
        ctx.body = {
            rows: articleList,
            total_rows: yield ArticleModel.count(query) || 0
        };
        yield next();
    }),
    getArticleByServerId: co.wrap(function* (ctx, next) {
        // const article = yield ArticleModel.findOne(ctx.message.query, ctx.message.options).then(l => {
        //     return l;
        // });
        // ctx.body = {
        //     article
        // };
        yield next();
    }),
    searchByTitle: co.wrap(function* (ctx, next) {
        const articles = yield ArticleModel.find(ctx.message.query);
        ctx.body = {
            articles
        };
        yield next();
    }),
    removeArticle: co.wrap(function* (ctx, next) {
        const deleteRes = ArticleModel.deleteOne({
            _id: ctx.message.data._id
        });
        console.log(deleteRes);
        yield next();
    }),
    removeArticleByLocalId: co.wrap(function* (ctx, next) {
        yield next();
    }),
    updateArticle: co.wrap(function* (ctx, next) {
        yield next();
    }),
    replaceArticle: co.wrap(function* (ctx, next) {
        yield next();
    }),
    getTempArticle: co.wrap(function* (ctx, next) {
        const temp = yield ctx.app.sendMessage({
            name: '/temp/get',
            type: 'editorArticle'
        }).then(res => res.body);

        if (temp) {
            const check = yield ctx.app.sendMessage({
                name: '/article/checkArticle',
                article: temp.article,
                model: temp.type === 'single' ? 0 : 1
            }).then(res => res.body);

            temp.article = check.article;
            temp.checked = check.status;
        }

        ctx.body = temp;
        yield next();
    }),
    checkArticle: co.wrap(function* (ctx, next) {
        const { article, model } = ctx.message;
        let hasVal = false;

        function checkCover(cover) {
            switch (cover.type) {
            case 'normal':
                if (!cover.url) {
                    return false;
                }
                break;
            default:
            }

            return true;
        }

        const platformList = getPlatformList(model);
        Object.keys(article).forEach(item => {
            if (model === 1) {
                if (platformList.includes(item) && article[item]) {
                    const articleItem = [];
                    article[item].forEach(it => {
                        if (it.title || it.content) {
                            hasVal = true;
                            articleItem.push(it);
                        }
                        if (it.cover && !checkCover(it.cover)) {
                            delete it.cover;
                        }
                    });
                    if (articleItem.length) {
                        article[item] = articleItem;
                    } else {
                        delete article[item];
                    }
                }
            } else {
                if (platformList.includes(item)) {
                    if (article[item]) {
                        if (article[item].title || article[item].content) {
                            hasVal = true;
                        } else {
                            delete article[item];
                        }
                    }
                }
            }
        });

        ctx.body = { status: hasVal, article };
        yield next();
    }),
    saveArticle: co.wrap(function* (ctx, next) {
        console.log('saveArticle::', ctx.message);
        const article = yield ArticleModel.saveArticle(ctx.message.query, ctx.message.data);
        ctx.body = {
            article
        };
        console.log(article);
        yield next();
    }),
    saveArticleCloudId: co.wrap(function* (ctx, next) {
        // const { id, cloudId } = ctx.message;
        // 是否有必要，似乎要调整
        // yield Article
        yield next();
    }),
    clearAll: co.wrap(function* (ctx, next) {
        yield next();
    })
};
