const co = require('co');
const moment = require('moment');
moment.locale('zh-cn');
module.exports = {
    getFavoriteGroup: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.getFavoriteGroup(ctx.message.token);
        ctx.body = {
            groupList: res.data
        };
        yield next();
    }),
    updateFavoriteGroup: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.updateFavoriteGroup(ctx.message.token, ctx.message.id, ctx.message.groupName);
        ctx.body = {
            res
        };
        yield next();
    }),
    addFavoriteGroup: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.addFavoriteGroup(ctx.message.token, ctx.message.groupName);
        ctx.body = {
            res
        };
        yield next();
    }),
    delFavoriteGroup: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.delFavoriteGroup(ctx.message.token, ctx.message.id);
        ctx.body = {
            res
        };
        yield next();
    }),
    getFavoriteList: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.getFavoriteList(
            ctx.message.token,
            ctx.message.groupId,
            ctx.message.args
        );
        ctx.body = {
            favoriteList: res.data.map(item => ({
                key: item.id,
                article: item,
                releaseTime: moment(item.push_time * 1000).fromNow(),
            })),
            pager: res.pager
        };
        yield next();
    }),
    addFavorite: co.wrap(function* (ctx, next) {
        let articleId = '';
        if (ctx.message.opt._id) {
            articleId = ctx.message.opt._id;
        } else {
            articleId = ctx.message.opt.id;
        }
        const res = yield ctx.app.WxbApi.addFavorite(ctx.message.token, {
            source_id: articleId,
            account: ctx.message.opt.account || ctx.message.opt.weixin_name || ctx.message.opt.gzh_name,
            is_original: ctx.message.opt.is_original,
            article_title: ctx.message.opt.title || ctx.message.opt.article_title,
            article_url: ctx.message.opt.url || ctx.message.opt.article_url,
            group_id: ctx.message.groupID,
            content_type: ctx.message.opt.content_type,
            push_time: ctx.message.opt.push_time,
        });
        ctx.body = {
            res
        };
        console.log(res);
        yield next();
    }),
    delFavorite: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.delFavorite(ctx.message.token, ctx.message.sourceId);
        ctx.body = {
            res
        };
        yield next();
    }),
    moveFavoriteToGroup: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.moveFavoriteToGroup(
            ctx.message.token,
            ctx.message.articleIds,
            ctx.message.groupId
        );

        ctx.body = {
            res
        };

        yield next();
    }),
};
